/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.ScopeBasedTodosTreeBuilder;
import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.scopeChooser.IgnoringComboBox;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.Nullable;

public class ScopeBasedTodosPanel
extends TodoPanel {
    private static final String SELECTED_SCOPE = "TODO_SCOPE";
    private final Alarm myAlarm;
    private JComboBox myScopes;
    private final NamedScopesHolder.ScopeListener myScopeListener;
    private final NamedScopeManager myNamedScopeManager;
    private final DependencyValidationManager myValidationManager;

    public ScopeBasedTodosPanel(final Project project, TodoPanelSettings settings, Content content) {
        super(project, settings, false, content);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, (Disposable)project);
        String scopeName = PropertiesComponent.getInstance((Project)project).getValue(SELECTED_SCOPE);
        this.rebuildModel(project, scopeName);
        this.myScopeListener = new NamedScopesHolder.ScopeListener(){

            public void scopesChanged() {
                ScopeWrapper scope = (ScopeWrapper)ScopeBasedTodosPanel.this.myScopes.getSelectedItem();
                ScopeBasedTodosPanel.this.rebuildModel(project, scope != null ? scope.getName() : null);
            }
        };
        this.myNamedScopeManager = NamedScopeManager.getInstance((Project)project);
        this.myNamedScopeManager.addScopeListener(this.myScopeListener);
        this.myValidationManager = DependencyValidationManager.getInstance((Project)project);
        this.myValidationManager.addScopeListener(this.myScopeListener);
        this.myScopes.setRenderer(new ListCellRendererWrapper<ScopeWrapper>(){

            public void customize(JList list, ScopeWrapper value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getName());
                if (value.isSeparator()) {
                    this.setSeparator();
                }
            }
        });
        this.myScopes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopeBasedTodosPanel.this.rebuildWithAlarm(ScopeBasedTodosPanel.this.myAlarm);
                ScopeWrapper selectedItem = (ScopeWrapper)ScopeBasedTodosPanel.this.myScopes.getSelectedItem();
                if (selectedItem != null) {
                    PropertiesComponent.getInstance((Project)ScopeBasedTodosPanel.this.myProject).setValue(ScopeBasedTodosPanel.SELECTED_SCOPE, selectedItem.getName());
                }
            }
        });
        this.rebuildWithAlarm(this.myAlarm);
    }

    @Override
    public void dispose() {
        this.myNamedScopeManager.removeScopeListener(this.myScopeListener);
        this.myValidationManager.removeScopeListener(this.myScopeListener);
        super.dispose();
    }

    private void rebuildModel(Project project, String scopeName) {
        ArrayList<ScopeWrapper> scopes = new ArrayList<ScopeWrapper>();
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)project);
        scopes.add(new ScopeWrapper("Predefined Scopes"));
        List predefinedScopesList = manager.getPredefinedScopes();
        NamedScope[] predefinedScopes = predefinedScopesList.toArray(new NamedScope[predefinedScopesList.size()]);
        for (NamedScope predefinedScope : predefinedScopes = NonProjectFilesScope.removeFromList((NamedScope[])predefinedScopes)) {
            scopes.add(new ScopeWrapper(predefinedScope));
        }
        ScopeBasedTodosPanel.collectEditableScopes(scopes, (NamedScopesHolder)manager, "Custom Project Scopes");
        ScopeBasedTodosPanel.collectEditableScopes(scopes, (NamedScopesHolder)NamedScopeManager.getInstance((Project)project), "Custom Local Scopes");
        this.myScopes.setModel(new DefaultComboBoxModel<ScopeWrapper>(scopes.toArray(new ScopeWrapper[scopes.size()])));
        this.setSelection(scopeName, scopes);
    }

    private void setSelection(@Nullable String scopeName, ArrayList<ScopeWrapper> scopes) {
        boolean hasNonSeparators = false;
        for (ScopeWrapper scope : scopes) {
            if (scope.isSeparator()) continue;
            hasNonSeparators = true;
            if (scopeName != null && !scopeName.equals(scope.getName())) continue;
            this.myScopes.setSelectedItem(scope);
            return;
        }
        assert (hasNonSeparators);
        this.setSelection(null, scopes);
    }

    private static void collectEditableScopes(ArrayList<ScopeWrapper> scopes, NamedScopesHolder manager, String separatorTitle) {
        NamedScope[] editableScopes = manager.getEditableScopes();
        if (editableScopes.length > 0) {
            scopes.add(new ScopeWrapper(separatorTitle));
            for (NamedScope scope : editableScopes) {
                scopes.add(new ScopeWrapper(scope));
            }
        }
    }

    @Override
    protected JComponent createCenterComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        JComponent component = super.createCenterComponent();
        panel.add((Component)component, "Center");
        this.myScopes = new IgnoringComboBox(){

            @Override
            protected boolean isIgnored(Object item) {
                return item instanceof ScopeWrapper && ((ScopeWrapper)item).isSeparator();
            }
        };
        JPanel chooserPanel = new JPanel(new GridBagLayout());
        JLabel scopesLabel = new JLabel("Scope:");
        scopesLabel.setDisplayedMnemonic('S');
        scopesLabel.setLabelFor(this.myScopes);
        GridBagConstraints gc = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
        chooserPanel.add((Component)scopesLabel, gc);
        chooserPanel.add((Component)this.myScopes, gc);
        gc.fill = 2;
        gc.weightx = 1.0;
        chooserPanel.add((Component)Box.createHorizontalBox(), gc);
        panel.add((Component)chooserPanel, "North");
        return panel;
    }

    @Override
    protected TodoTreeBuilder createTreeBuilder(JTree tree, DefaultTreeModel treeModel, Project project) {
        ScopeBasedTodosTreeBuilder builder = new ScopeBasedTodosTreeBuilder(tree, treeModel, project, this.myScopes);
        builder.init();
        return builder;
    }

    public static class ScopeWrapper {
        private final String myName;
        private final boolean mySeparator;
        private NamedScope myNamedScope;

        private ScopeWrapper(NamedScope namedScope) {
            this.mySeparator = false;
            this.myNamedScope = namedScope;
            this.myName = this.myNamedScope.getName();
        }

        private ScopeWrapper(String name) {
            this.mySeparator = true;
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        public NamedScope getNamedScope() {
            return this.myNamedScope;
        }

        public boolean isSeparator() {
            return this.mySeparator;
        }
    }
}

