/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PsiMethodTreeElement
extends JavaClassTreeElementBase<PsiMethod>
implements SortableTreeElement {
    public PsiMethodTreeElement(PsiMethod method, boolean isInherited) {
        super(isInherited, method);
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        final ArrayList<StructureViewTreeElement> result = new ArrayList<StructureViewTreeElement>();
        PsiMethod element = (PsiMethod)this.getElement();
        if (element == null || element instanceof SyntheticElement) {
            ArrayList<StructureViewTreeElement> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/PsiMethodTreeElement", "getChildrenBase"));
            }
            return arrayList;
        }
        TextRange range = element.getTextRange();
        if (range == null) {
            ArrayList<StructureViewTreeElement> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/PsiMethodTreeElement", "getChildrenBase"));
            }
            return arrayList;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null || psiFile instanceof PsiCompiledElement) {
            ArrayList<StructureViewTreeElement> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/PsiMethodTreeElement", "getChildrenBase"));
            }
            return arrayList;
        }
        String fileText = psiFile.getText();
        if (fileText == null) {
            ArrayList<StructureViewTreeElement> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/PsiMethodTreeElement", "getChildrenBase"));
            }
            return arrayList;
        }
        if (!range.substring(fileText).contains("class")) {
            ArrayList<StructureViewTreeElement> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/PsiMethodTreeElement", "getChildrenBase"));
            }
            return arrayList;
        }
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(PsiClass aClass) {
                if (!(aClass instanceof PsiAnonymousClass) && !(aClass instanceof PsiTypeParameter)) {
                    result.add(new JavaClassTreeElement(aClass, PsiMethodTreeElement.this.isInherited(), new HashSet<PsiClass>(Arrays.asList(aClass.getSupers()))));
                }
            }
        });
        ArrayList<StructureViewTreeElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/PsiMethodTreeElement", "getChildrenBase"));
        }
        return arrayList;
    }

    public String getPresentableText() {
        String method = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)this.getElement()), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)263, (int)2);
        return StringUtil.replace((String)method, (String)":", (String)": ");
    }

    @Override
    public String getLocationString() {
        if (!Registry.is((String)"show.method.base.class.in.java.file.structure")) {
            return null;
        }
        PsiMethod method = (PsiMethod)this.getElement();
        if (this.myLocation == null) {
            if (this.isInherited()) {
                return super.getLocationString();
            }
            try {
                PsiMethod base;
                PsiClass baseClass;
                MethodSignatureBackedByPsiMethod baseMethod = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
                if (baseMethod != null && !method.isEquivalentTo((PsiElement)baseMethod.getMethod()) && (baseClass = (base = baseMethod.getMethod()).getContainingClass()) != null && baseClass.getMethods().length > 1) {
                    this.myLocation = baseClass.getName();
                }
            }
            catch (IndexNotReadyException e) {
                // empty catch block
            }
            if (StringUtil.isEmpty((String)this.myLocation)) {
                this.myLocation = "";
            } else {
                char upArrow = '\u2191';
                this.myLocation = UIUtil.getLabelFont().canDisplay(upArrow) ? upArrow + this.myLocation : this.myLocation;
            }
        }
        return StringUtil.isEmpty((String)this.myLocation) ? null : this.myLocation;
    }

    @Override
    public TextAttributesKey getTextAttributesKey() {
        if (this.isInherited()) {
            return CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
        }
        return super.getTextAttributesKey();
    }

    public PsiMethod getMethod() {
        return (PsiMethod)this.getElement();
    }

    @NotNull
    public String getAlphaSortKey() {
        PsiMethod method = (PsiMethod)this.getElement();
        if (method != null) {
            String string = method.getName() + " " + StringUtil.join((Object[])method.getParameterList().getParameters(), (Function)new Function<PsiParameter, String>(){

                public String fun(PsiParameter psiParameter) {
                    PsiTypeElement typeElement = psiParameter.getTypeElement();
                    return typeElement != null ? typeElement.getText() : "";
                }
            }, (String)" ");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/PsiMethodTreeElement", "getAlphaSortKey"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/PsiMethodTreeElement", "getAlphaSortKey"));
        }
        return "";
    }

    @Override
    public String getLocationPrefix() {
        return " ";
    }

    @Override
    public String getLocationSuffix() {
        return "";
    }
}

