/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.impl;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.SmartList;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StartupManagerImpl
extends StartupManagerEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.startup.impl.StartupManagerImpl");
    private final List<Runnable> myPreStartupActivities = Collections.synchronizedList(new ArrayList());
    private final List<Runnable> myStartupActivities = new ArrayList<Runnable>();
    private final List<Runnable> myDumbAwarePostStartupActivities = Collections.synchronizedList(new ArrayList());
    private final List<Runnable> myNotDumbAwarePostStartupActivities = Collections.synchronizedList(new ArrayList());
    private boolean myPostStartupActivitiesPassed = false;
    private final List<CacheUpdater> myCacheUpdaters = new LinkedList<CacheUpdater>();
    private volatile boolean myPreStartupActivitiesPassed = false;
    private volatile boolean myStartupActivitiesRunning = false;
    private volatile boolean myStartupActivitiesPassed = false;
    private final Project myProject;

    public StartupManagerImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void registerPreStartupActivity(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/startup/impl/StartupManagerImpl", "registerPreStartupActivity"));
        }
        LOG.assertTrue(!this.myPreStartupActivitiesPassed, (Object)"Registering pre startup activity that will never be run");
        this.myPreStartupActivities.add(runnable);
    }

    public void registerStartupActivity(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/startup/impl/StartupManagerImpl", "registerStartupActivity"));
        }
        LOG.assertTrue(!this.myStartupActivitiesPassed, (Object)"Registering startup activity that will never be run");
        this.myStartupActivities.add(runnable);
    }

    public synchronized void registerPostStartupActivity(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/startup/impl/StartupManagerImpl", "registerPostStartupActivity"));
        }
        LOG.assertTrue(!this.myPostStartupActivitiesPassed, (Object)"Registering post-startup activity that will never be run");
        (DumbService.isDumbAware((Object)runnable) ? this.myDumbAwarePostStartupActivities : this.myNotDumbAwarePostStartupActivities).add(runnable);
    }

    @Override
    public void registerCacheUpdater(@NotNull CacheUpdater updater) {
        if (updater == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/startup/impl/StartupManagerImpl", "registerCacheUpdater"));
        }
        LOG.assertTrue(!this.myStartupActivitiesPassed, (Object)(CacheUpdater.class.getSimpleName() + " must be registered before startup activity finished"));
        this.myCacheUpdaters.add(updater);
    }

    @Override
    public boolean startupActivityRunning() {
        return this.myStartupActivitiesRunning;
    }

    @Override
    public boolean startupActivityPassed() {
        return this.myStartupActivitiesPassed;
    }

    @Override
    public synchronized boolean postStartupActivityPassed() {
        return this.myPostStartupActivitiesPassed;
    }

    public void runStartupActivities() {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HeavyProcessLatch.INSTANCE.processStarted();
                try {
                    StartupManagerImpl.runActivities(StartupManagerImpl.this.myPreStartupActivities);
                    StartupManagerImpl.this.myPreStartupActivitiesPassed = true;
                    StartupManagerImpl.this.myStartupActivitiesRunning = true;
                    StartupManagerImpl.runActivities(StartupManagerImpl.this.myStartupActivities);
                    StartupManagerImpl.this.myStartupActivitiesRunning = false;
                    StartupManagerImpl.this.myStartupActivitiesPassed = true;
                }
                finally {
                    HeavyProcessLatch.INSTANCE.processFinished();
                }
            }
        });
    }

    public void runPostStartupActivitiesFromExtensions() {
        StartupActivity[] extensions = (StartupActivity[])Extensions.getExtensions((ExtensionPointName)StartupActivity.POST_STARTUP_ACTIVITY);
        if (extensions.length == 0) {
            return;
        }
        ArrayList<Runnable> dumbAwareActivities = new ArrayList<Runnable>();
        final ArrayList<2> normalActivities = new ArrayList<2>();
        for (final StartupActivity extension : extensions) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!StartupManagerImpl.this.myProject.isDisposed()) {
                        extension.runActivity(StartupManagerImpl.this.myProject);
                    }
                }
            };
            if (extension instanceof DumbAware) {
                dumbAwareActivities.add(runnable);
                continue;
            }
            normalActivities.add(runnable);
        }
        StartupManagerImpl.runActivities(dumbAwareActivities);
        if (!normalActivities.isEmpty()) {
            DumbService.getInstance((Project)this.myProject).runWhenSmart(new Runnable(){

                @Override
                public void run() {
                    if (!StartupManagerImpl.this.myProject.isDisposed()) {
                        StartupManagerImpl.runActivities(normalActivities);
                    }
                }
            });
        }
    }

    public synchronized void runPostStartupActivities() {
        final Application app = ApplicationManager.getApplication();
        if (this.myPostStartupActivitiesPassed) {
            return;
        }
        StartupManagerImpl.runActivities(this.myDumbAwarePostStartupActivities);
        DumbService.getInstance((Project)this.myProject).runWhenSmart(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StartupManagerImpl startupManagerImpl = StartupManagerImpl.this;
                synchronized (startupManagerImpl) {
                    app.assertIsDispatchThread();
                    if (StartupManagerImpl.this.myProject.isDisposed()) {
                        return;
                    }
                    StartupManagerImpl.runActivities(StartupManagerImpl.this.myDumbAwarePostStartupActivities);
                    StartupManagerImpl.runActivities(StartupManagerImpl.this.myNotDumbAwarePostStartupActivities);
                    StartupManagerImpl.this.myPostStartupActivitiesPassed = true;
                }
            }
        });
        if (!app.isUnitTestMode() && !this.myProject.isDisposed()) {
            if (!app.isHeadlessEnvironment()) {
                this.checkProjectRoots();
                final long sessionId = VirtualFileManager.getInstance().asyncRefresh(null);
                final MessageBusConnection connection = app.getMessageBus().connect();
                connection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener.Adapter(){

                    public void afterProjectClosed(@NotNull Project project) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/startup/impl/StartupManagerImpl$5", "afterProjectClosed"));
                        }
                        RefreshQueue.getInstance().cancelSession(sessionId);
                        connection.disconnect();
                    }
                });
            } else {
                VirtualFileManager.getInstance().syncRefresh();
            }
        }
        Registry.get((String)"ide.firstStartup").setValue(false);
    }

    private void checkProjectRoots() {
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (!(fs instanceof LocalFileSystemImpl)) {
            return;
        }
        FileWatcher watcher = ((LocalFileSystemImpl)fs).getFileWatcher();
        if (!watcher.isOperational()) {
            return;
        }
        List<String> manualWatchRoots = watcher.getManualWatchRoots();
        if (manualWatchRoots.isEmpty()) {
            return;
        }
        VirtualFile[] roots = ProjectRootManager.getInstance((Project)this.myProject).getContentRoots();
        if (roots.length == 0) {
            return;
        }
        SmartList nonWatched = new SmartList();
        for (VirtualFile root : roots) {
            if (!(root.getFileSystem() instanceof LocalFileSystem)) continue;
            String rootPath = root.getPath();
            for (String manualWatchRoot : manualWatchRoots) {
                if (!FileUtil.isAncestor((String)manualWatchRoot, (String)rootPath, (boolean)false)) continue;
                nonWatched.add(rootPath);
            }
        }
        if (!nonWatched.isEmpty()) {
            String message = ApplicationBundle.message((String)"watcher.non.watchable.project", (Object[])new Object[0]);
            watcher.notifyOnFailure(message, null);
            LOG.info("unwatched roots: " + nonWatched);
            LOG.info("manual watches: " + manualWatchRoots);
        }
    }

    public void startCacheUpdate() {
        try {
            DumbServiceImpl.getInstance(this.myProject).queueCacheUpdateInDumbMode(this.myCacheUpdaters);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    private static void runActivities(@NotNull List<Runnable> activities) {
        if (activities == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/startup/impl/StartupManagerImpl", "runActivities"));
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        while (!activities.isEmpty()) {
            Runnable runnable = activities.remove(0);
            if (indicator != null) {
                indicator.checkCanceled();
            }
            try {
                runnable.run();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable ex) {
                LOG.error(ex);
            }
        }
    }

    public synchronized void runWhenProjectIsInitialized(final @NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/startup/impl/StartupManagerImpl", "runWhenProjectIsInitialized"));
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return;
        }
        Object runnable = DumbService.isDumbAware((Object)action) ? new DumbAwareRunnable(){

            public void run() {
                action.run();
            }
        } : new Runnable(){

            @Override
            public void run() {
                action.run();
            }
        };
        if (this.myProject.isInitialized() || application.isUnitTestMode() && this.myPostStartupActivitiesPassed) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable((Runnable)runnable){
                final /* synthetic */ Runnable val$runnable;
                {
                    this.val$runnable = runnable;
                }

                @Override
                public void run() {
                    if (!StartupManagerImpl.this.myProject.isDisposed()) {
                        this.val$runnable.run();
                    }
                }
            });
        } else {
            this.registerPostStartupActivity((Runnable)runnable);
        }
    }

    public synchronized void prepareForNextTest() {
        this.myPreStartupActivities.clear();
        this.myStartupActivities.clear();
        this.myDumbAwarePostStartupActivities.clear();
        this.myNotDumbAwarePostStartupActivities.clear();
        this.myCacheUpdaters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkCleared() {
        try {
            assert (this.myStartupActivities.isEmpty()) : "Activities: " + this.myStartupActivities;
            assert (this.myDumbAwarePostStartupActivities.isEmpty()) : "DumbAware Post Activities: " + this.myDumbAwarePostStartupActivities;
            assert (this.myNotDumbAwarePostStartupActivities.isEmpty()) : "Post Activities: " + this.myNotDumbAwarePostStartupActivities;
            assert (this.myPreStartupActivities.isEmpty()) : "Pre Activities: " + this.myPreStartupActivities;
        }
        finally {
            this.prepareForNextTest();
        }
    }
}

