/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectViewDirectoryHelper {
    protected static final Logger LOG = Logger.getInstance((String)("#" + ProjectViewDirectoryHelper.class.getName()));
    private final Project myProject;
    private final DirectoryIndex myIndex;

    public static ProjectViewDirectoryHelper getInstance(Project project) {
        return (ProjectViewDirectoryHelper)ServiceManager.getService((Project)project, ProjectViewDirectoryHelper.class);
    }

    public ProjectViewDirectoryHelper(Project project, DirectoryIndex index) {
        this.myProject = project;
        this.myIndex = index;
    }

    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public String getLocationString(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/ProjectViewDirectoryHelper", "getLocationString"));
        }
        VirtualFile directory = psiDirectory.getVirtualFile();
        VirtualFile contentRootForFile = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getContentRootForFile(directory);
        if (Comparing.equal((Object)contentRootForFile, (Object)psiDirectory)) {
            return directory.getPresentableUrl();
        }
        return null;
    }

    public boolean isShowFQName(ViewSettings settings, Object parentValue, PsiDirectory value) {
        return false;
    }

    @Nullable
    public String getNodeName(ViewSettings settings, Object parentValue, PsiDirectory directory) {
        return directory.getName();
    }

    public boolean skipDirectory(PsiDirectory directory) {
        return true;
    }

    public boolean isEmptyMiddleDirectory(PsiDirectory directory, boolean strictlyEmpty) {
        return false;
    }

    public boolean supportsFlattenPackages() {
        return false;
    }

    public boolean supportsHideEmptyMiddlePackages() {
        return false;
    }

    public boolean canRepresent(Object element, PsiDirectory directory) {
        if (element instanceof VirtualFile) {
            VirtualFile vFile = (VirtualFile)element;
            return Comparing.equal((Object)directory.getVirtualFile(), (Object)vFile);
        }
        return false;
    }

    public Collection<AbstractTreeNode> getDirectoryChildren(PsiDirectory psiDirectory, ViewSettings settings, boolean withSubDirectories) {
        ModuleFileIndex moduleFileIndex;
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        Project project = psiDirectory.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = fileIndex.getModuleForFile(psiDirectory.getVirtualFile());
        ModuleFileIndex moduleFileIndex2 = moduleFileIndex = module == null ? null : ModuleRootManager.getInstance((Module)module).getFileIndex();
        if (!settings.isFlattenPackages() || this.skipDirectory(psiDirectory)) {
            this.processPsiDirectoryChildren(psiDirectory, this.directoryChildrenInProject(psiDirectory), children, fileIndex, null, settings, withSubDirectories);
        } else {
            PsiDirectory[] subdirs;
            PsiDirectory parentDir = psiDirectory.getParentDirectory();
            if (parentDir == null || this.skipDirectory(parentDir) && withSubDirectories) {
                this.addAllSubpackages(children, psiDirectory, moduleFileIndex, settings);
            }
            for (PsiDirectory subdir : subdirs = psiDirectory.getSubdirectories()) {
                VirtualFile directoryFile;
                if (!this.skipDirectory(subdir) || fileIndex.isIgnored(directoryFile = subdir.getVirtualFile()) || !withSubDirectories) continue;
                children.add((AbstractTreeNode)new PsiDirectoryNode(project, subdir, settings));
            }
            this.processPsiDirectoryChildren(psiDirectory, (PsiElement[])psiDirectory.getFiles(), children, fileIndex, moduleFileIndex, settings, withSubDirectories);
        }
        return children;
    }

    public List<VirtualFile> getTopLevelRoots() {
        ArrayList<VirtualFile> topLevelContentRoots = new ArrayList<VirtualFile>();
        ProjectRootManager prm = ProjectRootManager.getInstance((Project)this.myProject);
        ProjectFileIndex index = prm.getFileIndex();
        for (VirtualFile root : prm.getContentRoots()) {
            VirtualFile parent = root.getParent();
            if (parent != null && index.isInContent(parent)) continue;
            topLevelContentRoots.add(root);
        }
        return topLevelContentRoots;
    }

    private PsiElement[] directoryChildrenInProject(PsiDirectory psiDirectory) {
        VirtualFile dir = psiDirectory.getVirtualFile();
        if (this.myIndex.getInfoForDirectory(dir) != null) {
            return psiDirectory.getChildren();
        }
        PsiManager manager = psiDirectory.getManager();
        THashSet directoriesOnTheWayToContentRoots = new THashSet();
        Iterator<VirtualFile> i$ = this.getTopLevelRoots().iterator();
        while (i$.hasNext()) {
            VirtualFile root;
            VirtualFile current = root = i$.next();
            while (current != null) {
                PsiDirectory psi;
                VirtualFile parent = current.getParent();
                if (Comparing.equal((Object)parent, (Object)dir) && (psi = manager.findDirectory(current)) != null) {
                    directoriesOnTheWayToContentRoots.add(psi);
                }
                current = parent;
            }
        }
        return PsiUtilCore.toPsiElementArray((Collection)directoriesOnTheWayToContentRoots);
    }

    public void processPsiDirectoryChildren(PsiDirectory psiDir, PsiElement[] children, List<AbstractTreeNode> container, ProjectFileIndex projectFileIndex, ModuleFileIndex moduleFileIndex, ViewSettings viewSettings, boolean withSubDirectories) {
        for (PsiElement child : children) {
            VirtualFile vFile;
            LOG.assertTrue(child.isValid());
            if (child instanceof PsiFile) {
                vFile = ((PsiFile)child).getVirtualFile();
                this.addNode(moduleFileIndex, projectFileIndex, psiDir, vFile, container, PsiFileNode.class, child, viewSettings);
                continue;
            }
            if (child instanceof PsiDirectory) {
                if (!withSubDirectories) continue;
                PsiDirectory dir = (PsiDirectory)child;
                vFile = dir.getVirtualFile();
                if (!vFile.equals(projectFileIndex.getSourceRootForFile(vFile)) && viewSettings.isHideEmptyMiddlePackages() && !this.skipDirectory(psiDir) && this.isEmptyMiddleDirectory(dir, true)) {
                    this.processPsiDirectoryChildren(dir, this.directoryChildrenInProject(dir), container, projectFileIndex, moduleFileIndex, viewSettings, withSubDirectories);
                    continue;
                }
                this.addNode(moduleFileIndex, projectFileIndex, psiDir, vFile, container, PsiDirectoryNode.class, child, viewSettings);
                continue;
            }
            LOG.error("Either PsiFile or PsiDirectory expected as a child of " + child.getParent() + ", but was " + child);
        }
    }

    public void addNode(ModuleFileIndex moduleFileIndex, ProjectFileIndex projectFileIndex, PsiDirectory psiDir, VirtualFile vFile, List<AbstractTreeNode> container, Class<? extends AbstractTreeNode> nodeClass, PsiElement element, ViewSettings settings) {
        if (vFile == null) {
            return;
        }
        if (moduleFileIndex != null && !moduleFileIndex.isInContent(vFile)) {
            return;
        }
        try {
            container.add(ProjectViewNode.createTreeNode(nodeClass, (Project)element.getProject(), (Object)element, (ViewSettings)settings));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public void addAllSubpackages(List<AbstractTreeNode> container, PsiDirectory dir, ModuleFileIndex moduleFileIndex, ViewSettings viewSettings) {
        PsiDirectory[] subdirs;
        Project project = dir.getProject();
        for (PsiDirectory subdir : subdirs = dir.getSubdirectories()) {
            if (this.skipDirectory(subdir)) continue;
            if (moduleFileIndex != null && !moduleFileIndex.isInContent(subdir.getVirtualFile())) {
                container.add((AbstractTreeNode)new PsiDirectoryNode(project, subdir, viewSettings));
                continue;
            }
            if (viewSettings.isHideEmptyMiddlePackages()) {
                if (!this.isEmptyMiddleDirectory(subdir, false)) {
                    container.add((AbstractTreeNode)new PsiDirectoryNode(project, subdir, viewSettings));
                }
            } else {
                container.add((AbstractTreeNode)new PsiDirectoryNode(project, subdir, viewSettings));
            }
            this.addAllSubpackages(container, subdir, moduleFileIndex, viewSettings);
        }
    }
}

