/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageElementNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.TreeViewUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageUtil {
    @NotNull
    public static PsiPackage[] getSubpackages(@NotNull PsiPackage aPackage, @Nullable Module module, @NotNull Project project, boolean searchInLibraries) {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getSubpackages"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getSubpackages"));
        }
        PsiDirectory[] dirs = PackageUtil.getDirectories(aPackage, project, module, searchInLibraries);
        HashSet<PsiPackage> subpackages = new HashSet<PsiPackage>();
        for (PsiDirectory dir : dirs) {
            PsiDirectory[] subdirectories;
            for (PsiDirectory subdirectory : subdirectories = dir.getSubdirectories()) {
                String name;
                PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(subdirectory);
                if (psiPackage == null || (name = psiPackage.getName()) == null || name.isEmpty()) continue;
                subpackages.add(psiPackage);
            }
        }
        PsiPackage[] psiPackageArray = subpackages.toArray(new PsiPackage[subpackages.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getSubpackages"));
        }
        return psiPackageArray;
    }

    public static void addPackageAsChild(@NotNull Collection<AbstractTreeNode> children, @NotNull PsiPackage aPackage, @Nullable Module module, @NotNull ViewSettings settings, boolean inLibrary) {
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "addPackageAsChild"));
        }
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "addPackageAsChild"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "addPackageAsChild"));
        }
        boolean shouldSkipPackage = settings.isHideEmptyMiddlePackages() && PackageUtil.isPackageEmpty(aPackage, module, !settings.isFlattenPackages(), inLibrary);
        Project project = aPackage.getProject();
        if (!shouldSkipPackage) {
            children.add((AbstractTreeNode)new PackageElementNode(project, new PackageElement(module, aPackage, inLibrary), settings));
        }
        if (settings.isFlattenPackages() || shouldSkipPackage) {
            PsiPackage[] subpackages;
            for (PsiPackage subpackage : subpackages = PackageUtil.getSubpackages(aPackage, module, project, inLibrary)) {
                PackageUtil.addPackageAsChild(children, subpackage, module, settings, inLibrary);
            }
        }
    }

    public static boolean isPackageEmpty(@NotNull PsiPackage aPackage, @Nullable Module module, boolean strictlyEmpty, boolean inLibrary) {
        PsiDirectory[] dirs;
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "isPackageEmpty"));
        }
        Project project = aPackage.getProject();
        for (PsiDirectory dir : dirs = PackageUtil.getDirectories(aPackage, project, module, inLibrary)) {
            if (TreeViewUtil.isEmptyMiddlePackage(dir, strictlyEmpty)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static PsiDirectory[] getDirectories(@NotNull PsiPackage aPackage, @NotNull Project project, @Nullable Module module, boolean inLibrary) {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getDirectories"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getDirectories"));
        }
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(project, module, inLibrary);
        PsiDirectory[] psiDirectoryArray = aPackage.getDirectories(scopeToShow);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getDirectories"));
        }
        return psiDirectoryArray;
    }

    @NotNull
    private static GlobalSearchScope getScopeToShow(@NotNull Project project, @Nullable Module module, boolean forLibraries) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getScopeToShow"));
        }
        if (module == null) {
            if (forLibraries) {
                ProjectLibrariesSearchScope projectLibrariesSearchScope = new ProjectLibrariesSearchScope(project);
                if (projectLibrariesSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getScopeToShow"));
                }
                return projectLibrariesSearchScope;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getScopeToShow"));
            }
            return globalSearchScope;
        }
        if (forLibraries) {
            ModuleLibrariesSearchScope moduleLibrariesSearchScope = new ModuleLibrariesSearchScope(module);
            if (moduleLibrariesSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getScopeToShow"));
            }
            return moduleLibrariesSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleScope((Module)module);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getScopeToShow"));
        }
        return globalSearchScope;
    }

    public static boolean isPackageDefault(@NotNull PsiPackage directoryPackage) {
        if (directoryPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "isPackageDefault"));
        }
        String qName = directoryPackage.getQualifiedName();
        return qName.isEmpty();
    }

    @NotNull
    public static Collection<AbstractTreeNode> createPackageViewChildrenOnFiles(@NotNull List<VirtualFile> sourceRoots, @NotNull Project project, @NotNull ViewSettings settings, @Nullable Module module, boolean inLibrary) {
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "createPackageViewChildrenOnFiles"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "createPackageViewChildrenOnFiles"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "createPackageViewChildrenOnFiles"));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        HashSet<PsiPackage> topLevelPackages = new HashSet<PsiPackage>();
        for (VirtualFile root : sourceRoots) {
            PsiDirectory directory = psiManager.findDirectory(root);
            if (directory == null) continue;
            PsiPackage directoryPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (directoryPackage == null || PackageUtil.isPackageDefault(directoryPackage)) {
                PsiDirectory[] subdirectories;
                for (PsiDirectory subdirectory : subdirectories = directory.getSubdirectories()) {
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subdirectory);
                    if (aPackage == null || PackageUtil.isPackageDefault(aPackage)) continue;
                    topLevelPackages.add(aPackage);
                }
                children.addAll(ProjectViewDirectoryHelper.getInstance(project).getDirectoryChildren(directory, settings, false));
                continue;
            }
            topLevelPackages.add(directoryPackage);
        }
        for (PsiPackage topLevelPackage : topLevelPackages) {
            PackageUtil.addPackageAsChild(children, topLevelPackage, module, settings, inLibrary);
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "createPackageViewChildrenOnFiles"));
        }
        return arrayList;
    }

    @NotNull
    public static String getNodeName(@NotNull ViewSettings settings, PsiPackage aPackage, PsiPackage parentPackageInTree, @NotNull String defaultShortName, boolean isFQNameShown) {
        String name;
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getNodeName"));
        }
        if (defaultShortName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getNodeName"));
        }
        if (isFQNameShown) {
            name = settings.isAbbreviatePackageNames() ? (aPackage == null ? defaultShortName : TreeViewUtil.calcAbbreviatedPackageFQName(aPackage)) : (aPackage == null ? defaultShortName : aPackage.getQualifiedName());
        } else if (parentPackageInTree != null || aPackage != null && aPackage.getParentPackage() != null) {
            String parentPackageName;
            StringBuilder buf = new StringBuilder();
            buf.append(aPackage.getName());
            for (PsiPackage parentPackage = aPackage.getParentPackage(); !(parentPackage == null || parentPackageInTree != null && parentPackage.equals(parentPackageInTree) || (parentPackageName = parentPackage.getName()) == null || parentPackageName.isEmpty()); parentPackage = parentPackage.getParentPackage()) {
                buf.insert(0, ".");
                buf.insert(0, parentPackageName);
            }
            name = buf.toString();
        } else {
            name = defaultShortName;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getNodeName"));
        }
        return string;
    }

    private static class ProjectLibrariesSearchScope
    extends GlobalSearchScope {
        private final DirectoryIndex myDirectoryIndex;

        public ProjectLibrariesSearchScope(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ProjectLibrariesSearchScope", "<init>"));
            }
            super(project);
            this.myDirectoryIndex = DirectoryIndex.getInstance(project);
        }

        public boolean contains(@NotNull VirtualFile file) {
            VirtualFile dir;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ProjectLibrariesSearchScope", "contains"));
            }
            VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
            if (dir == null) {
                return false;
            }
            DirectoryInfo info = this.myDirectoryIndex.getInfoForDirectory(dir);
            return info != null && info.hasLibraryClassRoot();
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ProjectLibrariesSearchScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ProjectLibrariesSearchScope", "compare"));
            }
            throw new IncorrectOperationException("not implemented");
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ProjectLibrariesSearchScope", "isSearchInModuleContent"));
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }

    private static class ModuleLibrariesSearchScope
    extends GlobalSearchScope {
        private final Module myModule;

        public ModuleLibrariesSearchScope(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ModuleLibrariesSearchScope", "<init>"));
            }
            super(module.getProject());
            this.myModule = module;
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ModuleLibrariesSearchScope", "contains"));
            }
            OrderEntry orderEntry = ModuleRootManager.getInstance((Module)this.myModule).getFileIndex().getOrderEntryForFile(file);
            return orderEntry instanceof JdkOrderEntry || orderEntry instanceof LibraryOrderEntry;
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ModuleLibrariesSearchScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ModuleLibrariesSearchScope", "compare"));
            }
            ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)this.myModule).getFileIndex();
            return Comparing.compare((Comparable)fileIndex.getOrderEntryForFile(file2), (Comparable)fileIndex.getOrderEntryForFile(file1));
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ModuleLibrariesSearchScope", "isSearchInModuleContent"));
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

