/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectRootsUtil {
    private ProjectRootsUtil() {
    }

    public static boolean isSourceRoot(PsiDirectory psiDirectory) {
        return ProjectRootsUtil.isSourceRoot(psiDirectory.getVirtualFile(), psiDirectory.getProject());
    }

    public static boolean isSourceRoot(VirtualFile directoryFile, Project project) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return directoryFile.equals(fileIndex.getSourceRootForFile(directoryFile));
    }

    public static boolean isInSource(PsiDirectory directory) {
        return ProjectRootsUtil.isInSource(directory.getVirtualFile(), directory.getProject());
    }

    public static boolean isInSource(VirtualFile directoryFile, Project project) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return projectFileIndex.isInSourceContent(directoryFile);
    }

    public static boolean isInTestSource(VirtualFile directoryFile, Project project) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return projectFileIndex.isInTestSourceContent(directoryFile);
    }

    public static boolean isModuleSourceRoot(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isModuleSourceRoot"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isModuleSourceRoot"));
        }
        return ProjectRootsUtil.getModuleSourceRoot(virtualFile, project) != null;
    }

    @Nullable
    public static SourceFolder getModuleSourceRoot(@NotNull VirtualFile root, @NotNull Project project) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "getModuleSourceRoot"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "getModuleSourceRoot"));
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = projectFileIndex.getModuleForFile(root);
        return module != null && !module.isDisposed() ? ProjectRootsUtil.findSourceFolder(module, root) : null;
    }

    public static boolean isLibraryRoot(VirtualFile directoryFile, Project project) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (projectFileIndex.isInLibraryClasses(directoryFile)) {
            VirtualFile parent = directoryFile.getParent();
            return parent == null || !projectFileIndex.isInLibraryClasses(parent);
        }
        return false;
    }

    public static boolean isModuleContentRoot(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isModuleContentRoot"));
        }
        return ProjectRootsUtil.isModuleContentRoot(directory.getVirtualFile(), directory.getProject());
    }

    public static boolean isModuleContentRoot(@NotNull VirtualFile directoryFile, @NotNull Project project) {
        if (directoryFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isModuleContentRoot"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isModuleContentRoot"));
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile contentRootForFile = projectFileIndex.getContentRootForFile(directoryFile);
        return directoryFile.equals(contentRootForFile);
    }

    public static boolean isProjectHome(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "isProjectHome"));
        }
        return psiDirectory.getVirtualFile().equals(psiDirectory.getProject().getBaseDir());
    }

    public static boolean isOutsideSourceRoot(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        if (psiFile instanceof PsiCodeFragment) {
            return false;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex();
        return !projectFileIndex.isInSource(file) && !projectFileIndex.isInLibraryClasses(file);
    }

    @Nullable
    public static SourceFolder findSourceFolder(@NotNull Module module, @NotNull VirtualFile root) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "findSourceFolder"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/projectView/impl/ProjectRootsUtil", "findSourceFolder"));
        }
        for (ContentEntry entry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            for (SourceFolder folder : entry.getSourceFolders()) {
                if (!root.equals(folder.getFile())) continue;
                return folder;
            }
        }
        return null;
    }
}

