/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.TreeViewUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaProjectViewDirectoryHelper
extends ProjectViewDirectoryHelper {
    public JavaProjectViewDirectoryHelper(Project project, DirectoryIndex index) {
        super(project, index);
    }

    @Override
    public String getLocationString(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/JavaProjectViewDirectoryHelper", "getLocationString"));
        }
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (ProjectRootsUtil.isSourceRoot(directory) && aPackage != null) {
            return aPackage.getQualifiedName();
        }
        return super.getLocationString(directory);
    }

    @Override
    public boolean isShowFQName(ViewSettings settings, Object parentValue, PsiDirectory value) {
        PsiPackage aPackage;
        return value != null && !(parentValue instanceof Project) && settings.isFlattenPackages() && (aPackage = JavaDirectoryService.getInstance().getPackage(value)) != null && !aPackage.getQualifiedName().isEmpty();
    }

    @Override
    @Nullable
    public String getNodeName(ViewSettings settings, Object parentValue, PsiDirectory directory) {
        PsiPackage parentPackage;
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (!ProjectRootsUtil.isSourceRoot(directory) && aPackage != null && !aPackage.getQualifiedName().isEmpty() && parentValue instanceof PsiDirectory) {
            parentPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)parentValue);
        } else if (ProjectRootsUtil.isSourceRoot(directory) && aPackage != null) {
            aPackage = null;
            parentPackage = null;
        } else {
            parentPackage = null;
        }
        return PackageUtil.getNodeName(settings, aPackage, parentPackage, directory.getName(), this.isShowFQName(settings, parentValue, directory));
    }

    @Override
    public boolean skipDirectory(PsiDirectory directory) {
        return JavaDirectoryService.getInstance().getPackage(directory) == null;
    }

    @Override
    public boolean isEmptyMiddleDirectory(PsiDirectory directory, boolean strictlyEmpty) {
        return JavaDirectoryService.getInstance().getPackage(directory) != null && TreeViewUtil.isEmptyMiddlePackage(directory, strictlyEmpty);
    }

    @Override
    public boolean supportsFlattenPackages() {
        return true;
    }

    @Override
    public boolean supportsHideEmptyMiddlePackages() {
        return true;
    }

    @Override
    public boolean canRepresent(Object element, PsiDirectory directory) {
        if (super.canRepresent(element, directory)) {
            return true;
        }
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            return Arrays.asList(packageElement.getPackage().getDirectories()).contains(directory);
        }
        return false;
    }
}

