/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class UnmarkRootAction
extends MarkRootActionBase {
    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        MarkRootActionBase.RootsSelection selection = UnmarkRootAction.getSelection(e);
        HashSet selectedRootTypes = new HashSet();
        for (SourceFolder root : selection.mySelectedRoots) {
            selectedRootTypes.add(root.getRootType());
        }
        if (!selectedRootTypes.isEmpty()) {
            String text;
            if (selectedRootTypes.size() == 1) {
                JpsModuleSourceRootType type = (JpsModuleSourceRootType)selectedRootTypes.iterator().next();
                ModuleSourceRootEditHandler handler = ModuleSourceRootEditHandler.getEditHandler(type);
                text = "Unmark as " + handler.getRootTypeName() + " " + StringUtil.pluralize((String)"Root", (int)selection.mySelectedRoots.size());
            } else {
                text = "Unmark Roots";
            }
            e.getPresentation().setText(text);
        }
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/actions/UnmarkRootAction", "isEnabled"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/projectView/actions/UnmarkRootAction", "isEnabled"));
        }
        return selection.mySelectedDirectories.isEmpty() && !selection.mySelectedRoots.isEmpty();
    }

    @Override
    protected void modifyRoots(VirtualFile vFile, ContentEntry entry) {
    }
}

