/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class MarkGeneratedSourceRootAction
extends MarkRootActionBase {
    public MarkGeneratedSourceRootAction() {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setIcon(AllIcons.Modules.GeneratedSourceRoot);
        presentation.setText("Generated Sources Root");
        presentation.setDescription("Mark directory as a source root for generated files");
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/actions/MarkGeneratedSourceRootAction", "isEnabled"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/projectView/actions/MarkGeneratedSourceRootAction", "isEnabled"));
        }
        if (!MarkGeneratedSourceRootAction.isJavaModule(module)) {
            return false;
        }
        if (selection.myHaveSelectedFilesUnderSourceRoots) {
            return false;
        }
        if (!selection.mySelectedDirectories.isEmpty()) {
            return true;
        }
        for (SourceFolder root : selection.mySelectedRoots) {
            JavaSourceRootProperties properties = (JavaSourceRootProperties)root.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
            if (properties == null || properties.isForGeneratedSources()) continue;
            return true;
        }
        return false;
    }

    private static boolean isJavaModule(Module module) {
        ModuleType moduleType = ModuleType.get((Module)module);
        return moduleType instanceof JavaModuleType || moduleType != null && "PLUGIN_MODULE".equals(moduleType.getId());
    }

    @Override
    protected void modifyRoots(VirtualFile vFile, ContentEntry entry) {
        JavaSourceRootProperties properties = JpsJavaExtensionService.getInstance().createSourceRootProperties("", true);
        entry.addSourceFolder(vFile, (JpsModuleSourceRootType)JavaSourceRootType.SOURCE, (JpsElement)properties);
    }
}

