/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.ide.plugins.PluginsTableRenderer;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.util.Function;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPluginsTableModel
extends PluginTableModel {
    public static Map<PluginId, Integer> NewVersions2Plugins = new HashMap<PluginId, Integer>();
    public static Set<PluginId> updatedPlugins = new HashSet();
    private final Map<PluginId, Boolean> myEnabled = new HashMap<PluginId, Boolean>();
    private final Map<PluginId, Set<PluginId>> myDependentToRequiredListMap = new HashMap<PluginId, Set<PluginId>>();
    private static final String ENABLED_DISABLED = "All plugins";
    private static final String ENABLED = "Enabled";
    private static final String DISABLED = "Disabled";
    private static final String BUNDLED = "Bundled";
    private static final String CUSTOM = "Custom";
    public static final String[] ENABLED_VALUES = new String[]{"All plugins", "Enabled", "Disabled", "Bundled", "Custom"};
    private String myEnabledFilter = "All plugins";
    private final Map<String, String> myPlugin2host = new HashMap<String, String>();
    private static final Set<IdeaPluginDescriptor> myInstalled = new HashSet();

    public InstalledPluginsTableModel() {
        this.columns = new ColumnInfo[]{new MyPluginManagerColumnInfo(), new EnabledPluginInfo()};
        this.view = new ArrayList<IdeaPluginDescriptor>(Arrays.asList(PluginManager.getPlugins()));
        this.view.addAll(myInstalled);
        this.reset(this.view);
        ApplicationInfoEx applicationInfo = ApplicationInfoEx.getInstanceEx();
        Iterator iterator = this.view.iterator();
        while (iterator.hasNext()) {
            String s = ((IdeaPluginDescriptor)iterator.next()).getPluginId().getIdString();
            if (!"com.intellij".equals(s) && !applicationInfo.isEssentialPlugin(s)) continue;
            iterator.remove();
        }
        this.setSortKey(new RowSorter.SortKey(this.getNameColumn(), SortOrder.ASCENDING));
    }

    public boolean hasProblematicDependencies(PluginId pluginId) {
        Set<PluginId> ids = this.myDependentToRequiredListMap.get(pluginId);
        return ids != null && !ids.isEmpty();
    }

    public boolean appendOrUpdateDescriptor(IdeaPluginDescriptor descriptor) {
        PluginId descrId = descriptor.getPluginId();
        IdeaPluginDescriptor existing = PluginManager.getPlugin(descrId);
        if (existing != null) {
            InstalledPluginsTableModel.updateExistingPlugin(descriptor, existing);
            return true;
        }
        if (!myInstalled.contains(descriptor)) {
            myInstalled.add(descriptor);
            this.view.add(descriptor);
            this.setEnabled(descriptor, true);
            this.fireTableDataChanged();
            return true;
        }
        return false;
    }

    public static void updateExistingPlugin(IdeaPluginDescriptor descriptor, @Nullable IdeaPluginDescriptor existing) {
        if (existing != null) {
            InstalledPluginsTableModel.updateExistingPluginInfo(descriptor, existing);
            updatedPlugins.add(existing.getPluginId());
        }
    }

    public String getPluginHostUrl(String idString) {
        return this.myPlugin2host.get(idString);
    }

    public static int getCheckboxColumn() {
        return 1;
    }

    @Override
    public int getNameColumn() {
        return 0;
    }

    private void reset(List<IdeaPluginDescriptor> list) {
        for (IdeaPluginDescriptor ideaPluginDescriptor : list) {
            this.setEnabled(ideaPluginDescriptor);
        }
        this.updatePluginDependencies();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Load custom plugin repositories data..."){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/InstalledPluginsTableModel$1$1", "run"));
                        }
                        InstalledPluginsTableModel.this.updateRepositoryPlugins();
                    }
                });
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void updateRepositoryPlugins() {
        this.myPlugin2host.clear();
        JDOMExternalizableStringList pluginHosts = UpdateSettings.getInstance().myPluginHosts;
        for (String host : pluginHosts) {
            try {
                ArrayList<PluginDownloader> downloaded = new ArrayList<PluginDownloader>();
                UpdateChecker.checkPluginsHost(host, downloaded, false, null);
                for (PluginDownloader downloader : downloaded) {
                    this.myPlugin2host.put(downloader.getPluginId(), host);
                }
            }
            catch (Exception ignored) {
            }
        }
    }

    private void setEnabled(IdeaPluginDescriptor ideaPluginDescriptor) {
        this.setEnabled(ideaPluginDescriptor, ideaPluginDescriptor.isEnabled());
    }

    private void setEnabled(IdeaPluginDescriptor ideaPluginDescriptor, boolean enabled) {
        List<String> disabledPlugins = PluginManager.getDisabledPlugins();
        PluginId pluginId = ideaPluginDescriptor.getPluginId();
        if (!enabled && !disabledPlugins.contains(pluginId.toString())) {
            this.myEnabled.put(pluginId, null);
        } else {
            this.myEnabled.put(pluginId, enabled);
        }
    }

    public Map<PluginId, Set<PluginId>> getDependentToRequiredListMap() {
        return this.myDependentToRequiredListMap;
    }

    protected void updatePluginDependencies() {
        this.myDependentToRequiredListMap.clear();
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Boolean enabled;
            IdeaPluginDescriptor descriptor = this.getObjectAt(i);
            final PluginId pluginId = descriptor.getPluginId();
            this.myDependentToRequiredListMap.remove(pluginId);
            if (descriptor instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)descriptor).isDeleted() || (enabled = this.myEnabled.get(pluginId)) != null && !enabled.booleanValue()) continue;
            PluginManager.checkDependants(descriptor, new Function<PluginId, IdeaPluginDescriptor>(){

                @Nullable
                public IdeaPluginDescriptor fun(PluginId pluginId) {
                    return PluginManager.getPlugin(pluginId);
                }
            }, new Condition<PluginId>(){

                public boolean value(PluginId dependantPluginId) {
                    Boolean enabled = (Boolean)InstalledPluginsTableModel.this.myEnabled.get(dependantPluginId);
                    if (enabled == null && !updatedPlugins.contains(dependantPluginId) || enabled != null && !enabled.booleanValue()) {
                        Set required = (Set)InstalledPluginsTableModel.this.myDependentToRequiredListMap.get(pluginId);
                        if (required == null) {
                            required = new HashSet();
                            InstalledPluginsTableModel.this.myDependentToRequiredListMap.put(pluginId, required);
                        }
                        required.add(dependantPluginId);
                    }
                    return true;
                }
            });
            if (enabled != null || this.myDependentToRequiredListMap.containsKey(pluginId) || PluginManager.isIncompatible(descriptor)) continue;
            this.myEnabled.put(pluginId, true);
        }
    }

    @Override
    public void updatePluginsList(List<IdeaPluginDescriptor> list) {
        for (IdeaPluginDescriptor descr : list) {
            PluginId descrId = descr.getPluginId();
            IdeaPluginDescriptor existing = PluginManager.getPlugin(descrId);
            if (existing == null) continue;
            if (descr instanceof PluginNode) {
                InstalledPluginsTableModel.updateExistingPluginInfo(descr, existing);
                continue;
            }
            this.view.add(descr);
            this.setEnabled(descr);
        }
        for (IdeaPluginDescriptor descriptor : myInstalled) {
            if (this.view.contains(descriptor)) continue;
            this.view.add(descriptor);
        }
        this.fireTableDataChanged();
    }

    @Override
    protected ArrayList<IdeaPluginDescriptor> toProcess() {
        ArrayList<IdeaPluginDescriptor> toProcess = super.toProcess();
        for (IdeaPluginDescriptor descriptor : myInstalled) {
            if (toProcess.contains(descriptor)) continue;
            toProcess.add(descriptor);
        }
        return toProcess;
    }

    @Override
    public void filter(List<IdeaPluginDescriptor> filtered) {
        this.view.clear();
        for (IdeaPluginDescriptor descriptor : filtered) {
            this.view.add(descriptor);
        }
        super.filter(filtered);
    }

    private static void updateExistingPluginInfo(IdeaPluginDescriptor descr, IdeaPluginDescriptor existing) {
        int state = StringUtil.compareVersionNumbers((String)descr.getVersion(), (String)existing.getVersion());
        PluginId pluginId = existing.getPluginId();
        String idString = pluginId.getIdString();
        JDOMExternalizableStringList installedPlugins = PluginManagerUISettings.getInstance().getInstalledPlugins();
        if (!installedPlugins.contains((Object)idString) && !((IdeaPluginDescriptorImpl)existing).isDeleted()) {
            installedPlugins.add((Object)idString);
        }
        PluginManagerUISettings updateSettings = PluginManagerUISettings.getInstance();
        if (state > 0 && !PluginManager.isIncompatible(descr) && !updatedPlugins.contains(descr.getPluginId())) {
            NewVersions2Plugins.put(pluginId, 1);
            if (!updateSettings.myOutdatedPlugins.contains((Object)idString)) {
                updateSettings.myOutdatedPlugins.add((Object)idString);
            }
            IdeaPluginDescriptorImpl plugin = (IdeaPluginDescriptorImpl)existing;
            plugin.setDownloadsCount(descr.getDownloads());
            plugin.setVendor(descr.getVendor());
            plugin.setVendorEmail(descr.getVendorEmail());
            plugin.setVendorUrl(descr.getVendorUrl());
            plugin.setUrl(descr.getUrl());
        } else {
            updateSettings.myOutdatedPlugins.remove((Object)idString);
            if (NewVersions2Plugins.remove(pluginId) != null) {
                updatedPlugins.add(pluginId);
            }
        }
    }

    public void enableRows(IdeaPluginDescriptor[] ideaPluginDescriptors, Boolean value) {
        for (IdeaPluginDescriptor ideaPluginDescriptor : ideaPluginDescriptors) {
            PluginId currentPluginId = ideaPluginDescriptor.getPluginId();
            Boolean enabled = this.myEnabled.get(currentPluginId) == null ? Boolean.FALSE : value;
            this.myEnabled.put(currentPluginId, enabled);
        }
        this.updatePluginDependencies();
        this.warnAboutMissedDependencies(value, ideaPluginDescriptors);
        this.hideNotApplicablePlugins(value, ideaPluginDescriptors);
    }

    private void hideNotApplicablePlugins(Boolean value, final IdeaPluginDescriptor ... ideaPluginDescriptors) {
        if (!value.booleanValue() && ENABLED.equals(this.myEnabledFilter) || value.booleanValue() && DISABLED.equals(this.myEnabledFilter)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (IdeaPluginDescriptor ideaPluginDescriptor : ideaPluginDescriptors) {
                        InstalledPluginsTableModel.this.view.remove(ideaPluginDescriptor);
                        InstalledPluginsTableModel.this.filtered.add(ideaPluginDescriptor);
                    }
                    InstalledPluginsTableModel.this.fireTableDataChanged();
                }
            });
        }
    }

    public static boolean hasNewerVersion(PluginId descr) {
        return !InstalledPluginsTableModel.wasUpdated(descr) && (NewVersions2Plugins.containsKey(descr) || PluginManagerUISettings.getInstance().myOutdatedPlugins.contains((Object)descr.getIdString()));
    }

    public static boolean wasUpdated(PluginId descr) {
        return updatedPlugins.contains(descr);
    }

    public boolean isEnabled(PluginId pluginId) {
        Boolean enabled = this.myEnabled.get(pluginId);
        return enabled != null && enabled != false;
    }

    public boolean isDisabled(PluginId pluginId) {
        Boolean enabled = this.myEnabled.get(pluginId);
        return enabled != null && enabled == false;
    }

    public Map<PluginId, Boolean> getEnabledMap() {
        return this.myEnabled;
    }

    public String getEnabledFilter() {
        return this.myEnabledFilter;
    }

    public void setEnabledFilter(String enabledFilter, String filter) {
        this.myEnabledFilter = enabledFilter;
        this.filter(filter);
    }

    @Override
    public boolean isPluginDescriptorAccepted(IdeaPluginDescriptor descriptor) {
        if (!this.myEnabledFilter.equals(ENABLED_DISABLED)) {
            boolean enabled = this.isEnabled(descriptor.getPluginId());
            if (enabled && this.myEnabledFilter.equals(DISABLED)) {
                return false;
            }
            if (!enabled && this.myEnabledFilter.equals(ENABLED)) {
                return false;
            }
            boolean bundled = descriptor.isBundled();
            if (bundled && this.myEnabledFilter.equals(CUSTOM)) {
                return false;
            }
            if (!bundled && this.myEnabledFilter.equals(BUNDLED)) {
                return false;
            }
        }
        return true;
    }

    private void warnAboutMissedDependencies(final Boolean newVal, IdeaPluginDescriptor ... ideaPluginDescriptors) {
        HashSet deps = new HashSet();
        ArrayList<IdeaPluginDescriptor> descriptorsToCheckDependencies = new ArrayList<IdeaPluginDescriptor>();
        if (newVal.booleanValue()) {
            Collections.addAll(descriptorsToCheckDependencies, ideaPluginDescriptors);
        } else {
            descriptorsToCheckDependencies.addAll(this.getAllPlugins());
            descriptorsToCheckDependencies.removeAll(Arrays.asList(ideaPluginDescriptors));
            Iterator iterator = descriptorsToCheckDependencies.iterator();
            while (iterator.hasNext()) {
                IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)iterator.next();
                Boolean enabled = this.myEnabled.get(descriptor.getPluginId());
                if (enabled != null && enabled.booleanValue()) continue;
                iterator.remove();
            }
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptorsToCheckDependencies) {
            PluginManager.checkDependants(ideaPluginDescriptor, new Function<PluginId, IdeaPluginDescriptor>(){

                @Nullable
                public IdeaPluginDescriptor fun(PluginId pluginId) {
                    return PluginManager.getPlugin(pluginId);
                }
            }, new Condition<PluginId>((Set)deps, ideaPluginDescriptor, ideaPluginDescriptors){
                final /* synthetic */ Set val$deps;
                final /* synthetic */ IdeaPluginDescriptor val$ideaPluginDescriptor;
                final /* synthetic */ IdeaPluginDescriptor[] val$ideaPluginDescriptors;
                {
                    this.val$deps = set;
                    this.val$ideaPluginDescriptor = ideaPluginDescriptor;
                    this.val$ideaPluginDescriptors = ideaPluginDescriptorArray;
                }

                public boolean value(PluginId pluginId) {
                    Boolean enabled = (Boolean)InstalledPluginsTableModel.this.myEnabled.get(pluginId);
                    if (enabled == null) {
                        return false;
                    }
                    if (newVal.booleanValue() && !enabled.booleanValue()) {
                        this.val$deps.add(pluginId);
                    }
                    if (!newVal.booleanValue()) {
                        if (this.val$ideaPluginDescriptor instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)this.val$ideaPluginDescriptor).isDeleted()) {
                            return true;
                        }
                        PluginId pluginDescriptorId = this.val$ideaPluginDescriptor.getPluginId();
                        for (IdeaPluginDescriptor descriptor : this.val$ideaPluginDescriptors) {
                            if (!pluginId.equals(descriptor.getPluginId())) continue;
                            this.val$deps.add(pluginDescriptorId);
                            break;
                        }
                    }
                    return true;
                }
            });
        }
        if (!deps.isEmpty()) {
            String message;
            String listOfSelectedPlugins = StringUtil.join((Object[])ideaPluginDescriptors, (Function)new Function<IdeaPluginDescriptor, String>(){

                public String fun(IdeaPluginDescriptor pluginDescriptor) {
                    return pluginDescriptor.getName();
                }
            }, (String)", ");
            HashSet pluginDependencies = new HashSet();
            String listOfDependencies = StringUtil.join((Collection)deps, (Function)new Function<PluginId, String>((Set)pluginDependencies){
                final /* synthetic */ Set val$pluginDependencies;
                {
                    this.val$pluginDependencies = set;
                }

                public String fun(PluginId pluginId) {
                    IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin(pluginId);
                    assert (pluginDescriptor != null);
                    this.val$pluginDependencies.add(pluginDescriptor);
                    return pluginDescriptor.getName();
                }
            }, (String)"<br>");
            String string = message = newVal == false ? "<html>The following plugins <br>" + listOfDependencies + "<br>are enabled and depend" + (deps.size() == 1 ? "s" : "") + " on selected plugins. " + "<br>Would you like to disable them too?</html>" : "<html>The following plugins on which " + listOfSelectedPlugins + " depend" + (ideaPluginDescriptors.length == 1 ? "s" : "") + " are disabled:<br>" + listOfDependencies + "<br>Would you like to enable them?</html>";
            if (Messages.showOkCancelDialog((String)message, (String)(newVal != false ? "Enable Dependant Plugins" : "Disable Plugins with Dependency on this"), (Icon)Messages.getQuestionIcon()) == 0) {
                for (PluginId pluginId : deps) {
                    this.myEnabled.put(pluginId, newVal);
                }
                this.updatePluginDependencies();
                this.hideNotApplicablePlugins(newVal, pluginDependencies.toArray(new IdeaPluginDescriptor[pluginDependencies.size()]));
            }
        }
    }

    private class MyPluginManagerColumnInfo
    extends PluginManagerColumnInfo {
        public MyPluginManagerColumnInfo() {
            super(0, InstalledPluginsTableModel.this);
        }

        @Override
        public TableCellRenderer getRenderer(IdeaPluginDescriptor pluginDescriptor) {
            return new PluginsTableRenderer(pluginDescriptor, false);
        }

        @Override
        protected boolean isSortByName() {
            return true;
        }

        @Override
        public Comparator<IdeaPluginDescriptor> getComparator() {
            final Comparator<IdeaPluginDescriptor> comparator = super.getColumnComparator();
            return new Comparator<IdeaPluginDescriptor>(){

                @Override
                public int compare(IdeaPluginDescriptor o1, IdeaPluginDescriptor o2) {
                    if (MyPluginManagerColumnInfo.this.isSortByStatus()) {
                        boolean deleted2;
                        boolean incompatible1 = PluginManager.isIncompatible(o1);
                        boolean incompatible2 = PluginManager.isIncompatible(o2);
                        if (incompatible1) {
                            if (incompatible2) {
                                return comparator.compare(o1, o2);
                            }
                            return -1;
                        }
                        if (incompatible2) {
                            return 1;
                        }
                        boolean hasNewerVersion1 = InstalledPluginsTableModel.hasNewerVersion(o1.getPluginId());
                        boolean hasNewerVersion2 = InstalledPluginsTableModel.hasNewerVersion(o2.getPluginId());
                        if (hasNewerVersion1) {
                            if (hasNewerVersion2) {
                                return comparator.compare(o1, o2);
                            }
                            return -1;
                        }
                        if (hasNewerVersion2) {
                            return 1;
                        }
                        boolean wasUpdated1 = InstalledPluginsTableModel.wasUpdated(o1.getPluginId());
                        boolean wasUpdated2 = InstalledPluginsTableModel.wasUpdated(o2.getPluginId());
                        if (wasUpdated1) {
                            if (wasUpdated2) {
                                return comparator.compare(o1, o2);
                            }
                            return -1;
                        }
                        if (wasUpdated2) {
                            return 1;
                        }
                        if (o1 instanceof PluginNode) {
                            if (o2 instanceof PluginNode) {
                                return comparator.compare(o1, o2);
                            }
                            return -1;
                        }
                        if (o2 instanceof PluginNode) {
                            return 1;
                        }
                        boolean deleted1 = o1 instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)o1).isDeleted();
                        boolean bl = deleted2 = o2 instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)o2).isDeleted();
                        if (deleted1) {
                            if (deleted2) {
                                return comparator.compare(o1, o2);
                            }
                            return -1;
                        }
                        if (deleted2) {
                            return 1;
                        }
                        boolean enabled1 = InstalledPluginsTableModel.this.isEnabled(o1.getPluginId());
                        boolean enabled2 = InstalledPluginsTableModel.this.isEnabled(o2.getPluginId());
                        if (enabled1 && !enabled2) {
                            return -1;
                        }
                        if (enabled2 && !enabled1) {
                            return 1;
                        }
                    }
                    return comparator.compare(o1, o2);
                }
            };
        }

        public int getWidth(JTable table) {
            return super.getWidth(table);
        }
    }

    private class InstalledPluginsTableRenderer
    extends DefaultTableCellRenderer {
        private JLabel myNameLabel = new JLabel();
        private JLabel myBundledLabel = new JLabel();
        private JPanel myPanel = new JPanel(new BorderLayout());
        private final IdeaPluginDescriptor myPluginDescriptor;

        public InstalledPluginsTableRenderer(IdeaPluginDescriptor pluginDescriptor) {
            this.myPluginDescriptor = pluginDescriptor;
            this.myNameLabel.setFont(PluginManagerColumnInfo.getNameFont());
            this.myBundledLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            this.myPanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 1));
            this.myNameLabel.setOpaque(true);
            this.myPanel.add((Component)this.myNameLabel, "West");
            this.myPanel.add((Component)this.myBundledLabel, "East");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component orig = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (this.myPluginDescriptor != null) {
                this.myNameLabel.setText(this.myPluginDescriptor.getName());
                PluginId pluginId = this.myPluginDescriptor.getPluginId();
                String idString = pluginId.getIdString();
                if (this.myPluginDescriptor.isBundled()) {
                    this.myBundledLabel.setText(InstalledPluginsTableModel.BUNDLED);
                } else {
                    String host = (String)InstalledPluginsTableModel.this.myPlugin2host.get(idString);
                    if (host != null) {
                        String presentableUrl = VfsUtil.urlToPath((String)host);
                        int idx = presentableUrl.indexOf(47);
                        if (idx > -1) {
                            presentableUrl = presentableUrl.substring(0, idx);
                        }
                        this.myBundledLabel.setText("From " + presentableUrl);
                    } else if (PluginManagerUISettings.getInstance().getInstalledPlugins().contains((Object)idString)) {
                        this.myBundledLabel.setText("From repository");
                    } else {
                        this.myBundledLabel.setText(InstalledPluginsTableModel.CUSTOM);
                    }
                }
                if (this.myPluginDescriptor instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)this.myPluginDescriptor).isDeleted()) {
                    this.myNameLabel.setIcon(AllIcons.Actions.Clean);
                } else if (InstalledPluginsTableModel.hasNewerVersion(pluginId)) {
                    this.myNameLabel.setIcon(AllIcons.Nodes.Pluginobsolete);
                    this.myPanel.setToolTipText("Newer version of the plugin is available");
                } else {
                    this.myNameLabel.setIcon(AllIcons.Nodes.Plugin);
                }
                Color fg = orig.getForeground();
                Color bg = orig.getBackground();
                Color grayedFg = isSelected ? fg : Color.GRAY;
                this.myPanel.setBackground(bg);
                this.myNameLabel.setBackground(bg);
                this.myBundledLabel.setBackground(bg);
                this.myNameLabel.setForeground(fg);
                boolean wasUpdated = InstalledPluginsTableModel.wasUpdated(pluginId);
                if (wasUpdated || PluginManager.getPlugin(pluginId) == null) {
                    if (!isSelected) {
                        this.myNameLabel.setForeground(FileStatus.COLOR_ADDED);
                    }
                    if (wasUpdated) {
                        this.myPanel.setToolTipText("Plugin was updated to the newest version. Changes will be available after restart");
                    } else {
                        this.myPanel.setToolTipText("Plugin will be activated after restart.");
                    }
                }
                this.myBundledLabel.setForeground(grayedFg);
                Set required = (Set)InstalledPluginsTableModel.this.myDependentToRequiredListMap.get(pluginId);
                if (required != null && required.size() > 0) {
                    this.myNameLabel.setForeground((Color)JBColor.RED);
                    StringBuilder s = new StringBuilder();
                    if (InstalledPluginsTableModel.this.myEnabled.get(pluginId) == null) {
                        s.append("Plugin was not loaded.\n");
                    }
                    if (required.contains(PluginId.getId((String)"com.intellij.modules.ultimate"))) {
                        s.append("The plugin requires IntelliJ IDEA Ultimate");
                    } else {
                        s.append("Required plugin").append(required.size() == 1 ? " \"" : "s \"");
                        s.append(StringUtil.join((Collection)required, (Function)new Function<PluginId, String>(){

                            public String fun(PluginId id) {
                                IdeaPluginDescriptor plugin = PluginManager.getPlugin(id);
                                return plugin == null ? id.getIdString() : plugin.getName();
                            }
                        }, (String)","));
                        s.append(required.size() == 1 ? "\" is not enabled." : "\" are not enabled.");
                    }
                    this.myPanel.setToolTipText(s.toString());
                }
                if (PluginManager.isIncompatible(this.myPluginDescriptor)) {
                    this.myPanel.setToolTipText(IdeBundle.message((String)"plugin.manager.incompatible.tooltip.warning", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
                    this.myNameLabel.setForeground((Color)JBColor.RED);
                }
            }
            return this.myPanel;
        }
    }

    private class EnabledPluginInfo
    extends ColumnInfo<IdeaPluginDescriptor, Boolean> {
        public EnabledPluginInfo() {
            super("");
        }

        public Boolean valueOf(IdeaPluginDescriptor ideaPluginDescriptor) {
            return (Boolean)InstalledPluginsTableModel.this.myEnabled.get(ideaPluginDescriptor.getPluginId());
        }

        public boolean isCellEditable(IdeaPluginDescriptor ideaPluginDescriptor) {
            return true;
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public TableCellEditor getEditor(IdeaPluginDescriptor o) {
            return new BooleanTableCellEditor();
        }

        public TableCellRenderer getRenderer(IdeaPluginDescriptor ideaPluginDescriptor) {
            return new BooleanTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    return super.getTableCellRendererComponent(table, value == null ? Boolean.TRUE : value, isSelected, hasFocus, row, column);
                }
            };
        }

        public void setValue(IdeaPluginDescriptor ideaPluginDescriptor, Boolean value) {
            PluginId currentPluginId = ideaPluginDescriptor.getPluginId();
            Boolean enabled = InstalledPluginsTableModel.this.myEnabled.get(currentPluginId) == null ? Boolean.FALSE : value;
            InstalledPluginsTableModel.this.myEnabled.put(currentPluginId, enabled);
            InstalledPluginsTableModel.this.updatePluginDependencies();
            InstalledPluginsTableModel.this.warnAboutMissedDependencies(enabled, new IdeaPluginDescriptor[]{ideaPluginDescriptor});
            InstalledPluginsTableModel.this.hideNotApplicablePlugins(value, new IdeaPluginDescriptor[]{ideaPluginDescriptor});
        }

        public Comparator<IdeaPluginDescriptor> getComparator() {
            return new Comparator<IdeaPluginDescriptor>(){

                @Override
                public int compare(IdeaPluginDescriptor o1, IdeaPluginDescriptor o2) {
                    Boolean enabled1 = (Boolean)InstalledPluginsTableModel.this.myEnabled.get(o1.getPluginId());
                    Boolean enabled2 = (Boolean)InstalledPluginsTableModel.this.myEnabled.get(o2.getPluginId());
                    if (enabled1 != null && enabled1.booleanValue()) {
                        if (enabled2 != null && enabled2.booleanValue()) {
                            return 0;
                        }
                        return 1;
                    }
                    if (enabled2 == null || !enabled2.booleanValue()) {
                        return 0;
                    }
                    return -1;
                }
            };
        }

        public int getWidth(JTable table) {
            return new JCheckBox().getPreferredSize().width;
        }
    }
}

