/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.plugins.ActionInstallPlugin;
import com.intellij.ide.plugins.AvailablePluginsManagerMain;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.ide.plugins.UninstallPluginAction;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class InstalledPluginsManagerMain
extends PluginManagerMain {
    public InstalledPluginsManagerMain(PluginManagerUISettings uiSettings) {
        super(uiSettings);
        this.init();
        this.myActionsPanel.setLayout(new FlowLayout(0));
        JButton jbButton = new JButton("Install JetBrains plugin...");
        jbButton.setMnemonic('j');
        jbButton.addActionListener(new BrowseRepoListener("JetBrains"));
        this.myActionsPanel.add(jbButton);
        JButton button = new JButton("Browse repositories...");
        button.setMnemonic('b');
        button.addActionListener(new BrowseRepoListener(null));
        this.myActionsPanel.add(button);
        JButton installPluginFromFileSystem = new JButton("Install plugin from disk...");
        installPluginFromFileSystem.setMnemonic('d');
        installPluginFromFileSystem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = new FileChooserDescriptor(false, false, true, true, false, false){

                    public boolean isFileSelectable(VirtualFile file) {
                        String extension = file.getExtension();
                        return Comparing.strEqual((String)extension, (String)"jar") || Comparing.strEqual((String)extension, (String)"zip");
                    }
                };
                descriptor.setTitle("Choose Plugin File");
                descriptor.setDescription("JAR and ZIP archives are accepted");
                FileChooser.chooseFile((FileChooserDescriptor)descriptor, null, (Component)InstalledPluginsManagerMain.this.myActionsPanel, null, (Consumer)new Consumer<VirtualFile>(){

                    public void consume(@NotNull VirtualFile virtualFile) {
                        if (virtualFile == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/InstalledPluginsManagerMain$1$2", "consume"));
                        }
                        File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                        try {
                            File oldFile;
                            IdeaPluginDescriptorImpl pluginDescriptor = PluginDownloader.loadDescriptionFromJar(file);
                            if (pluginDescriptor == null) {
                                Messages.showErrorDialog((String)("Fail to load plugin descriptor from file " + file.getName()), (String)CommonBundle.getErrorTitle());
                                return;
                            }
                            if (PluginManagerCore.isIncompatible(pluginDescriptor)) {
                                Messages.showErrorDialog((String)("Plugin " + pluginDescriptor.getName() + " is incompatible with current installation"), (String)CommonBundle.getErrorTitle());
                                return;
                            }
                            IdeaPluginDescriptor alreadyInstalledPlugin = PluginManager.getPlugin(pluginDescriptor.getPluginId());
                            if (alreadyInstalledPlugin != null && (oldFile = alreadyInstalledPlugin.getPath()) != null) {
                                StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)new StartupActionScriptManager.DeleteCommand(oldFile));
                            }
                            if (((InstalledPluginsTableModel)InstalledPluginsManagerMain.this.pluginsModel).appendOrUpdateDescriptor(pluginDescriptor)) {
                                PluginDownloader.install(file, file.getName(), false);
                                InstalledPluginsManagerMain.this.select(pluginDescriptor);
                                InstalledPluginsManagerMain.this.checkInstalledPluginDependencies(pluginDescriptor);
                                InstalledPluginsManagerMain.this.setRequireShutdown(true);
                            } else {
                                Messages.showInfoMessage((Component)InstalledPluginsManagerMain.this.myActionsPanel, (String)("Plugin " + pluginDescriptor.getName() + " was already installed"), (String)CommonBundle.getWarningTitle());
                            }
                        }
                        catch (IOException ex) {
                            Messages.showErrorDialog((String)ex.getMessage(), (String)CommonBundle.getErrorTitle());
                        }
                    }
                });
            }
        });
        this.myActionsPanel.add(installPluginFromFileSystem);
        StatusText emptyText = this.pluginTable.getEmptyText();
        emptyText.setText("Nothing to show.");
        emptyText.appendText(" Click ");
        emptyText.appendText("Browse", SimpleTextAttributes.LINK_ATTRIBUTES, (ActionListener)new BrowseRepoListener(null));
        emptyText.appendText(" to search for non-bundled plugins.");
    }

    private void checkInstalledPluginDependencies(IdeaPluginDescriptorImpl pluginDescriptor) {
        HashSet<PluginId> notInstalled = new HashSet<PluginId>();
        HashSet<PluginId> disabledIds = new HashSet<PluginId>();
        PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
        Object[] optionalDependentPluginIds = pluginDescriptor.getOptionalDependentPluginIds();
        for (PluginId id : dependentPluginIds) {
            if (ArrayUtilRt.find((Object[])optionalDependentPluginIds, (Object)id) > -1) continue;
            boolean disabled = ((InstalledPluginsTableModel)this.pluginsModel).isDisabled(id);
            boolean enabled = ((InstalledPluginsTableModel)this.pluginsModel).isEnabled(id);
            if (!(enabled || disabled || PluginManagerCore.isModuleDependency(id))) {
                notInstalled.add(id);
                continue;
            }
            if (!disabled) continue;
            disabledIds.add(id);
        }
        if (!notInstalled.isEmpty()) {
            Messages.showWarningDialog((String)("Plugin " + pluginDescriptor.getName() + " depends on unknown plugin" + (notInstalled.size() > 1 ? "s " : " ") + StringUtil.join(notInstalled, (Function)new Function<PluginId, String>(){

                public String fun(PluginId id) {
                    return id.toString();
                }
            }, (String)", ")), (String)CommonBundle.getWarningTitle());
        }
        if (!disabledIds.isEmpty()) {
            HashSet<IdeaPluginDescriptor> dependencies = new HashSet<IdeaPluginDescriptor>();
            for (IdeaPluginDescriptor ideaPluginDescriptor : this.pluginsModel.getAllPlugins()) {
                if (!disabledIds.contains(ideaPluginDescriptor.getPluginId())) continue;
                dependencies.add(ideaPluginDescriptor);
            }
            String disabledPluginsMessage = "disabled plugin" + (dependencies.size() > 1 ? "s " : " ");
            String message = "Plugin " + pluginDescriptor.getName() + " depends on " + disabledPluginsMessage + StringUtil.join(dependencies, (Function)new Function<IdeaPluginDescriptor, String>(){

                public String fun(IdeaPluginDescriptor ideaPluginDescriptor) {
                    return ideaPluginDescriptor.getName();
                }
            }, (String)", ") + ". Enable " + disabledPluginsMessage.trim() + "?";
            if (Messages.showOkCancelDialog((Component)this.myActionsPanel, (String)message, (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon()) == 0) {
                ((InstalledPluginsTableModel)this.pluginsModel).enableRows(dependencies.toArray(new IdeaPluginDescriptor[dependencies.size()]), Boolean.TRUE);
            }
        }
    }

    @Override
    protected void propagateUpdates(List<IdeaPluginDescriptor> list) {
    }

    private PluginManagerConfigurable createAvailableConfigurable(final String vendorFilter) {
        return new PluginManagerConfigurable(PluginManagerUISettings.getInstance(), true){

            @Override
            protected PluginManagerMain createPanel() {
                return new AvailablePluginsManagerMain(InstalledPluginsManagerMain.this, this.myUISettings, vendorFilter);
            }

            @Override
            public String getDisplayName() {
                return vendorFilter != null ? "Browse " + vendorFilter + " Plugins " : "Browse Repositories";
            }
        };
    }

    @Override
    protected JScrollPane createTable() {
        this.pluginsModel = new InstalledPluginsTableModel();
        this.pluginTable = new PluginTable(this.pluginsModel);
        this.pluginTable.setTableHeader(null);
        JScrollPane installedScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.pluginTable), (int)20, (int)30);
        this.pluginTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int column = InstalledPluginsTableModel.getCheckboxColumn();
                int[] selectedRows = InstalledPluginsManagerMain.this.pluginTable.getSelectedRows();
                boolean currentlyMarked = true;
                for (int selectedRow : selectedRows) {
                    if (selectedRow < 0 || !InstalledPluginsManagerMain.this.pluginTable.isCellEditable(selectedRow, column)) {
                        return;
                    }
                    Boolean enabled = (Boolean)InstalledPluginsManagerMain.this.pluginTable.getValueAt(selectedRow, column);
                    currentlyMarked &= enabled == null || enabled != false;
                }
                IdeaPluginDescriptor[] selected = new IdeaPluginDescriptor[selectedRows.length];
                int selectedLength = selected.length;
                for (int i = 0; i < selectedLength; ++i) {
                    selected[i] = InstalledPluginsManagerMain.this.pluginsModel.getObjectAt(InstalledPluginsManagerMain.this.pluginTable.convertRowIndexToModel(selectedRows[i]));
                }
                ((InstalledPluginsTableModel)InstalledPluginsManagerMain.this.pluginsModel).enableRows(selected, currentlyMarked ? Boolean.FALSE : Boolean.TRUE);
                InstalledPluginsManagerMain.this.pluginTable.repaint();
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.pluginTable.setExpandableItemsEnabled(false);
        return installedScrollPane;
    }

    @Override
    protected PluginManagerMain getAvailable() {
        return this;
    }

    @Override
    protected PluginManagerMain getInstalled() {
        return this;
    }

    @Override
    protected ActionGroup getActionGroup(boolean inToolbar) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        if (inToolbar) {
            actionGroup.add((AnAction)new MyFilterEnabledAction());
        } else {
            actionGroup.add((AnAction)new PluginManagerMain.RefreshAction(this));
            actionGroup.addAction((AnAction)this.createSortersGroup());
            actionGroup.add((AnAction)Separator.getInstance());
            actionGroup.add((AnAction)new ActionInstallPlugin(this.getAvailable(), this.getInstalled()));
            actionGroup.add((AnAction)new UninstallPluginAction(this, this.pluginTable));
        }
        return actionGroup;
    }

    @Override
    public boolean isModified() {
        boolean modified = super.isModified();
        if (modified) {
            return true;
        }
        for (int i = 0; i < this.pluginsModel.getRowCount(); ++i) {
            IdeaPluginDescriptor pluginDescriptor = this.pluginsModel.getObjectAt(i);
            if (pluginDescriptor.isEnabled() == ((InstalledPluginsTableModel)this.pluginsModel).isEnabled(pluginDescriptor.getPluginId())) continue;
            return true;
        }
        for (IdeaPluginDescriptor descriptor : this.pluginsModel.filtered) {
            if (descriptor.isEnabled() == ((InstalledPluginsTableModel)this.pluginsModel).isEnabled(descriptor.getPluginId())) continue;
            return true;
        }
        List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
        for (Map.Entry<PluginId, Boolean> entry : ((InstalledPluginsTableModel)this.pluginsModel).getEnabledMap().entrySet()) {
            Boolean enabled = entry.getValue();
            if (enabled == null || enabled.booleanValue() || disabledPlugins.contains(entry.getKey().toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String apply() {
        String apply = super.apply();
        if (apply != null) {
            return apply;
        }
        for (int i = 0; i < this.pluginTable.getRowCount(); ++i) {
            IdeaPluginDescriptor pluginDescriptor = this.pluginsModel.getObjectAt(i);
            Boolean enabled = (Boolean)this.pluginsModel.getValueAt(i, InstalledPluginsTableModel.getCheckboxColumn());
            pluginDescriptor.setEnabled(enabled != null && enabled != false);
        }
        for (IdeaPluginDescriptor descriptor : this.pluginsModel.filtered) {
            descriptor.setEnabled(((InstalledPluginsTableModel)this.pluginsModel).isEnabled(descriptor.getPluginId()));
        }
        try {
            ArrayList<String> ids = new ArrayList<String>();
            for (Map.Entry<PluginId, Boolean> entry : ((InstalledPluginsTableModel)this.pluginsModel).getEnabledMap().entrySet()) {
                Boolean value = entry.getValue();
                if (value == null || value.booleanValue()) continue;
                ids.add(entry.getKey().getIdString());
            }
            PluginManagerCore.saveDisabledPlugins(ids, false);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @Override
    protected String canApply() {
        HashMap<PluginId, Set<PluginId>> dependentToRequiredListMap = new HashMap<PluginId, Set<PluginId>>(((InstalledPluginsTableModel)this.pluginsModel).getDependentToRequiredListMap());
        Iterator iterator = dependentToRequiredListMap.keySet().iterator();
        while (iterator.hasNext()) {
            PluginId id = (PluginId)iterator.next();
            boolean hasNonModuleDeps = false;
            for (PluginId pluginId : (Set)dependentToRequiredListMap.get(id)) {
                if (PluginManagerCore.isModuleDependency(pluginId)) continue;
                hasNonModuleDeps = true;
                break;
            }
            if (hasNonModuleDeps) continue;
            iterator.remove();
        }
        if (!dependentToRequiredListMap.isEmpty()) {
            return "<html><body style=\"padding: 5px;\">Unable to apply changes: plugin" + (dependentToRequiredListMap.size() == 1 ? " " : "s ") + StringUtil.join(dependentToRequiredListMap.keySet(), (Function)new Function<PluginId, String>(){

                public String fun(PluginId pluginId) {
                    IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getPlugin(pluginId);
                    return "\"" + (ideaPluginDescriptor != null ? ideaPluginDescriptor.getName() : pluginId.getIdString()) + "\"";
                }
            }, (String)", ") + " won't be able to load.</body></html>";
        }
        return super.canApply();
    }

    private class BrowseRepoListener
    implements ActionListener {
        private final String myVendor;

        public BrowseRepoListener(String vendor) {
            this.myVendor = vendor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final PluginManagerConfigurable configurable = InstalledPluginsManagerMain.this.createAvailableConfigurable(this.myVendor);
            SingleConfigurableEditor configurableEditor = new SingleConfigurableEditor(InstalledPluginsManagerMain.this.myActionsPanel, (Configurable)configurable, ShowSettingsUtilImpl.createDimensionKey((Configurable)configurable), false){
                {
                    super(x0, x1, x2, x3);
                    this.setOKButtonText(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]));
                    this.setOKButtonMnemonic(67);
                    String filter = InstalledPluginsManagerMain.this.myFilter.getFilter();
                    if (!StringUtil.isEmptyOrSpaces((String)filter)) {
                        Runnable searchRunnable = configurable.enableSearch(filter);
                        PluginManagerMain.LOG.assertTrue(searchRunnable != null);
                        searchRunnable.run();
                    }
                }

                @Override
                @NotNull
                protected Action[] createActions() {
                    Action[] actionArray = new Action[]{this.getOKAction()};
                    if (actionArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/InstalledPluginsManagerMain$BrowseRepoListener$1", "createActions"));
                    }
                    return actionArray;
                }
            };
            configurableEditor.show();
        }
    }

    private class MyFilterEnabledAction
    extends ComboBoxAction
    implements DumbAware {
        private MyFilterEnabledAction() {
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setText(((InstalledPluginsTableModel)InstalledPluginsManagerMain.this.pluginsModel).getEnabledFilter());
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup gr = new DefaultActionGroup();
            for (final String enabledValue : InstalledPluginsTableModel.ENABLED_VALUES) {
                gr.add(new AnAction(enabledValue){

                    public void actionPerformed(AnActionEvent e) {
                        IdeaPluginDescriptor[] selection = InstalledPluginsManagerMain.this.pluginTable.getSelectedObjects();
                        String filter = InstalledPluginsManagerMain.this.myFilter.getFilter().toLowerCase();
                        ((InstalledPluginsTableModel)InstalledPluginsManagerMain.this.pluginsModel).setEnabledFilter(enabledValue, filter);
                        if (selection != null) {
                            InstalledPluginsManagerMain.this.select(selection);
                        }
                    }
                });
            }
            DefaultActionGroup defaultActionGroup = gr;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/InstalledPluginsManagerMain$MyFilterEnabledAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }

        public JComponent createCustomComponent(Presentation presentation) {
            JComponent component = super.createCustomComponent(presentation);
            JPanel panel = new JPanel(new BorderLayout());
            panel.setOpaque(false);
            panel.add((Component)component, "Center");
            JLabel comp = new JLabel("Show:");
            comp.setIconTextGap(0);
            comp.setHorizontalTextPosition(4);
            comp.setVerticalTextPosition(0);
            comp.setAlignmentX(1.0f);
            panel.add((Component)comp, "West");
            panel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)2, (int)0, (int)0));
            return panel;
        }
    }
}

