/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ByteArrayWrapper
implements Comparable<ByteArrayWrapper> {
    private final byte[] myData;

    public ByteArrayWrapper(@NotNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/passwordSafe/impl/providers/ByteArrayWrapper", "<init>"));
        }
        this.myData = data;
    }

    public int hashCode() {
        return Arrays.hashCode(this.myData);
    }

    public boolean equals(Object obj) {
        return obj instanceof ByteArrayWrapper && Arrays.equals(this.myData, ((ByteArrayWrapper)obj).myData);
    }

    @Override
    public int compareTo(ByteArrayWrapper o) {
        if (o == null) {
            return -1;
        }
        int n = Math.max(o.myData.length, this.myData.length);
        for (int i = 0; i < n; ++i) {
            int d = this.myData[i] - o.myData[i];
            if (d == 0) continue;
            return d;
        }
        return this.myData.length - o.myData.length;
    }

    public byte[] unwrap() {
        return this.myData;
    }
}

