/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.palette.impl;

import com.intellij.ide.palette.PaletteGroup;
import com.intellij.ide.palette.PaletteItem;
import com.intellij.ide.palette.PaletteItemProvider;
import com.intellij.ide.palette.impl.PaletteComponentList;
import com.intellij.ide.palette.impl.PaletteContentWindow;
import com.intellij.ide.palette.impl.PaletteGroupHeader;
import com.intellij.ide.palette.impl.PaletteManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PaletteWindow
extends JPanel
implements DataProvider {
    private final Project myProject;
    private final ArrayList<PaletteGroupHeader> myGroupHeaders = new ArrayList();
    private final PaletteItemProvider[] myProviders;
    private final MyPropertyChangeListener myPropertyChangeListener = new MyPropertyChangeListener();
    private final Set<PaletteGroup> myGroups = new HashSet();
    private final JTabbedPane myTabbedPane = new JBTabbedPane();
    private final JScrollPane myScrollPane = ScrollPaneFactory.createScrollPane();
    private final MyListSelectionListener myListSelectionListener = new MyListSelectionListener();
    private PaletteGroupHeader myLastFocusedGroup;
    @NonNls
    private static final String ourHelpID = "guiDesigner.uiTour.palette";
    private PaletteManager myPaletteManager;
    private final DragSourceListener myDragSourceListener = new DragSourceAdapter(){

        @Override
        public void dragDropEnd(DragSourceDropEvent event) {
            Component component = event.getDragSourceContext().getComponent();
            if (!event.getDropSuccess() && component instanceof PaletteComponentList && PaletteWindow.this.getRootPane() == ((JComponent)component).getRootPane()) {
                PaletteWindow.this.clearActiveItem();
            }
        }
    };

    public PaletteWindow(Project project) {
        this.myProject = project;
        this.myPaletteManager = PaletteManager.getInstance(this.myProject);
        for (PaletteItemProvider provider : this.myProviders = (PaletteItemProvider[])Extensions.getExtensions((ExtensionPointName)PaletteItemProvider.EP_NAME, (AreaInstance)project)) {
            provider.addListener((PropertyChangeListener)this.myPropertyChangeListener);
        }
        this.setLayout(new GridLayout(1, 1));
        this.myScrollPane.addMouseListener((MouseListener)((Object)new MyScrollPanePopupHandler()));
        this.myScrollPane.setBorder(null);
        KeyStroke escStroke = KeyStroke.getKeyStroke(27, 0);
        new ClearActiveItemAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(escStroke), this.myScrollPane);
        this.refreshPalette();
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DragSource.getDefaultDragSource().addDragSourceListener(this.myDragSourceListener);
        }
    }

    public void dispose() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DragSource.getDefaultDragSource().removeDragSourceListener(this.myDragSourceListener);
        }
    }

    public void refreshPalette() {
        this.refreshPalette(null);
    }

    public void refreshPalette(@Nullable VirtualFile selectedFile) {
        for (PaletteGroupHeader groupHeader : this.myGroupHeaders) {
            groupHeader.getComponentList().removeListSelectionListener(this.myListSelectionListener);
        }
        String[] oldTabNames = PaletteWindow.collectTabNames(this.myGroups);
        this.myTabbedPane.removeAll();
        this.myGroupHeaders.clear();
        this.myGroups.clear();
        ArrayList<PaletteGroup> currentGroups = this.collectCurrentGroups(selectedFile);
        String[] tabNames = PaletteWindow.collectTabNames(currentGroups);
        if (tabNames.length == 1) {
            if (oldTabNames.length != 1) {
                this.remove(this.myTabbedPane);
                this.add(this.myScrollPane);
            }
            PaletteContentWindow contentWindow = new PaletteContentWindow();
            this.myScrollPane.getViewport().setView(contentWindow);
            for (PaletteGroup group : currentGroups) {
                this.addGroupToControl(group, contentWindow);
            }
            JComponent view = (JComponent)this.myScrollPane.getViewport().getView();
            if (view != null) {
                view.revalidate();
                for (Component component : view.getComponents()) {
                    ((JComponent)component).revalidate();
                }
            }
        } else {
            if (oldTabNames.length <= 1) {
                this.remove(this.myScrollPane);
                this.add(this.myTabbedPane);
            }
            for (String tabName : tabNames) {
                PaletteContentWindow contentWindow = new PaletteContentWindow();
                JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)contentWindow);
                scrollPane.addMouseListener((MouseListener)((Object)new MyScrollPanePopupHandler()));
                this.myTabbedPane.add(tabName, scrollPane);
                for (PaletteGroup group : currentGroups) {
                    if (!group.getTabName().equals(tabName)) continue;
                    this.addGroupToControl(group, contentWindow);
                }
            }
            this.myTabbedPane.revalidate();
        }
    }

    private void addGroupToControl(PaletteGroup group, JComponent control) {
        PaletteGroupHeader groupHeader = new PaletteGroupHeader(this, group);
        this.myGroupHeaders.add(groupHeader);
        this.myGroups.add(group);
        control.add(groupHeader);
        PaletteComponentList componentList = new PaletteComponentList(this.myProject, group);
        control.add((Component)((Object)componentList));
        groupHeader.setComponentList(componentList);
        componentList.addListSelectionListener(this.myListSelectionListener);
    }

    private static String[] collectTabNames(Collection<PaletteGroup> groups) {
        TreeSet<String> result = new TreeSet<String>();
        for (PaletteGroup group : groups) {
            result.add(group.getTabName());
        }
        return ArrayUtil.toStringArray(result);
    }

    private ArrayList<PaletteGroup> collectCurrentGroups(@Nullable VirtualFile selectedFile) {
        VirtualFile[] editedFiles;
        ArrayList<PaletteGroup> result = new ArrayList<PaletteGroup>();
        if (selectedFile == null && (editedFiles = FileEditorManager.getInstance((Project)this.myProject).getSelectedFiles()).length > 0) {
            selectedFile = editedFiles[0];
        }
        if (selectedFile != null) {
            for (PaletteItemProvider provider : this.myProviders) {
                PaletteGroup[] groups = provider.getActiveGroups(selectedFile);
                Collections.addAll(result, groups);
            }
        }
        return result;
    }

    public void refreshPaletteIfChanged(VirtualFile selectedFile) {
        HashSet currentGroups = new HashSet(this.collectCurrentGroups(selectedFile));
        if (!currentGroups.equals(this.myGroups)) {
            this.refreshPalette(selectedFile);
        }
    }

    public int getActiveGroupCount() {
        return this.myGroups.size();
    }

    public void clearActiveItem() {
        if (this.getActiveItem() == null) {
            return;
        }
        for (PaletteGroupHeader group : this.myGroupHeaders) {
            group.getComponentList().clearSelection();
        }
        ListSelectionEvent event = new ListSelectionEvent(this, -1, -1, false);
        this.myPaletteManager.notifySelectionChanged(event);
    }

    @Nullable
    public PaletteItem getActiveItem() {
        for (PaletteGroupHeader groupHeader : this.myGroupHeaders) {
            if (!groupHeader.isSelected() || groupHeader.getComponentList().getSelectedValue() == null) continue;
            return (PaletteItem)groupHeader.getComponentList().getSelectedValue();
        }
        return null;
    }

    @Nullable
    public Object getData(String dataId) {
        JScrollPane activeScrollPane;
        PaletteContentWindow activeContentWindow;
        PaletteGroupHeader groupHeader;
        Object data;
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return ourHelpID;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        PaletteItem item = this.getActiveItem();
        if (item != null && (data = item.getData(this.myProject, dataId)) != null) {
            return data;
        }
        for (PaletteGroupHeader groupHeader2 : this.myGroupHeaders) {
            if ((!groupHeader2.isSelected() || groupHeader2.getComponentList().getSelectedValue() == null) && groupHeader2 != this.myLastFocusedGroup) continue;
            return groupHeader2.getGroup().getData(this.myProject, dataId);
        }
        int tabCount = PaletteWindow.collectTabNames(this.myGroups).length;
        if (tabCount > 0 && (groupHeader = (activeContentWindow = (PaletteContentWindow)(activeScrollPane = tabCount == 1 ? this.myScrollPane : (JScrollPane)this.myTabbedPane.getSelectedComponent()).getViewport().getView()).getLastGroupHeader()) != null) {
            return groupHeader.getGroup().getData(this.myProject, dataId);
        }
        return null;
    }

    public Project getProject() {
        return this.myProject;
    }

    void setLastFocusedGroup(PaletteGroupHeader focusedGroup) {
        this.myLastFocusedGroup = focusedGroup;
        for (PaletteGroupHeader group : this.myGroupHeaders) {
            group.getComponentList().clearSelection();
        }
    }

    private class ClearActiveItemAction
    extends AnAction {
        private ClearActiveItemAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            PaletteWindow.this.clearActiveItem();
        }
    }

    private static class MyScrollPanePopupHandler
    extends PopupHandler {
        private MyScrollPanePopupHandler() {
        }

        public void invokePopup(Component comp, int x, int y) {
            PaletteGroupHeader groupHeader;
            JScrollPane scrollPane = (JScrollPane)comp;
            PaletteContentWindow contentWindow = (PaletteContentWindow)scrollPane.getViewport().getView();
            if (contentWindow != null && (groupHeader = contentWindow.getLastGroupHeader()) != null) {
                groupHeader.showGroupPopupMenu(comp, x, y);
            }
        }
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PaletteWindow.this.refreshPalette();
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            PaletteComponentList sourceList = (PaletteComponentList)((Object)e.getSource());
            for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                if (!sourceList.isSelectedIndex(i)) continue;
                for (PaletteGroupHeader group : PaletteWindow.this.myGroupHeaders) {
                    if (group.getComponentList() == sourceList) continue;
                    group.getComponentList().clearSelection();
                }
                break;
            }
            PaletteWindow.this.myPaletteManager.notifySelectionChanged(e);
        }
    }
}

