/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarBorder;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.ui.NavBarUIManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class NavBarRootPaneExtension
extends IdeRootPaneNorthExtension {
    private JComponent myWrapperPanel;
    @NonNls
    public static final String NAV_BAR = "NavBar";
    private Project myProject;
    private NavBarPanel myNavigationBar;
    private JPanel myRunPanel;
    private final boolean myNavToolbarGroupExist;
    private JScrollPane myScrollPane;

    public NavBarRootPaneExtension(Project project) {
        this.myProject = project;
        UISettings.getInstance().addUISettingsListener(new UISettingsListener(){

            public void uiSettingsChanged(UISettings source) {
                NavBarRootPaneExtension.this.toggleRunPanel(!source.SHOW_MAIN_TOOLBAR && source.SHOW_NAVIGATION_BAR && !UISettings.getInstance().PRESENTATION_MODE);
            }
        }, (Disposable)this);
        this.myNavToolbarGroupExist = NavBarRootPaneExtension.runToolbarExists();
        Disposer.register((Disposable)this.myProject, (Disposable)this);
    }

    public void revalidate() {
        UISettings settings = UISettings.getInstance();
        if (!settings.SHOW_MAIN_TOOLBAR && settings.SHOW_NAVIGATION_BAR && !UISettings.getInstance().PRESENTATION_MODE) {
            this.toggleRunPanel(false);
            this.toggleRunPanel(true);
        }
    }

    public IdeRootPaneNorthExtension copy() {
        return new NavBarRootPaneExtension(this.myProject);
    }

    public boolean isMainToolbarVisible() {
        return !UISettings.getInstance().PRESENTATION_MODE && (UISettings.getInstance().SHOW_MAIN_TOOLBAR || !this.myNavToolbarGroupExist);
    }

    public static boolean runToolbarExists() {
        AnAction correctedAction = CustomActionsSchema.getInstance().getCorrectedAction("NavBarToolBar");
        return correctedAction instanceof DefaultActionGroup && ((DefaultActionGroup)correctedAction).getChildrenCount() > 0 || correctedAction instanceof CustomisedActionGroup && ((CustomisedActionGroup)correctedAction).getFirstAction() != null;
    }

    public JComponent getComponent() {
        if (this.myWrapperPanel == null) {
            this.myWrapperPanel = new NavBarWrapperPanel(new BorderLayout()){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    NavBarUIManager.getUI().doPaintWrapperPanel((Graphics2D)g, this.getBounds(), NavBarRootPaneExtension.this.isMainToolbarVisible());
                }

                @Override
                public Insets getInsets() {
                    return NavBarUIManager.getUI().getWrapperPanelInsets(super.getInsets());
                }
            };
            this.myWrapperPanel.add((Component)this.buildNavBarPanel(), "Center");
            this.toggleRunPanel(!UISettings.getInstance().SHOW_MAIN_TOOLBAR && !UISettings.getInstance().PRESENTATION_MODE);
        }
        return this.myWrapperPanel;
    }

    private static void alignVertically(Container container) {
        if (container.getComponentCount() == 1) {
            Component c = container.getComponent(0);
            Insets insets = container.getInsets();
            Dimension d = c.getPreferredSize();
            Rectangle r = container.getBounds();
            c.setBounds(insets.left, (r.height - d.height) / 2, r.width - insets.left - insets.right, d.height);
        }
    }

    private void toggleRunPanel(boolean show) {
        if (show && this.myRunPanel == null && NavBarRootPaneExtension.runToolbarExists()) {
            ActionManager manager = ActionManager.getInstance();
            AnAction toolbarRunGroup = CustomActionsSchema.getInstance().getCorrectedAction("NavBarToolBar");
            if (toolbarRunGroup instanceof ActionGroup) {
                boolean needGap = NavBarRootPaneExtension.isNeedGap(toolbarRunGroup);
                ActionToolbar actionToolbar = manager.createActionToolbar(NAV_BAR, (ActionGroup)toolbarRunGroup, true);
                JComponent component = actionToolbar.getComponent();
                component.setOpaque(false);
                this.myRunPanel = new JPanel(new BorderLayout()){

                    @Override
                    public void doLayout() {
                        NavBarRootPaneExtension.alignVertically(this);
                    }
                };
                this.myRunPanel.setOpaque(false);
                this.myRunPanel.add((Component)component, "Center");
                this.myRunPanel.setBorder(BorderFactory.createEmptyBorder(0, needGap ? 5 : 1, 0, 0));
                this.myWrapperPanel.add((Component)this.myRunPanel, "East");
            }
        } else if (!show && this.myRunPanel != null) {
            this.myWrapperPanel.remove(this.myRunPanel);
            this.myRunPanel = null;
        }
    }

    private boolean isUndocked() {
        Window ancestor = SwingUtilities.getWindowAncestor(this.myWrapperPanel);
        return ancestor != null && !(ancestor instanceof IdeFrameImpl) || !UISettings.getInstance().SHOW_MAIN_TOOLBAR || !UISettings.getInstance().PRESENTATION_MODE;
    }

    private static boolean isNeedGap(AnAction group) {
        AnAction firstAction = NavBarRootPaneExtension.getFirstAction(group);
        return firstAction instanceof ComboBoxAction;
    }

    @Nullable
    private static AnAction getFirstAction(AnAction group) {
        if (group instanceof DefaultActionGroup) {
            AnAction firstAction = null;
            for (AnAction action : ((DefaultActionGroup)group).getChildActionsOrStubs()) {
                if (!(action instanceof DefaultActionGroup)) {
                    if (action instanceof Separator || action instanceof ActionGroup) continue;
                    firstAction = action;
                    break;
                }
                firstAction = NavBarRootPaneExtension.getFirstAction((AnAction)((DefaultActionGroup)action));
                if (firstAction != null) break;
            }
            return firstAction;
        }
        if (group instanceof CustomisedActionGroup) {
            return ((CustomisedActionGroup)group).getFirstAction();
        }
        return null;
    }

    private JComponent buildNavBarPanel() {
        this.myNavigationBar = new NavBarPanel(this.myProject, true);
        this.myWrapperPanel.putClientProperty("NavBarPanel", this.myNavigationBar);
        this.myNavigationBar.getModel().setFixedComponent(true);
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myNavigationBar);
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                JScrollPane navBar = NavBarRootPaneExtension.this.myScrollPane;
                Insets insets = this.getInsets();
                Rectangle r = navBar.getBounds();
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.translate(r.x, r.y);
                Rectangle rectangle = new Rectangle(0, 0, r.width + insets.left + insets.right, r.height + insets.top + insets.bottom);
                NavBarUIManager.getUI().doPaintNavBarPanel(g2d, rectangle, NavBarRootPaneExtension.this.isMainToolbarVisible(), NavBarRootPaneExtension.this.isUndocked());
                if (UIUtil.isUnderAquaLookAndFeel() && NavBarRootPaneExtension.this.isUndocked()) {
                    Rectangle bounds = this.getParent().getBounds();
                    NavBarUIManager.getUI().doPaintWrapperPanel(g2d, bounds, false);
                }
                g2d.dispose();
            }

            @Override
            public void doLayout() {
                Rectangle r = this.getBounds();
                Insets insets = this.getInsets();
                int x = insets.left;
                if (NavBarRootPaneExtension.this.myScrollPane == null) {
                    return;
                }
                JScrollPane navBar = NavBarRootPaneExtension.this.myScrollPane;
                Dimension preferredSize = ((Component)navBar).getPreferredSize();
                navBar.setBounds(x, (r.height - preferredSize.height) / 2, r.width - insets.left - insets.right, preferredSize.height);
            }

            @Override
            public void updateUI() {
                super.updateUI();
                NavBarRootPaneExtension.this.myScrollPane.setVerticalScrollBarPolicy(21);
                NavBarRootPaneExtension.this.myScrollPane.setHorizontalScrollBar(null);
                NavBarRootPaneExtension.this.myScrollPane.setBorder(new NavBarBorder(true, 0));
                NavBarRootPaneExtension.this.myScrollPane.setOpaque(false);
                NavBarRootPaneExtension.this.myScrollPane.getViewport().setOpaque(false);
                NavBarRootPaneExtension.this.myScrollPane.setViewportBorder(null);
                this.setOpaque(true);
                NavBarRootPaneExtension.this.myNavigationBar.setBorder(null);
            }
        };
        panel.add((Component)this.myScrollPane, "Center");
        panel.updateUI();
        return panel;
    }

    public void uiSettingsChanged(UISettings settings) {
        if (this.myNavigationBar != null) {
            Component c;
            this.myNavigationBar.updateState(settings.SHOW_NAVIGATION_BAR);
            this.myWrapperPanel.setVisible(settings.SHOW_NAVIGATION_BAR && !UISettings.getInstance().PRESENTATION_MODE);
            this.myWrapperPanel.revalidate();
            this.myNavigationBar.revalidate();
            this.myWrapperPanel.repaint();
            if (this.myWrapperPanel.getComponentCount() > 0 && (c = this.myWrapperPanel.getComponent(0)) instanceof JComponent) {
                ((JComponent)c).setOpaque(false);
            }
        }
    }

    @NonNls
    public String getKey() {
        return NAV_BAR;
    }

    public void dispose() {
        this.myWrapperPanel.setVisible(false);
        this.myWrapperPanel = null;
        this.myRunPanel = null;
        this.myNavigationBar = null;
        this.myProject = null;
    }

    public static class NavBarWrapperPanel
    extends JPanel {
        public NavBarWrapperPanel(LayoutManager layout) {
            super(layout);
        }
    }
}

