/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.XmlCharsetDetector;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlLikeFileType
extends LanguageFileType {
    public XmlLikeFileType(Language language) {
        super(language);
    }

    public String getCharset(@NotNull VirtualFile file, byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/highlighter/XmlLikeFileType", "getCharset"));
        }
        String charset = XmlCharsetDetector.extractXmlEncodingFromProlog((byte[])content);
        return charset == null ? "UTF-8" : charset;
    }

    public Charset extractCharsetFromFileContent(Project project, @Nullable VirtualFile file, @NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/highlighter/XmlLikeFileType", "extractCharsetFromFileContent"));
        }
        String name = XmlCharsetDetector.extractXmlEncodingFromProlog((String)content);
        Charset charset = CharsetToolkit.forName((String)name);
        return charset == null ? CharsetToolkit.UTF8_CHARSET : charset;
    }

    public boolean isCaseSensitive() {
        return false;
    }
}

