/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeBuilder;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.NullableFunction;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HierarchyBrowserBaseEx
extends HierarchyBrowserBase
implements OccurenceNavigator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.hierarchy.HierarchyBrowserBaseEx");
    @NonNls
    private static final String HELP_ID = "reference.toolWindows.hierarchy";
    protected final Hashtable<String, HierarchyTreeBuilder> myBuilders;
    protected final Hashtable<String, JTree> myType2TreeMap;
    private final RefreshAction myRefreshAction;
    private final Alarm myAlarm;
    private SmartPsiElementPointer mySmartPsiElementPointer;
    private final CardLayout myCardLayout;
    private final JPanel myTreePanel;
    protected String myCurrentViewType;
    private boolean myCachedIsValidBase;
    private final HashMap<String, OccurenceNavigator> myOccurrenceNavigators;
    private static final OccurenceNavigator EMPTY_NAVIGATOR = new OccurenceNavigator(){

        public boolean hasNextOccurence() {
            return false;
        }

        public boolean hasPreviousOccurence() {
            return false;
        }

        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            return null;
        }

        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            return null;
        }

        public String getNextOccurenceActionName() {
            return "";
        }

        public String getPreviousOccurenceActionName() {
            return "";
        }
    };
    public static final String SCOPE_PROJECT = IdeBundle.message((String)"hierarchy.scope.project", (Object[])new Object[0]);
    public static final String SCOPE_ALL = IdeBundle.message((String)"hierarchy.scope.all", (Object[])new Object[0]);
    public static final String SCOPE_TEST = IdeBundle.message((String)"hierarchy.scope.test", (Object[])new Object[0]);
    public static final String SCOPE_CLASS = IdeBundle.message((String)"hierarchy.scope.this.class", (Object[])new Object[0]);
    protected final Map<String, String> myType2ScopeMap;

    public HierarchyBrowserBaseEx(@NotNull Project project, @NotNull PsiElement element) {
        JPanel contentPanel;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx", "<init>"));
        }
        super(project);
        this.myBuilders = new Hashtable();
        this.myType2TreeMap = new Hashtable();
        this.myRefreshAction = new RefreshAction();
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        this.myCachedIsValidBase = false;
        this.myOccurrenceNavigators = new HashMap();
        this.myType2ScopeMap = new HashMap<String, String>();
        this.setHierarchyBase(element);
        this.myCardLayout = new CardLayout();
        this.myTreePanel = new JPanel(this.myCardLayout);
        this.createTrees(this.myType2TreeMap);
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getInstance(project).getState();
        for (String type : this.myType2TreeMap.keySet()) {
            this.myType2ScopeMap.put(type, state.SCOPE != null ? state.SCOPE : SCOPE_ALL);
        }
        Enumeration<String> keys = this.myType2TreeMap.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            JTree tree = this.myType2TreeMap.get(key);
            this.myOccurrenceNavigators.put(key, (OccurenceNavigator)new OccurenceNavigatorSupport(tree){

                @Nullable
                protected Navigatable createDescriptorForNode(DefaultMutableTreeNode node) {
                    HierarchyNodeDescriptor descriptor = HierarchyBrowserBaseEx.this.getDescriptor(node);
                    if (descriptor == null) {
                        return null;
                    }
                    PsiElement psiElement = HierarchyBrowserBaseEx.this.getOpenFileElementFromDescriptor(descriptor);
                    if (psiElement == null || !psiElement.isValid()) {
                        return null;
                    }
                    VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
                    if (virtualFile == null) {
                        return null;
                    }
                    return new OpenFileDescriptor(psiElement.getProject(), virtualFile, psiElement.getTextOffset());
                }

                public String getNextOccurenceActionName() {
                    return HierarchyBrowserBaseEx.this.getNextOccurenceActionNameImpl();
                }

                public String getPreviousOccurenceActionName() {
                    return HierarchyBrowserBaseEx.this.getPrevOccurenceActionNameImpl();
                }
            });
            this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)tree), key);
        }
        JPanel legendPanel = this.createLegendPanel();
        if (legendPanel != null) {
            contentPanel = new JPanel(new BorderLayout());
            contentPanel.add((Component)this.myTreePanel, "Center");
            contentPanel.add((Component)legendPanel, "South");
        } else {
            contentPanel = this.myTreePanel;
        }
        this.buildUi(this.createToolbar(this.getActionPlace(), HELP_ID).getComponent(), contentPanel);
    }

    @Nullable
    protected PsiElement getOpenFileElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx", "getOpenFileElementFromDescriptor"));
        }
        return this.getElementFromDescriptor(descriptor);
    }

    @Override
    @Nullable
    protected abstract PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor var1);

    @NotNull
    protected abstract String getPrevOccurenceActionNameImpl();

    @NotNull
    protected abstract String getNextOccurenceActionNameImpl();

    protected abstract void createTrees(@NotNull Map<String, JTree> var1);

    @Nullable
    protected abstract JPanel createLegendPanel();

    protected abstract boolean isApplicableElement(@NotNull PsiElement var1);

    @Nullable
    protected abstract HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String var1, @NotNull PsiElement var2);

    @Nullable
    protected abstract Comparator<NodeDescriptor> getComparator();

    @NotNull
    protected abstract String getActionPlace();

    @NotNull
    protected abstract String getBrowserDataKey();

    protected final JTree createTree(boolean dndAware) {
        Tree tree;
        NullableFunction<Object, PsiElement> toPsiConverter = new NullableFunction<Object, PsiElement>(){

            public PsiElement fun(Object o) {
                if (o instanceof HierarchyNodeDescriptor) {
                    return ((HierarchyNodeDescriptor)((Object)o)).getContainingFile();
                }
                return null;
            }
        };
        if (dndAware) {
            tree = new DnDAwareTree(new DefaultTreeModel(new DefaultMutableTreeNode("")), (NullableFunction)toPsiConverter){
                final /* synthetic */ NullableFunction val$toPsiConverter;
                {
                    this.val$toPsiConverter = nullableFunction;
                    super(x0);
                }

                public void removeNotify() {
                    super.removeNotify();
                    if (ScreenUtil.isStandardAddRemoveNotify((Component)((Object)this))) {
                        HierarchyBrowserBaseEx.this.myRefreshAction.unregisterCustomShortcutSet((JComponent)((Object)this));
                    }
                }

                public boolean isFileColorsEnabled() {
                    return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
                }

                public Color getFileColorFor(Object object) {
                    return ProjectViewTree.getColorForObject(object, HierarchyBrowserBaseEx.this.myProject, this.val$toPsiConverter);
                }
            };
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                DnDManager.getInstance().registerSource(new DnDSource(){

                    public boolean canStartDragging(DnDAction action, Point dragOrigin) {
                        return HierarchyBrowserBaseEx.this.getSelectedElements().length > 0;
                    }

                    public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
                        return new DnDDragStartBean((Object)new TransferableWrapper(){

                            @Override
                            public TreeNode[] getTreeNodes() {
                                return (TreeNode[])tree.getSelectedNodes(TreeNode.class, null);
                            }

                            @Override
                            public PsiElement[] getPsiElements() {
                                return HierarchyBrowserBaseEx.this.getSelectedElements();
                            }

                            @Override
                            public List<File> asFileList() {
                                return PsiCopyPasteManager.asFileList(this.getPsiElements());
                            }
                        });
                    }

                    public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
                        return null;
                    }

                    public void dragDropEnd() {
                    }

                    public void dropActionChanged(int gestureModifiers) {
                    }
                }, (JComponent)tree);
            }
        } else {
            tree = new Tree(new DefaultTreeModel(new DefaultMutableTreeNode("")), (NullableFunction)toPsiConverter){
                final /* synthetic */ NullableFunction val$toPsiConverter;
                {
                    this.val$toPsiConverter = nullableFunction;
                    super(x0);
                }

                public void removeNotify() {
                    super.removeNotify();
                    if (ScreenUtil.isStandardAddRemoveNotify((Component)((Object)this))) {
                        HierarchyBrowserBaseEx.this.myRefreshAction.unregisterCustomShortcutSet((JComponent)((Object)this));
                    }
                }

                public boolean isFileColorsEnabled() {
                    return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
                }

                public Color getFileColorFor(Object object) {
                    return ProjectViewTree.getColorForObject(object, HierarchyBrowserBaseEx.this.myProject, this.val$toPsiConverter);
                }
            };
        }
        this.configureTree(tree);
        EditSourceOnDoubleClickHandler.install((JTree)tree);
        this.myRefreshAction.registerShortcutOn((JComponent)tree);
        return tree;
    }

    protected void setHierarchyBase(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx", "setHierarchyBase"));
        }
        this.mySmartPsiElementPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(element);
    }

    private void restoreCursor() {
        this.myAlarm.cancelAllRequests();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void setWaitCursor() {
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                HierarchyBrowserBaseEx.this.setCursor(Cursor.getPredefinedCursor(3));
            }
        }, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void changeView(@NotNull String typeName) {
        String displayName;
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx", "changeView"));
        }
        this.myCurrentViewType = typeName;
        PsiElement element = this.mySmartPsiElementPointer.getElement();
        if (element == null || !this.isApplicableElement(element)) {
            return;
        }
        if (this.myContent != null && (displayName = this.getContentDisplayName(typeName, element)) != null) {
            this.myContent.setDisplayName(displayName);
        }
        this.myCardLayout.show(this.myTreePanel, typeName);
        if (!this.myBuilders.containsKey(typeName)) {
            try {
                this.setWaitCursor();
                JTree tree = this.myType2TreeMap.get(typeName);
                DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode(""));
                tree.setModel(model);
                PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                HierarchyTreeStructure structure = this.createHierarchyTreeStructure(typeName, element);
                if (structure == null) {
                    return;
                }
                Comparator<NodeDescriptor> comparator = this.getComparator();
                final HierarchyTreeBuilder builder = new HierarchyTreeBuilder(this.myProject, tree, model, structure, comparator);
                this.myBuilders.put(typeName, builder);
                Disposer.register((Disposable)this, (Disposable)builder);
                final HierarchyNodeDescriptor descriptor = structure.getBaseDescriptor();
                builder.select((Object)descriptor, new Runnable(){

                    @Override
                    public void run() {
                        builder.expand((Object)descriptor, null);
                    }
                });
            }
            finally {
                this.restoreCursor();
            }
        }
        this.getCurrentTree().requestFocus();
    }

    @Nullable
    protected String getContentDisplayName(@NotNull String typeName, @NotNull PsiElement element) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx", "getContentDisplayName"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx", "getContentDisplayName"));
        }
        if (element instanceof PsiNamedElement) {
            return MessageFormat.format(typeName, ((PsiNamedElement)element).getName());
        }
        return null;
    }

    @Override
    protected void appendActions(@NotNull DefaultActionGroup actionGroup, String helpID) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx", "appendActions"));
        }
        this.prependActions(actionGroup);
        actionGroup.add((AnAction)this.myRefreshAction);
        super.appendActions(actionGroup, helpID);
    }

    protected void prependActions(DefaultActionGroup actionGroup) {
    }

    public boolean hasNextOccurence() {
        return this.getOccurrenceNavigator().hasNextOccurence();
    }

    private OccurenceNavigator getOccurrenceNavigator() {
        if (this.myCurrentViewType == null) {
            return EMPTY_NAVIGATOR;
        }
        OccurenceNavigator navigator = this.myOccurrenceNavigators.get(this.myCurrentViewType);
        return navigator != null ? navigator : EMPTY_NAVIGATOR;
    }

    public boolean hasPreviousOccurence() {
        return this.getOccurrenceNavigator().hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.getOccurrenceNavigator().goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.getOccurrenceNavigator().goPreviousOccurence();
    }

    public String getNextOccurenceActionName() {
        return this.getOccurrenceNavigator().getNextOccurenceActionName();
    }

    public String getPreviousOccurenceActionName() {
        return this.getOccurrenceNavigator().getPreviousOccurenceActionName();
    }

    @Override
    protected HierarchyTreeBuilder getCurrentBuilder() {
        return this.myBuilders.get(this.myCurrentViewType);
    }

    protected final boolean isValidBase() {
        if (PsiDocumentManager.getInstance((Project)this.myProject).getUncommittedDocuments().length > 0) {
            return this.myCachedIsValidBase;
        }
        PsiElement element = this.mySmartPsiElementPointer.getElement();
        this.myCachedIsValidBase = element != null && this.isApplicableElement(element) && element.isValid();
        return this.myCachedIsValidBase;
    }

    @Override
    protected JTree getCurrentTree() {
        if (this.myCurrentViewType == null) {
            return null;
        }
        return this.myType2TreeMap.get(this.myCurrentViewType);
    }

    public String getCurrentViewType() {
        return this.myCurrentViewType;
    }

    @Override
    public Object getData(String dataId) {
        if (this.getBrowserDataKey().equals(dataId)) {
            return this;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    private void disposeBuilders() {
        Collection<HierarchyTreeBuilder> builders = this.myBuilders.values();
        for (HierarchyTreeBuilder builder : builders) {
            Disposer.dispose((Disposable)builder);
        }
        this.myBuilders.clear();
    }

    protected void doRefresh(boolean currentBuilderOnly) {
        PsiElement element;
        if (currentBuilderOnly) {
            LOG.assertTrue(this.myCurrentViewType != null);
        }
        if (!this.isValidBase()) {
            return;
        }
        if (this.getCurrentBuilder() == null) {
            return;
        }
        final Ref storedInfo = new Ref();
        if (this.myCurrentViewType != null) {
            HierarchyTreeBuilder builder = this.getCurrentBuilder();
            storedInfo.set(builder.storeExpandedAndSelectedInfo());
        }
        if ((element = this.mySmartPsiElementPointer.getElement()) == null || !this.isApplicableElement(element)) {
            return;
        }
        final String currentViewType = this.myCurrentViewType;
        if (currentBuilderOnly) {
            Disposer.dispose((Disposable)this.getCurrentBuilder());
            this.myBuilders.remove(this.myCurrentViewType);
        } else {
            this.disposeBuilders();
        }
        this.setHierarchyBase(element);
        this.validate();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                HierarchyBrowserBaseEx.this.changeView(currentViewType);
                HierarchyTreeBuilder builder = HierarchyBrowserBaseEx.this.getCurrentBuilder();
                builder.restoreExpandedAndSelectedInfo((Pair<List<Object>, List<Object>>)((Pair)storedInfo.get()));
            }
        });
    }

    protected String getCurrentScopeType() {
        if (this.myCurrentViewType == null) {
            return null;
        }
        return this.myType2ScopeMap.get(this.myCurrentViewType);
    }

    public void setProgressIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx", "setProgressIndicator"));
        }
        for (HierarchyTreeBuilder builder : this.myBuilders.values()) {
            builder.setProgressIndicator(indicator);
        }
    }

    public class ChangeScopeAction
    extends ComboBoxAction {
        public final void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null) {
                return;
            }
            presentation.setEnabled(this.isEnabled());
            presentation.setText(HierarchyBrowserBaseEx.this.getCurrentScopeType());
        }

        protected boolean isEnabled() {
            return true;
        }

        @NotNull
        protected final DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (String name : this.getValidScopeNames()) {
                group.add((AnAction)new MenuAction(name));
            }
            group.add((AnAction)new ConfigureScopesAction());
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$ChangeScopeAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }

        private Collection<String> getValidScopeNames() {
            NamedScopesHolder[] holders;
            ArrayList<String> result = new ArrayList<String>();
            result.add(SCOPE_PROJECT);
            result.add(SCOPE_TEST);
            result.add(SCOPE_ALL);
            result.add(SCOPE_CLASS);
            for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders((Project)HierarchyBrowserBaseEx.this.myProject)) {
                NamedScope[] scopes;
                for (NamedScope scope : scopes = holder.getEditableScopes()) {
                    result.add(scope.getName());
                }
            }
            return result;
        }

        private void selectScope(String scopeType) {
            HierarchyBrowserBaseEx.this.myType2ScopeMap.put(HierarchyBrowserBaseEx.this.myCurrentViewType, scopeType);
            HierarchyBrowserManager.getInstance((Project)HierarchyBrowserBaseEx.this.myProject).getState().SCOPE = scopeType;
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    HierarchyBrowserBaseEx.this.doRefresh(true);
                }
            });
        }

        public final JComponent createCustomComponent(Presentation presentation) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel(IdeBundle.message((String)"label.scope", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)super.createCustomComponent(presentation), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private final class ConfigureScopesAction
        extends AnAction {
            private ConfigureScopesAction() {
                super("Configure...");
            }

            public void actionPerformed(AnActionEvent e) {
                EditScopesDialog.showDialog(HierarchyBrowserBaseEx.this.myProject, null);
                if (!ChangeScopeAction.this.getValidScopeNames().contains(HierarchyBrowserBaseEx.this.myType2ScopeMap.get(HierarchyBrowserBaseEx.this.myCurrentViewType))) {
                    ChangeScopeAction.this.selectScope(SCOPE_ALL);
                }
            }
        }

        private final class MenuAction
        extends AnAction {
            private final String myScopeType;

            public MenuAction(String scopeType) {
                super(scopeType);
                this.myScopeType = scopeType;
            }

            public final void actionPerformed(AnActionEvent e) {
                ChangeScopeAction.this.selectScope(this.myScopeType);
            }
        }
    }

    private class RefreshAction
    extends com.intellij.ide.actions.RefreshAction {
        public RefreshAction() {
            super(IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), AllIcons.Actions.Refresh);
        }

        @Override
        public final void actionPerformed(AnActionEvent e) {
            HierarchyBrowserBaseEx.this.doRefresh(false);
        }

        @Override
        public final void update(AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(HierarchyBrowserBaseEx.this.isValidBase());
        }
    }

    protected static class BaseOnThisElementAction
    extends AnAction {
        private final String myActionId;
        private final String myBrowserDataKey;

        public BaseOnThisElementAction(String text, String actionId, String browserDataKey) {
            super(text);
            this.myActionId = actionId;
            this.myBrowserDataKey = browserDataKey;
        }

        public final void actionPerformed(AnActionEvent event) {
            DataContext dataContext = event.getDataContext();
            final HierarchyBrowserBaseEx browser = (HierarchyBrowserBaseEx)((Object)dataContext.getData(this.myBrowserDataKey));
            if (browser == null) {
                return;
            }
            PsiElement selectedElement = browser.getSelectedElement();
            if (selectedElement == null || !browser.isApplicableElement(selectedElement)) {
                return;
            }
            final String currentViewType = browser.myCurrentViewType;
            Disposer.dispose((Disposable)browser);
            browser.setHierarchyBase(selectedElement);
            browser.validate();
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    browser.changeView(BaseOnThisElementAction.this.correctViewType(browser, currentViewType));
                }
            });
        }

        protected String correctViewType(HierarchyBrowserBaseEx browser, String viewType) {
            return viewType;
        }

        public final void update(AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            this.registerCustomShortcutSet(ActionManager.getInstance().getAction(this.myActionId).getShortcutSet(), null);
            DataContext dataContext = event.getDataContext();
            HierarchyBrowserBaseEx browser = (HierarchyBrowserBaseEx)((Object)dataContext.getData(this.myBrowserDataKey));
            if (browser == null) {
                presentation.setVisible(false);
                presentation.setEnabled(false);
                return;
            }
            presentation.setVisible(true);
            PsiElement selectedElement = browser.getSelectedElement();
            if (selectedElement == null || !browser.isApplicableElement(selectedElement)) {
                presentation.setEnabled(false);
                presentation.setVisible(false);
                return;
            }
            presentation.setEnabled(this.isEnabled(browser, selectedElement));
            String nonDefaultText = this.getNonDefaultText(browser, selectedElement);
            if (nonDefaultText != null) {
                presentation.setText(nonDefaultText);
            }
        }

        protected boolean isEnabled(@NotNull HierarchyBrowserBaseEx browser, @NotNull PsiElement element) {
            if (browser == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$BaseOnThisElementAction", "isEnabled"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$BaseOnThisElementAction", "isEnabled"));
            }
            return !element.equals(browser.mySmartPsiElementPointer.getElement()) && element.isValid();
        }

        @Nullable
        protected String getNonDefaultText(@NotNull HierarchyBrowserBaseEx browser, @NotNull PsiElement element) {
            if (browser == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$BaseOnThisElementAction", "getNonDefaultText"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/hierarchy/HierarchyBrowserBaseEx$BaseOnThisElementAction", "getNonDefaultText"));
            }
            return null;
        }
    }

    protected class AlphaSortAction
    extends ToggleAction {
        public AlphaSortAction() {
            super(IdeBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), IdeBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted);
        }

        public final boolean isSelected(AnActionEvent event) {
            return HierarchyBrowserManager.getInstance((Project)HierarchyBrowserBaseEx.this.myProject).getState().SORT_ALPHABETICALLY;
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            HierarchyBrowserManager hierarchyBrowserManager = HierarchyBrowserManager.getInstance(HierarchyBrowserBaseEx.this.myProject);
            hierarchyBrowserManager.getState().SORT_ALPHABETICALLY = flag;
            Comparator<NodeDescriptor> comparator = HierarchyBrowserBaseEx.this.getComparator();
            Collection<HierarchyTreeBuilder> builders = HierarchyBrowserBaseEx.this.myBuilders.values();
            for (HierarchyTreeBuilder builder : builders) {
                builder.setNodeDescriptorComparator(comparator);
            }
        }

        public final void update(AnActionEvent event) {
            super.update(event);
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(HierarchyBrowserBaseEx.this.isValidBase());
        }
    }
}

