/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;

public class DefaultCreateFromTemplateHandler
implements CreateFromTemplateHandler {
    @Override
    public boolean handlesTemplate(FileTemplate template) {
        return true;
    }

    @Override
    public PsiElement createFromTemplate(Project project, PsiDirectory directory, String fileName, FileTemplate template, String templateText, Map<String, Object> props) throws IncorrectOperationException {
        fileName = this.checkAppendExtension(fileName, template);
        if (FileTypeManager.getInstance().isFileIgnored(fileName)) {
            throw new IncorrectOperationException("This filename is ignored (Settings | File Types | Ignore files and folders)");
        }
        directory.checkCreateFile(fileName);
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, type, (CharSequence)templateText);
        if (template.isReformatCode()) {
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
        }
        file = (PsiFile)directory.add((PsiElement)file);
        return file;
    }

    protected String checkAppendExtension(String fileName, FileTemplate template) {
        String suggestedFileNameEnd = "." + template.getExtension();
        if (!fileName.endsWith(suggestedFileNameEnd)) {
            fileName = fileName + suggestedFileNameEnd;
        }
        return fileName;
    }

    @Override
    public boolean canCreate(PsiDirectory[] dirs) {
        return true;
    }

    @Override
    public boolean isNameRequired() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]);
    }

    @Override
    public void prepareProperties(Map<String, Object> props) {
    }
}

