/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import java.util.Collections;

public class SendToFavoritesAction
extends AnAction {
    private final String toName;

    public SendToFavoritesAction(String name) {
        super(name);
        this.toName = name;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        FavoritesTreeNodeDescriptor[] roots = (FavoritesTreeNodeDescriptor[])FavoritesTreeViewPanel.CONTEXT_FAVORITES_ROOTS_DATA_KEY.getData(dataContext);
        if (roots == null) {
            return;
        }
        for (FavoritesTreeNodeDescriptor root : roots) {
            FavoritesTreeNodeDescriptor listNode = root.getFavoritesRoot();
            if (listNode == null || listNode == root || !(listNode.getElement() instanceof FavoritesListNode)) continue;
            this.doSend(favoritesManager, new FavoritesTreeNodeDescriptor[]{root}, listNode.getElement().getName());
        }
    }

    public void doSend(FavoritesManager favoritesManager, FavoritesTreeNodeDescriptor[] roots, String listName) {
        for (FavoritesTreeNodeDescriptor root : roots) {
            AbstractTreeNode rootElement = root.getElement();
            String name = listName;
            if (name == null) {
                name = root.getFavoritesRoot().getName();
            }
            favoritesManager.removeRoot(name, Collections.singletonList(rootElement));
            favoritesManager.addRoots(this.toName, Collections.singletonList(rootElement));
        }
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(SendToFavoritesAction.isEnabled(e));
    }

    static boolean isEnabled(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        FavoritesTreeNodeDescriptor[] roots = (FavoritesTreeNodeDescriptor[])FavoritesTreeViewPanel.CONTEXT_FAVORITES_ROOTS_DATA_KEY.getData(e.getDataContext());
        if (roots == null || roots.length == 0) {
            return false;
        }
        for (FavoritesTreeNodeDescriptor root : roots) {
            FavoritesTreeNodeDescriptor listNode = root.getFavoritesRoot();
            if (listNode != null && listNode != root && listNode.getElement() instanceof FavoritesListNode) continue;
            return false;
        }
        return true;
    }
}

