/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AddToFavoritesAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.ide.favoritesTreeView.actions.AddToFavoritesAction");
    private final String myFavoritesListName;

    public AddToFavoritesAction(String choosenList) {
        this.getTemplatePresentation().setText(choosenList, false);
        this.myFavoritesListName = choosenList;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Collection<AbstractTreeNode> nodesToAdd = AddToFavoritesAction.getNodesToAdd(dataContext, true);
        if (nodesToAdd != null && !nodesToAdd.isEmpty()) {
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            FavoritesManager.getInstance(project).addRoots(this.myFavoritesListName, nodesToAdd);
        }
    }

    public static Collection<AbstractTreeNode> getNodesToAdd(DataContext dataContext, boolean inProjectView) {
        Object elements;
        FavoriteNodeProvider provider;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return Collections.emptyList();
        }
        Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        Collection<AbstractTreeNode> nodesToAdd = null;
        FavoriteNodeProvider[] arr$ = (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)project);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (nodesToAdd = (provider = arr$[i$]).getFavoriteNodes(dataContext, ViewSettings.DEFAULT)) == null; ++i$) {
        }
        if (nodesToAdd == null && (elements = AddToFavoritesAction.collectSelectedElements(dataContext)) != null) {
            nodesToAdd = AddToFavoritesAction.createNodes(project, moduleContext, elements, inProjectView, ViewSettings.DEFAULT);
        }
        return nodesToAdd;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(AddToFavoritesAction.canCreateNodes(e));
    }

    public static boolean canCreateNodes(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        if (e.getProject() == null) {
            return false;
        }
        if (e.getPlace().equals("FavoritesPopup") && FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext) == null) {
            return false;
        }
        boolean inProjectView = e.getPlace().equals("J2EEViewPopup") || e.getPlace().equals("StructureViewPopup") || e.getPlace().equals("ProjectViewPopup");
        return AddToFavoritesAction.getNodesToAdd(dataContext, inProjectView) != null;
    }

    static Object retrieveData(Object object, Object data) {
        return object == null ? data : object;
    }

    private static Object collectSelectedElements(DataContext dataContext) {
        Object elements = AddToFavoritesAction.retrieveData(null, CommonDataKeys.PSI_ELEMENT.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, CommonDataKeys.PSI_FILE.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, ModuleGroup.ARRAY_DATA_KEY.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, LibraryGroupElement.ARRAY_DATA_KEY.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, NamedLibraryElement.ARRAY_DATA_KEY.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, CommonDataKeys.VIRTUAL_FILE.getData(dataContext));
        elements = AddToFavoritesAction.retrieveData(elements, CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext));
        return elements;
    }

    @NotNull
    public static Collection<AbstractTreeNode> createNodes(Project project, Module moduleContext, Object object, boolean inProjectView, ViewSettings favoritesConfig) {
        if (project == null) {
            List<AbstractTreeNode> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddToFavoritesAction", "createNodes"));
            }
            return list;
        }
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        for (FavoriteNodeProvider favoriteNodeProvider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)project)) {
            AbstractTreeNode treeNode = favoriteNodeProvider.createNode(project, (Object)object, favoritesConfig);
            if (treeNode == null) continue;
            result.add(treeNode);
            ArrayList<AbstractTreeNode> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddToFavoritesAction", "createNodes"));
            }
            return arrayList;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        String currentViewId = ProjectView.getInstance(project).getCurrentViewId();
        AbstractProjectViewPane pane = ProjectView.getInstance(project).getProjectViewPaneById(currentViewId);
        if (object instanceof PsiElement[]) {
            for (PsiElement psiElement : (PsiElement[])object) {
                AddToFavoritesAction.addPsiElementNode(psiElement, project, result, favoritesConfig);
            }
            ArrayList<AbstractTreeNode> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddToFavoritesAction", "createNodes"));
            }
            return arrayList;
        }
        if (object instanceof PsiElement) {
            Object var9_13 = null;
            if (inProjectView && ProjectView.getInstance(project).isShowModules(currentViewId) && pane != null && pane.getSelectedDescriptor() != null && pane.getSelectedDescriptor().getElement() instanceof AbstractTreeNode) {
                AbstractTreeNode abstractTreeNode;
                for (abstractTreeNode = (AbstractTreeNode)pane.getSelectedDescriptor().getElement(); abstractTreeNode != null && !(abstractTreeNode.getParent() instanceof AbstractModuleNode); abstractTreeNode = abstractTreeNode.getParent()) {
                }
                if (abstractTreeNode != null) {
                    Module module = (Module)((AbstractModuleNode)abstractTreeNode.getParent()).getValue();
                }
            }
            AddToFavoritesAction.addPsiElementNode((PsiElement)object, project, result, favoritesConfig);
            ArrayList<AbstractTreeNode> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddToFavoritesAction", "createNodes"));
            }
            return arrayList;
        }
        if (object instanceof VirtualFile[]) {
            for (VirtualFile virtualFile : (VirtualFile[])object) {
                PsiFile element = psiManager.findFile(virtualFile);
                if (element == null) {
                    element = psiManager.findDirectory(virtualFile);
                }
                AddToFavoritesAction.addPsiElementNode((PsiElement)element, project, result, favoritesConfig);
            }
            ArrayList<AbstractTreeNode> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddToFavoritesAction", "createNodes"));
            }
            return arrayList;
        }
        if (object instanceof VirtualFile) {
            VirtualFile virtualFile = (VirtualFile)object;
            PsiFile psiFile = psiManager.findFile(virtualFile);
            AddToFavoritesAction.addPsiElementNode((PsiElement)psiFile, project, result, favoritesConfig);
            ArrayList<AbstractTreeNode> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddToFavoritesAction", "createNodes"));
            }
            return arrayList;
        }
        if (object instanceof ModuleGroup[]) {
            for (ModuleGroup moduleGroup : (ModuleGroup[])object) {
                result.add((AbstractTreeNode)new ProjectViewModuleGroupNode(project, moduleGroup, favoritesConfig));
            }
            ArrayList<AbstractTreeNode> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddToFavoritesAction", "createNodes"));
            }
            return arrayList;
        }
        if (object instanceof Module) {
            object = new Module[]{(Module)object};
        }
        if (object instanceof Module[]) {
            for (Module module : object) {
                result.add((AbstractTreeNode)new ProjectViewModuleNode(project, module, favoritesConfig));
            }
            ArrayList<AbstractTreeNode> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddToFavoritesAction", "createNodes"));
            }
            return arrayList;
        }
        if (object instanceof LibraryGroupElement[]) {
            for (LibraryGroupElement libraryGroupElement : (LibraryGroupElement[])object) {
                result.add((AbstractTreeNode)new LibraryGroupNode(project, libraryGroupElement, favoritesConfig));
            }
            ArrayList<AbstractTreeNode> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddToFavoritesAction", "createNodes"));
            }
            return arrayList;
        }
        if (object instanceof NamedLibraryElement[]) {
            for (NamedLibraryElement namedLibraryElement : (NamedLibraryElement[])object) {
                result.add((AbstractTreeNode)new NamedLibraryElementNode(project, namedLibraryElement, favoritesConfig));
            }
            ArrayList<AbstractTreeNode> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddToFavoritesAction", "createNodes"));
            }
            return arrayList;
        }
        ArrayList<AbstractTreeNode> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddToFavoritesAction", "createNodes"));
        }
        return arrayList;
    }

    private static void addPsiElementNode(PsiElement psiElement, Project project, ArrayList<AbstractTreeNode> result, ViewSettings favoritesConfig) {
        Class<Object> klass = AddToFavoritesAction.getPsiElementNodeClass(psiElement);
        if (klass == null && (psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiFile.class)) != null) {
            klass = PsiFileNode.class;
        }
        PsiElement value = psiElement;
        try {
            if (klass != null && value != null) {
                result.add(ProjectViewNode.createTreeNode(klass, (Project)project, (Object)value, (ViewSettings)favoritesConfig));
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static Class<? extends AbstractTreeNode> getPsiElementNodeClass(PsiElement psiElement) {
        Class klass = null;
        if (psiElement instanceof PsiFile) {
            klass = PsiFileNode.class;
        } else if (psiElement instanceof PsiDirectory) {
            klass = PsiDirectoryNode.class;
        }
        return klass;
    }
}

