/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.ProjectViewNodeWithChildrenList;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsagePresentation;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;

public class UsageProjectTreeNode
extends ProjectViewNodeWithChildrenList<UsageInfo> {
    private final UsagePresentation myUsagePresentation;

    public UsageProjectTreeNode(Project project, UsageInfo usage, ViewSettings viewSettings) {
        super(project, usage, viewSettings);
        UsageInfo2UsageAdapter adapter = new UsageInfo2UsageAdapter(usage);
        this.myUsagePresentation = adapter.getPresentation();
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/favoritesTreeView/UsageProjectTreeNode", "contains"));
        }
        UsageInfo info = (UsageInfo)this.getValue();
        if (info == null) {
            return false;
        }
        PsiElement element = info.getElement();
        return element != null && file.equals(element.getContainingFile().getVirtualFile());
    }

    public String toString() {
        return this.myUsagePresentation.getPlainText();
    }

    protected void update(PresentationData presentation) {
        presentation.setIcon(this.myUsagePresentation.getIcon());
        presentation.setTooltip(this.myUsagePresentation.getTooltipText());
        Object[] text = this.myUsagePresentation.getText();
        UsageProjectTreeNode.updatePresentationWithTextChunks(presentation, (TextChunk[])text);
        presentation.setPresentableText(StringUtil.join((Object[])text, (Function)new Function<TextChunk, String>(){

            public String fun(TextChunk chunk) {
                return chunk.getText();
            }
        }, (String)""));
    }

    public static void updatePresentationWithTextChunks(PresentationData presentation, TextChunk[] text) {
        for (TextChunk chunk : text) {
            presentation.addText(chunk.getText(), chunk.getSimpleAttributesIgnoreBackground());
        }
    }

    public void navigate(boolean requestFocus) {
        UsageViewUtil.navigateTo((UsageInfo)this.getValue(), requestFocus);
    }

    public boolean canNavigate() {
        return this.canNavigateToSource();
    }

    public boolean canNavigateToSource() {
        return ((UsageInfo)this.getValue()).getElement().isValid();
    }
}

