/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.actions.ExportToTextFileToolbarAction;
import com.intellij.ide.actions.NextOccurenceToolbarAction;
import com.intellij.ide.actions.PreviousOccurenceToolbarAction;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.ErrorViewTreeBuilder;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeRenderer;
import com.intellij.ide.errorTreeView.SimpleErrorData;
import com.intellij.ide.errorTreeView.impl.ErrorTreeViewConfiguration;
import com.intellij.ide.errorTreeView.impl.ErrorViewTextExporter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.MessageView;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.MutableErrorTreeView;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewErrorTreeViewPanel
extends JPanel
implements DataProvider,
OccurenceNavigator,
MutableErrorTreeView,
CopyProvider {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.errorTreeView.NewErrorTreeViewPanel");
    private volatile String myProgressText = "";
    private volatile float myFraction = 0.0f;
    private final boolean myCreateExitAction;
    private final ErrorViewStructure myErrorViewStructure;
    private final ErrorViewTreeBuilder myBuilder;
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private volatile boolean myIsDisposed = false;
    private final ErrorTreeViewConfiguration myConfiguration;
    private ActionToolbar myLeftToolbar;
    private ActionToolbar myRightToolbar;
    private final TreeExpander myTreeExpander = new MyTreeExpander();
    private final ExporterToTextFile myExporterToTextFile;
    protected Project myProject;
    private final String myHelpId;
    protected Tree myTree;
    private final JPanel myMessagePanel;
    private ProcessController myProcessController;
    private JLabel myProgressLabel;
    private JPanel myProgressPanel;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final MyOccurrenceNavigatorSupport myOccurrenceNavigatorSupport;

    public NewErrorTreeViewPanel(Project project, String helpId) {
        this(project, helpId, true);
    }

    public NewErrorTreeViewPanel(Project project, String helpId, boolean createExitAction) {
        this(project, helpId, createExitAction, true);
    }

    public NewErrorTreeViewPanel(Project project, String helpId, boolean createExitAction, boolean createToolbar) {
        this(project, helpId, createExitAction, createToolbar, null);
    }

    public NewErrorTreeViewPanel(Project project, String helpId, boolean createExitAction, boolean createToolbar, @Nullable Runnable rerunAction) {
        this.myProject = project;
        this.myHelpId = helpId;
        this.myCreateExitAction = createExitAction;
        this.myConfiguration = ErrorTreeViewConfiguration.getInstance(project);
        this.setLayout(new BorderLayout());
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return NewErrorTreeViewPanel.this.myConfiguration.isAutoscrollToSource();
            }

            protected void setAutoScrollMode(boolean state) {
                NewErrorTreeViewPanel.this.myConfiguration.setAutoscrollToSource(state);
            }
        };
        this.myMessagePanel = new JPanel(new BorderLayout());
        this.myErrorViewStructure = new ErrorViewStructure(project, this.canHideWarnings());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.setUserObject(this.myErrorViewStructure.createDescriptor(this.myErrorViewStructure.getRootElement(), null));
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.myTree = new Tree(treeModel){

            public void setRowHeight(int i) {
                super.setRowHeight(0);
            }
        };
        this.myBuilder = new ErrorViewTreeBuilder((JTree)this.myTree, treeModel, this.myErrorViewStructure);
        this.myExporterToTextFile = new ErrorViewTextExporter(this.myErrorViewStructure);
        this.myOccurrenceNavigatorSupport = new MyOccurrenceNavigatorSupport(this.myTree);
        this.myAutoScrollToSourceHandler.install((JTree)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setLargeModel(true);
        JScrollPane scrollPane = NewErrorTreeRenderer.install((JTree)this.myTree);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)1));
        this.myMessagePanel.add((Component)scrollPane, "Center");
        if (createToolbar) {
            this.add((Component)this.createToolbarPanel(rerunAction), "West");
        }
        this.add((Component)this.myMessagePanel, "Center");
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    NewErrorTreeViewPanel.this.navigateToSource(false);
                }
            }
        });
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                NewErrorTreeViewPanel.this.popupInvoked(comp, x, y);
            }
        });
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
    }

    public void dispose() {
        this.myIsDisposed = true;
        this.myErrorViewStructure.clear();
        this.myUpdateAlarm.cancelAllRequests();
        Disposer.dispose((Disposable)this.myUpdateAlarm);
        Disposer.dispose((Disposable)this.myBuilder);
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel", "performCopy"));
        }
        List<ErrorTreeNodeDescriptor> descriptors = this.getSelectedNodeDescriptors();
        if (!descriptors.isEmpty()) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.join(descriptors, (Function)new Function<ErrorTreeNodeDescriptor, String>(){

                public String fun(ErrorTreeNodeDescriptor descriptor) {
                    ErrorTreeElement element = descriptor.getElement();
                    return NewErrorTreeRenderer.calcPrefix(element) + StringUtil.join((String[])element.getText(), (String)"\n");
                }
            }, (String)"\n")));
        }
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel", "isCopyEnabled"));
        }
        return !this.getSelectedNodeDescriptors().isEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel", "isCopyVisible"));
        }
        return true;
    }

    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myTree.getEmptyText();
        if (statusText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel", "getEmptyText"));
        }
        return statusText;
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            NavigatableMessageElement selectedMessageElement = this.getSelectedMessageElement();
            return selectedMessageElement != null ? selectedMessageElement.getNavigatable() : null;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            return this.myTreeExpander;
        }
        if (PlatformDataKeys.EXPORTER_TO_TEXT_FILE.is(dataId)) {
            return this.myExporterToTextFile;
        }
        if (CURRENT_EXCEPTION_DATA_KEY.is(dataId)) {
            NavigatableMessageElement selectedMessageElement = this.getSelectedMessageElement();
            return selectedMessageElement != null ? selectedMessageElement.getData() : null;
        }
        return null;
    }

    public void selectFirstMessage() {
        ErrorTreeElement firstError = this.myErrorViewStructure.getFirstMessage(ErrorTreeElementKind.ERROR);
        if (firstError != null) {
            this.selectElement(firstError, new Runnable(){

                @Override
                public void run() {
                    if (NewErrorTreeViewPanel.this.shouldShowFirstErrorInEditor()) {
                        NewErrorTreeViewPanel.this.navigateToSource(false);
                    }
                }
            });
        } else {
            ErrorTreeElement firstWarning = this.myErrorViewStructure.getFirstMessage(ErrorTreeElementKind.WARNING);
            if (firstWarning == null) {
                firstWarning = this.myErrorViewStructure.getFirstMessage(ErrorTreeElementKind.NOTE);
            }
            if (firstWarning != null) {
                this.selectElement(firstWarning, null);
            } else {
                TreeUtil.selectFirstNode((JTree)this.myTree);
            }
        }
    }

    private void selectElement(ErrorTreeElement element, Runnable onDone) {
        this.myBuilder.select(element, onDone);
    }

    protected boolean shouldShowFirstErrorInEditor() {
        return false;
    }

    public void updateTree() {
        if (!this.myIsDisposed) {
            this.myBuilder.updateTree();
        }
    }

    public void addMessage(int type, @NotNull String[] text, @Nullable VirtualFile file, int line, int column, @Nullable Object data) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel", "addMessage"));
        }
        this.addMessage(type, text, null, file, line, column, data);
    }

    public void addMessage(int type, @NotNull String[] text, @Nullable VirtualFile underFileGroup, @Nullable VirtualFile file, int line, int column, @Nullable Object data) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel", "addMessage"));
        }
        if (this.myIsDisposed) {
            return;
        }
        this.myErrorViewStructure.addMessage(ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)type), text, underFileGroup, file, line, column, data);
        this.myBuilder.updateTree();
    }

    public void addMessage(int type, @NotNull String[] text, @Nullable String groupName, @NotNull Navigatable navigatable, @Nullable String exportTextPrefix, @Nullable String rendererTextPrefix, @Nullable Object data) {
        VirtualFile file;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel", "addMessage"));
        }
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel", "addMessage"));
        }
        if (this.myIsDisposed) {
            return;
        }
        VirtualFile virtualFile = file = data instanceof VirtualFile ? (VirtualFile)data : null;
        if (file == null && navigatable instanceof OpenFileDescriptor) {
            file = ((OpenFileDescriptor)navigatable).getFile();
        }
        String exportPrefix = exportTextPrefix == null ? "" : exportTextPrefix;
        String renderPrefix = rendererTextPrefix == null ? "" : rendererTextPrefix;
        ErrorTreeElementKind kind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)type);
        this.myErrorViewStructure.addNavigatableMessage(groupName, navigatable, kind, text, data, exportPrefix, renderPrefix, file);
        this.myBuilder.updateTree();
    }

    public ErrorViewStructure getErrorViewStructure() {
        return this.myErrorViewStructure;
    }

    public static String createExportPrefix(int line) {
        return line < 0 ? "" : IdeBundle.message((String)"errortree.prefix.line", (Object[])new Object[]{line});
    }

    public static String createRendererPrefix(int line, int column) {
        if (line < 0) {
            return "";
        }
        if (column < 0) {
            return "(" + line + ")";
        }
        return "(" + line + ", " + column + ")";
    }

    @NotNull
    public JComponent getComponent() {
        NewErrorTreeViewPanel newErrorTreeViewPanel = this;
        if (newErrorTreeViewPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel", "getComponent"));
        }
        return newErrorTreeViewPanel;
    }

    @Nullable
    private NavigatableMessageElement getSelectedMessageElement() {
        ErrorTreeElement selectedElement = this.getSelectedErrorTreeElement();
        return selectedElement instanceof NavigatableMessageElement ? (NavigatableMessageElement)selectedElement : null;
    }

    @Nullable
    public ErrorTreeElement getSelectedErrorTreeElement() {
        ErrorTreeNodeDescriptor treeNodeDescriptor = this.getSelectedNodeDescriptor();
        return treeNodeDescriptor == null ? null : treeNodeDescriptor.getElement();
    }

    @Nullable
    public ErrorTreeNodeDescriptor getSelectedNodeDescriptor() {
        List<ErrorTreeNodeDescriptor> descriptors = this.getSelectedNodeDescriptors();
        return descriptors.size() == 1 ? descriptors.get(0) : null;
    }

    private List<ErrorTreeNodeDescriptor> getSelectedNodeDescriptors() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return Collections.emptyList();
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (TreePath path : paths) {
            DefaultMutableTreeNode lastPathNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = lastPathNode.getUserObject();
            if (!(userObject instanceof ErrorTreeNodeDescriptor)) continue;
            result.add((ErrorTreeNodeDescriptor)((Object)userObject));
        }
        return result;
    }

    private void navigateToSource(boolean focusEditor) {
        NavigatableMessageElement element = this.getSelectedMessageElement();
        if (element == null) {
            return;
        }
        Navigatable navigatable = element.getNavigatable();
        if (navigatable.canNavigate()) {
            navigatable.navigate(focusEditor);
        }
    }

    public static String getQualifiedName(VirtualFile file) {
        return file.getPresentableUrl();
    }

    private void popupInvoked(Component component, int x, int y) {
        TreePath path = this.myTree.getLeadSelectionPath();
        if (path == null) {
            return;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        if (this.getData(CommonDataKeys.NAVIGATABLE.getName()) != null) {
            group.add(ActionManager.getInstance().getAction("EditSource"));
        }
        group.add(ActionManager.getInstance().getAction("$Copy"));
        this.addExtraPopupMenuActions(group);
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("CompilerMessagesPopup", (ActionGroup)group);
        menu.getComponent().show(component, x, y);
    }

    protected void addExtraPopupMenuActions(DefaultActionGroup group) {
    }

    public void setProcessController(ProcessController controller) {
        this.myProcessController = controller;
    }

    public void stopProcess() {
        this.myProcessController.stopProcess();
    }

    public boolean canControlProcess() {
        return this.myProcessController != null;
    }

    public boolean isProcessStopped() {
        return this.myProcessController.isProcessStopped();
    }

    public void close() {
        MessageView messageView = MessageView.SERVICE.getInstance(this.myProject);
        Content content = messageView.getContentManager().getContent((JComponent)this);
        if (content != null) {
            messageView.getContentManager().removeContent(content, true);
        }
    }

    public void setProgress(String s, float fraction) {
        this.initProgressPanel();
        this.myProgressText = s;
        this.myFraction = fraction;
        this.updateProgress();
    }

    public void setProgressText(String s) {
        this.initProgressPanel();
        this.myProgressText = s;
        this.updateProgress();
    }

    public void setFraction(float fraction) {
        this.initProgressPanel();
        this.myFraction = fraction;
        this.updateProgress();
    }

    public void clearProgressData() {
        if (this.myProgressPanel != null) {
            this.myProgressText = " ";
            this.myFraction = 0.0f;
            this.updateProgress();
        }
    }

    private void updateProgress() {
        if (this.myIsDisposed) {
            return;
        }
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                float fraction = NewErrorTreeViewPanel.this.myFraction;
                String text = NewErrorTreeViewPanel.this.myProgressText;
                if (fraction > 0.0f) {
                    NewErrorTreeViewPanel.this.myProgressLabel.setText((int)((double)(fraction * 100.0f) + 0.5) + "%  " + text);
                } else {
                    NewErrorTreeViewPanel.this.myProgressLabel.setText(text);
                }
            }
        }, 50, ModalityState.NON_MODAL);
    }

    private void initProgressPanel() {
        if (this.myProgressPanel == null) {
            this.myProgressPanel = new JPanel(new GridLayout(1, 2));
            this.myProgressLabel = new JLabel();
            this.myProgressPanel.add(this.myProgressLabel);
            this.myMessagePanel.add((Component)this.myProgressPanel, "South");
            this.myMessagePanel.validate();
        }
    }

    public void collapseAll() {
        TreeUtil.collapseAll((JTree)this.myTree, (int)2);
    }

    public void expandAll() {
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        TreePath leadSelectionPath = this.myTree.getLeadSelectionPath();
        for (int row = 0; row < this.myTree.getRowCount(); ++row) {
            this.myTree.expandRow(row);
        }
        if (selectionPaths != null) {
            this.myTree.setSelectionPaths(selectionPaths);
        }
        if (leadSelectionPath != null) {
            this.myTree.scrollPathToVisible(leadSelectionPath);
        }
    }

    private JPanel createToolbarPanel(@Nullable Runnable rerunAction) {
        CloseTabToolbarAction closeMessageViewAction = new CloseTabToolbarAction(){

            public void actionPerformed(AnActionEvent e) {
                NewErrorTreeViewPanel.this.close();
            }
        };
        DefaultActionGroup leftUpdateableActionGroup = new DefaultActionGroup();
        if (rerunAction != null) {
            leftUpdateableActionGroup.add((AnAction)new RerunAction(rerunAction, (AnAction)closeMessageViewAction));
        }
        leftUpdateableActionGroup.add((AnAction)new StopAction());
        if (this.myCreateExitAction) {
            leftUpdateableActionGroup.add((AnAction)closeMessageViewAction);
        }
        leftUpdateableActionGroup.add((AnAction)new PreviousOccurenceToolbarAction(this));
        leftUpdateableActionGroup.add((AnAction)new NextOccurenceToolbarAction(this));
        leftUpdateableActionGroup.add((AnAction)new ExportToTextFileToolbarAction(this.myExporterToTextFile));
        leftUpdateableActionGroup.add((AnAction)new ContextHelpAction(this.myHelpId));
        DefaultActionGroup rightUpdateableActionGroup = new DefaultActionGroup();
        this.fillRightToolbarGroup(rightUpdateableActionGroup);
        JPanel toolbarPanel = new JPanel(new GridLayout(1, 2));
        ActionManager actionManager = ActionManager.getInstance();
        this.myLeftToolbar = actionManager.createActionToolbar("CompilerMessagesToolbar", (ActionGroup)leftUpdateableActionGroup, false);
        toolbarPanel.add(this.myLeftToolbar.getComponent());
        this.myRightToolbar = actionManager.createActionToolbar("CompilerMessagesToolbar", (ActionGroup)rightUpdateableActionGroup, false);
        toolbarPanel.add(this.myRightToolbar.getComponent());
        return toolbarPanel;
    }

    protected void fillRightToolbarGroup(DefaultActionGroup group) {
        group.add(CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)this));
        group.add(CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)this));
        if (this.canHideWarnings()) {
            group.add((AnAction)new HideWarningsAction());
        }
        group.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurrenceNavigatorSupport.goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurrenceNavigatorSupport.goPreviousOccurence();
    }

    public boolean hasNextOccurence() {
        return this.myOccurrenceNavigatorSupport.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurrenceNavigatorSupport.hasPreviousOccurence();
    }

    public String getNextOccurenceActionName() {
        return this.myOccurrenceNavigatorSupport.getNextOccurenceActionName();
    }

    public String getPreviousOccurenceActionName() {
        return this.myOccurrenceNavigatorSupport.getPreviousOccurenceActionName();
    }

    protected boolean canHideWarnings() {
        return true;
    }

    public boolean isHideWarnings() {
        return this.myConfiguration.isHideWarnings();
    }

    public List<Object> getGroupChildrenData(String groupName) {
        return this.myErrorViewStructure.getGroupChildrenData(groupName);
    }

    public void removeGroup(String name) {
        this.myErrorViewStructure.removeGroup(name);
    }

    public void addFixedHotfixGroup(String text, List<SimpleErrorData> children) {
        this.myErrorViewStructure.addFixedHotfixGroup(text, children);
    }

    public void addHotfixGroup(HotfixData hotfixData, List<SimpleErrorData> children) {
        this.myErrorViewStructure.addHotfixGroup(hotfixData, children, this);
    }

    public void reload() {
        this.myBuilder.updateTree();
    }

    private static class MyOccurrenceNavigatorSupport
    extends OccurenceNavigatorSupport {
        public MyOccurrenceNavigatorSupport(Tree tree) {
            super((JTree)tree);
        }

        protected Navigatable createDescriptorForNode(DefaultMutableTreeNode node) {
            Object userObject = node.getUserObject();
            if (!(userObject instanceof ErrorTreeNodeDescriptor)) {
                return null;
            }
            ErrorTreeNodeDescriptor descriptor = (ErrorTreeNodeDescriptor)((Object)userObject);
            ErrorTreeElement element = descriptor.getElement();
            if (element instanceof NavigatableMessageElement) {
                return ((NavigatableMessageElement)element).getNavigatable();
            }
            return null;
        }

        public String getNextOccurenceActionName() {
            return IdeBundle.message((String)"action.next.message", (Object[])new Object[0]);
        }

        public String getPreviousOccurenceActionName() {
            return IdeBundle.message((String)"action.previous.message", (Object[])new Object[0]);
        }
    }

    private class MyTreeExpander
    implements TreeExpander {
        private MyTreeExpander() {
        }

        public void expandAll() {
            NewErrorTreeViewPanel.this.expandAll();
        }

        public boolean canExpand() {
            return true;
        }

        public void collapseAll() {
            NewErrorTreeViewPanel.this.collapseAll();
        }

        public boolean canCollapse() {
            return true;
        }
    }

    private class HideWarningsAction
    extends ToggleAction
    implements DumbAware {
        public HideWarningsAction() {
            super(IdeBundle.message((String)"action.hide.warnings", (Object[])new Object[0]), null, AllIcons.General.HideWarnings);
        }

        public boolean isSelected(AnActionEvent event) {
            return NewErrorTreeViewPanel.this.isHideWarnings();
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            if (NewErrorTreeViewPanel.this.isHideWarnings() != flag) {
                NewErrorTreeViewPanel.this.myConfiguration.setHideWarnings(flag);
                NewErrorTreeViewPanel.this.myBuilder.updateTree();
            }
        }
    }

    private class StopAction
    extends DumbAwareAction {
        public StopAction() {
            super(IdeBundle.message((String)"action.stop", (Object[])new Object[0]), null, AllIcons.Actions.Suspend);
        }

        public void actionPerformed(AnActionEvent e) {
            if (NewErrorTreeViewPanel.this.canControlProcess()) {
                NewErrorTreeViewPanel.this.stopProcess();
            }
            NewErrorTreeViewPanel.this.myLeftToolbar.updateActionsImmediately();
            NewErrorTreeViewPanel.this.myRightToolbar.updateActionsImmediately();
        }

        public void update(AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(NewErrorTreeViewPanel.this.canControlProcess() && !NewErrorTreeViewPanel.this.isProcessStopped());
            presentation.setVisible(NewErrorTreeViewPanel.this.canControlProcess());
        }
    }

    private class RerunAction
    extends DumbAwareAction {
        private final Runnable myRerunAction;
        private final AnAction myCloseAction;

        public RerunAction(@NotNull Runnable rerunAction, AnAction closeAction) {
            if (rerunAction == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel$RerunAction", "<init>"));
            }
            if (closeAction == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel$RerunAction", "<init>"));
            }
            super(IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), null, AllIcons.Actions.Rerun);
            this.myRerunAction = rerunAction;
            this.myCloseAction = closeAction;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myCloseAction.actionPerformed(e);
            this.myRerunAction.run();
        }

        public void update(AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(NewErrorTreeViewPanel.this.canControlProcess() && NewErrorTreeViewPanel.this.isProcessStopped());
        }
    }

    public static interface ProcessController {
        public void stopProcess();

        public boolean isProcessStopped();
    }
}

