/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigatableMessageElement
extends ErrorTreeElement {
    private final GroupingElement myParent;
    private final String[] myMessage;
    private final Navigatable myNavigatable;
    private final String myExportText;
    private final String myRendererTextPrefix;

    public NavigatableMessageElement(@NotNull ErrorTreeElementKind kind, @Nullable GroupingElement parent, String[] message, Navigatable navigatable, String exportText, String rendererTextPrefix) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/errorTreeView/NavigatableMessageElement", "<init>"));
        }
        super(kind);
        this.myParent = parent;
        this.myMessage = message;
        this.myNavigatable = navigatable;
        this.myExportText = exportText;
        this.myRendererTextPrefix = rendererTextPrefix;
    }

    public Navigatable getNavigatable() {
        return this.myNavigatable;
    }

    @Override
    public String[] getText() {
        return this.myMessage;
    }

    @Override
    public Object getData() {
        return this.myParent.getData();
    }

    @Nullable
    public GroupingElement getParent() {
        return this.myParent;
    }

    @Override
    public String getExportTextPrefix() {
        return this.getKind().getPresentableText() + this.myExportText;
    }

    public String getRendererTextPrefix() {
        return this.myRendererTextPrefix;
    }
}

