/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd.aware;

import com.intellij.ide.dnd.DnDAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class DnDAwareTree
extends Tree
implements DnDAware {
    public DnDAwareTree() {
    }

    public DnDAwareTree(TreeModel treemodel) {
        super(treemodel);
    }

    public DnDAwareTree(TreeNode root) {
        super(root);
    }

    public void processMouseEvent(MouseEvent e) {
        if (this.getToolTipText() == null && e.getID() == 504) {
            return;
        }
        super.processMouseEvent(e);
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        if (SystemInfo.isMac && SwingUtilities.isRightMouseButton(e) && e.getID() == 506) {
            return;
        }
        super.processMouseMotionEvent(e);
    }

    public final boolean isOverSelection(Point point) {
        TreePath path;
        TreeUI ui = this.getUI();
        TreePath treePath = path = ui instanceof WideSelectionTreeUI && ((WideSelectionTreeUI)ui).isWideSelection() ? this.getClosestPathForLocation(point.x, point.y) : this.getPathForLocation(point.x, point.y);
        if (path == null) {
            return false;
        }
        return this.isPathSelected(path);
    }

    public void dropSelectionButUnderPoint(Point point) {
        TreeUtil.dropSelectionButUnderPoint((JTree)((Object)this), (Point)point);
    }

    @NotNull
    public final JComponent getComponent() {
        DnDAwareTree dnDAwareTree = this;
        if (dnDAwareTree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/dnd/aware/DnDAwareTree", "getComponent"));
        }
        return dnDAwareTree;
    }

    public static Pair<Image, Point> getDragImage(Tree dndAwareTree, @NotNull TreePath path, Point dragOrigin) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/dnd/aware/DnDAwareTree", "getDragImage"));
        }
        int row = dndAwareTree.getRowForPath(path);
        Component comp = dndAwareTree.getCellRenderer().getTreeCellRendererComponent((JTree)dndAwareTree, path.getLastPathComponent(), false, true, true, row, false);
        return DnDAwareTree.createDragImage(dndAwareTree, comp, dragOrigin, true);
    }

    public static Pair<Image, Point> getDragImage(Tree dndAwareTree, String text, Point dragOrigin) {
        return DnDAwareTree.createDragImage(dndAwareTree, new JLabel(text), dragOrigin, false);
    }

    private static Pair<Image, Point> createDragImage(Tree tree, Component c, Point dragOrigin, boolean adjustToPathUnderDragOrigin) {
        TreePath path;
        if (c instanceof JComponent) {
            ((JComponent)c).setOpaque(true);
        }
        c.setForeground(tree.getForeground());
        c.setBackground(tree.getBackground());
        c.setFont(tree.getFont());
        c.setSize(c.getPreferredSize());
        BufferedImage image = UIUtil.createImage((int)c.getWidth(), (int)c.getHeight(), (int)2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
        c.paint(g2);
        g2.dispose();
        Point point = new Point(-image.getWidth(null) / 2, -image.getHeight(null) / 2);
        if (adjustToPathUnderDragOrigin && (path = tree.getPathForLocation(dragOrigin.x, dragOrigin.y)) != null) {
            Rectangle bounds = tree.getPathBounds(path);
            point = new Point(bounds.x - dragOrigin.x, bounds.y - dragOrigin.y);
        }
        return new Pair((Object)image, (Object)point);
    }
}

