/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.ide.browsers.BrowserSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import java.io.InputStream;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

final class BrowserLauncherImpl
extends BrowserLauncherAppless {
    BrowserLauncherImpl() {
    }

    protected void doShowError(final String error, final WebBrowser browser, final Project project, final String title) {
        AppUIUtil.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                if (Messages.showYesNoDialog((Project)project, (String)StringUtil.notNullize((String)error, (String)"Unknown error"), (String)(title == null ? IdeBundle.message((String)"browser.error", (Object[])new Object[0]) : title), (String)Messages.OK_BUTTON, (String)IdeBundle.message((String)"button.fix", (Object[])new Object[0]), null) == 1) {
                    final BrowserSettings browserSettings = new BrowserSettings();
                    ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)browserSettings, browser == null ? null : new Runnable(){

                        @Override
                        public void run() {
                            browserSettings.selectBrowser(browser);
                        }
                    });
                }
            }
        });
    }

    protected void checkCreatedProcess(final WebBrowser browser, final Project project, GeneralCommandLine commandLine, final Process process) {
        if (BrowserLauncherImpl.isOpenCommandUsed((GeneralCommandLine)commandLine)) {
            final Future future = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (process.waitFor() == 1) {
                            BrowserLauncherImpl.this.doShowError(ExecUtil.readFirstLine((InputStream)process.getErrorStream(), null), browser, project, null);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            JobScheduler.getScheduler().schedule(new Runnable(){

                @Override
                public void run() {
                    future.cancel(true);
                }
            }, 30L, TimeUnit.MILLISECONDS);
        }
    }
}

