/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.containers.HashMap;
import java.awt.Font;
import java.awt.Window;
import java.util.Enumeration;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class TogglePresentationModeAction
extends AnAction
implements DumbAware {
    private static final HashMap<Object, Font> oldFonts = new HashMap();

    public void update(AnActionEvent e) {
        boolean selected = UISettings.getInstance().PRESENTATION_MODE;
        e.getPresentation().setText(selected ? "Exit Presentation Mode" : "Enter Presentation Mode");
    }

    public void actionPerformed(AnActionEvent e) {
        Window window;
        UISettings settings = UISettings.getInstance();
        Project project = e.getProject();
        boolean bl = settings.PRESENTATION_MODE = !settings.PRESENTATION_MODE;
        if (project != null) {
            TogglePresentationModeAction.hideToolWindows(project);
        }
        settings.fireUISettingsChanged();
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration keys = defaults.keys();
        if (settings.PRESENTATION_MODE) {
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (!(key instanceof String) || !((String)key).endsWith(".font")) continue;
                Font font = defaults.getFont(key);
                oldFonts.put(key, (Object)font);
            }
            for (Object key : oldFonts.keySet()) {
                Font font = (Font)oldFonts.get(key);
                defaults.put(key, new FontUIResource(font.getName(), font.getStyle(), Math.min(20, settings.PRESENTATION_MODE_FONT_SIZE)));
            }
        } else {
            for (Object key : oldFonts.keySet()) {
                defaults.put(key, oldFonts.get(key));
            }
            oldFonts.clear();
        }
        if (project != null && (window = IdeFrameImpl.getActiveFrame()) instanceof IdeFrameImpl) {
            IdeFrameImpl frame = (IdeFrameImpl)window;
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
            if (settings.PRESENTATION_MODE) {
                propertiesComponent.setValue("full.screen.before.presentation.mode", String.valueOf(frame.isInFullScreen()));
                frame.toggleFullScreen(true);
            } else if (frame.isInFullScreen()) {
                String value = propertiesComponent.getValue("full.screen.before.presentation.mode");
                frame.toggleFullScreen("true".equalsIgnoreCase(value));
            }
        }
        int fontSize = settings.PRESENTATION_MODE ? settings.PRESENTATION_MODE_FONT_SIZE : EditorColorsManager.getInstance().getGlobalScheme().getEditorFontSize();
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            if (!(editor instanceof EditorEx)) continue;
            ((EditorEx)editor).setFontSize(fontSize);
        }
        UISettings.getInstance().fireUISettingsChanged();
        LafManager.getInstance().updateUI();
        EditorUtil.reinitSettings();
    }

    private static void hideToolWindows(Project project) {
        DesktopLayout restoreLayout;
        ToolWindowManagerEx mgr = ToolWindowManagerEx.getInstanceEx(project);
        DesktopLayout layout = new DesktopLayout();
        layout.copyFrom(mgr.getLayout());
        mgr.clearSideStack();
        String[] ids = mgr.getToolWindowIds();
        boolean hasVisible = false;
        for (String id : ids) {
            ToolWindow toolWindow = mgr.getToolWindow(id);
            if (!toolWindow.isVisible()) continue;
            toolWindow.hide(null);
            hasVisible = true;
        }
        if (hasVisible && UISettings.getInstance().PRESENTATION_MODE) {
            mgr.setLayoutToRestoreLater(layout);
            mgr.activateEditorComponent();
        } else if (!UISettings.getInstance().PRESENTATION_MODE && !hasVisible && (restoreLayout = mgr.getLayoutToRestoreLater()) != null) {
            mgr.setLayout(restoreLayout);
        }
    }
}

