/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Trinity;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public class TemplateKindCombo
extends ComboboxWithBrowseButton {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.TemplateKindCombo");

    public TemplateKindCombo() {
        this.getComboBox().setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean cellHasFocus) {
                if (value instanceof Trinity) {
                    this.setText((String)((Trinity)value).first);
                    this.setIcon((Icon)((Trinity)value).second);
                }
            }
        });
        new ComboboxSpeedSearch(this.getComboBox()){

            @Override
            protected String getElementText(Object element) {
                if (element instanceof Trinity) {
                    return (String)((Trinity)element).first;
                }
                return null;
            }
        };
        this.setButtonListener(null);
    }

    public void addItem(String presentableName, Icon icon, String templateName) {
        this.getComboBox().addItem(new Trinity((Object)presentableName, (Object)icon, (Object)templateName));
    }

    public String getSelectedName() {
        Trinity trinity = (Trinity)this.getComboBox().getSelectedItem();
        if (trinity == null) {
            return null;
        }
        return (String)trinity.third;
    }

    public void setSelectedName(@Nullable String name) {
        if (name == null) {
            return;
        }
        ComboBoxModel model = this.getComboBox().getModel();
        int n = model.getSize();
        for (int i = 0; i < n; ++i) {
            Trinity trinity = (Trinity)model.getElementAt(i);
            if (!name.equals(trinity.third)) continue;
            this.getComboBox().setSelectedItem(trinity);
            return;
        }
    }

    public void registerUpDownHint(JComponent component) {
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                if (e.getInputEvent() instanceof KeyEvent) {
                    int code = ((KeyEvent)e.getInputEvent()).getKeyCode();
                    TemplateKindCombo.this.scrollBy(code == 40 ? 1 : (code == 38 ? -1 : 0));
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Integer[]{38, 40}), component);
    }

    private void scrollBy(int delta) {
        if (delta == 0) {
            return;
        }
        int size = this.getComboBox().getModel().getSize();
        int next = this.getComboBox().getSelectedIndex() + delta;
        if (next < 0 || next >= size) {
            if (!UISettings.getInstance().CYCLE_SCROLLING) {
                return;
            }
            next = (next + size) % size;
        }
        this.getComboBox().setSelectedIndex(next);
    }

    public void setButtonListener(@Nullable ActionListener listener) {
        this.getButton().setVisible(listener != null);
        if (listener != null) {
            this.addActionListener(listener);
        }
    }

    public void clear() {
        this.getComboBox().removeAllItems();
    }
}

