/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import org.jetbrains.annotations.Nullable;

public class SynchronizeCurrentFileAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        VirtualFile[] files = SynchronizeCurrentFileAction.getFiles(e);
        if (SynchronizeCurrentFileAction.getEventProject((AnActionEvent)e) == null || files == null || files.length == 0) {
            e.getPresentation().setEnabled(false);
            return;
        }
        String message = SynchronizeCurrentFileAction.getMessage(files);
        e.getPresentation().setEnabled(true);
        e.getPresentation().setText(message.replace("_", "__").replace("&", "&&"));
    }

    private static String getMessage(VirtualFile[] files) {
        return files.length == 1 ? IdeBundle.message((String)"action.synchronize.file", (Object[])new Object[]{files[0].getName()}) : IdeBundle.message((String)"action.synchronize.selected.files", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        final Project project = SynchronizeCurrentFileAction.getEventProject((AnActionEvent)e);
        final VirtualFile[] files = SynchronizeCurrentFileAction.getFiles(e);
        if (project == null || files == null || files.length == 0) {
            return;
        }
        AccessToken token = WriteAction.start(((Object)((Object)this)).getClass());
        try {
            for (VirtualFile file : files) {
                VirtualFileSystem fs = file.getFileSystem();
                if (!(fs instanceof LocalFileSystem) || !(file instanceof NewVirtualFile)) continue;
                ((NewVirtualFile)file).markDirtyRecursively();
            }
        }
        finally {
            token.finish();
        }
        Runnable postRefreshAction = new Runnable(){

            @Override
            public void run() {
                VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
                for (VirtualFile f : files) {
                    if (f.isDirectory()) {
                        dirtyScopeManager.dirDirtyRecursively(f);
                        continue;
                    }
                    dirtyScopeManager.fileDirty(f);
                }
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
                if (statusBar != null) {
                    String message = IdeBundle.message((String)"action.sync.completed.successfully", (Object[])new Object[]{SynchronizeCurrentFileAction.getMessage(files)});
                    statusBar.setInfo(message);
                }
            }
        };
        RefreshQueue.getInstance().refresh(true, true, postRefreshAction, files);
    }

    @Nullable
    private static VirtualFile[] getFiles(AnActionEvent e) {
        return (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
    }
}

