/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.IdeConfigurablesGroup;
import com.intellij.openapi.options.ex.ProjectConfigurablesGroup;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.options.newEditor.OptionsEditor;
import com.intellij.openapi.options.newEditor.OptionsEditorDialog;
import com.intellij.openapi.options.newEditor.PreferencesDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSettingsUtilImpl
extends ShowSettingsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.ShowSettingsUtilImpl");
    private AtomicBoolean myShown = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showSettingsDialog(@NotNull Project project, @NotNull ConfigurableGroup[] group) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        try {
            this.myShown.set(true);
            ShowSettingsUtilImpl._showSettingsDialog(project, group, null);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myShown.set(false);
        }
    }

    private static void _showSettingsDialog(@NotNull Project project, @NotNull ConfigurableGroup[] group, @Nullable Configurable toSelect) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/actions/ShowSettingsUtilImpl", "_showSettingsDialog"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/actions/ShowSettingsUtilImpl", "_showSettingsDialog"));
        }
        group = ShowSettingsUtilImpl.filterEmptyGroups(group);
        if (Registry.is((String)"ide.perProjectModality")) {
            new OptionsEditorDialog(project, group, toSelect, true).show();
        } else if (Registry.is((String)"ide.new.preferences")) {
            new PreferencesDialog(project, group).show();
        } else {
            new OptionsEditorDialog(project, group, toSelect).show();
        }
    }

    public void showSettingsDialog(@Nullable Project project, Class configurableClass) {
        assert (Configurable.class.isAssignableFrom(configurableClass)) : "Not a configurable: " + configurableClass.getName();
        IdeConfigurablesGroup commonGroup = new IdeConfigurablesGroup();
        ProjectConfigurablesGroup projectGroup = project == null ? null : new ProjectConfigurablesGroup(project);
        ConfigurableGroup[] groups = projectGroup == null ? new ConfigurableGroup[]{commonGroup} : new ConfigurableGroup[]{projectGroup, commonGroup};
        Configurable config = ShowSettingsUtilImpl.findByClass(commonGroup.getConfigurables(), configurableClass);
        if (config == null && projectGroup != null) {
            config = ShowSettingsUtilImpl.findByClass(projectGroup.getConfigurables(), configurableClass);
        }
        assert (config != null) : "Cannot find configurable: " + configurableClass.getName();
        Project nnProject = project != null ? project : ProjectManager.getInstance().getDefaultProject();
        ShowSettingsUtilImpl._showSettingsDialog(nnProject, groups, config);
    }

    @Nullable
    private static Configurable findByClass(Configurable[] configurables, Class configurableClass) {
        for (Configurable configurable : configurables) {
            if (!configurableClass.isInstance(configurable)) continue;
            return configurable;
        }
        return null;
    }

    public void showSettingsDialog(@Nullable Project project, @NotNull String nameToSelect) {
        if (nameToSelect == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        ConfigurableGroup[] group = project == null ? new ConfigurableGroup[]{new IdeConfigurablesGroup()} : new ConfigurableGroup[]{new ProjectConfigurablesGroup(project), new IdeConfigurablesGroup()};
        Project actualProject = project != null ? project : ProjectManager.getInstance().getDefaultProject();
        group = ShowSettingsUtilImpl.filterEmptyGroups(group);
        OptionsEditorDialog dialog = Registry.is((String)"ide.perProjectModality") ? new OptionsEditorDialog(actualProject, group, nameToSelect, true) : new OptionsEditorDialog(actualProject, group, nameToSelect);
        dialog.show();
    }

    public static void showSettingsDialog(@Nullable Project project, String id2Select, final String filter) {
        ConfigurableGroup[] group = project == null ? new ConfigurableGroup[]{new IdeConfigurablesGroup()} : new ConfigurableGroup[]{new ProjectConfigurablesGroup(project), new IdeConfigurablesGroup()};
        Project actualProject = project != null ? project : ProjectManager.getInstance().getDefaultProject();
        group = ShowSettingsUtilImpl.filterEmptyGroups(group);
        final Configurable configurable2Select = ShowSettingsUtilImpl.findConfigurable2Select(id2Select, group);
        final OptionsEditorDialog dialog = Registry.is((String)"ide.perProjectModality") ? new OptionsEditorDialog(actualProject, group, configurable2Select, true) : new OptionsEditorDialog(actualProject, group, configurable2Select);
        new UiNotifyConnector.Once((Component)dialog.getContentPane(), (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                OptionsEditor editor = (OptionsEditor)dialog.getData(OptionsEditor.KEY.getName());
                LOG.assertTrue(editor != null);
                editor.select(configurable2Select, filter);
            }
        });
        dialog.show();
    }

    @Nullable
    private static Configurable findConfigurable2Select(String id2Select, ConfigurableGroup[] group) {
        for (ConfigurableGroup configurableGroup : group) {
            for (Configurable configurable : configurableGroup.getConfigurables()) {
                Configurable conf = ShowSettingsUtilImpl.containsId(id2Select, configurable);
                if (conf == null) continue;
                return conf;
            }
        }
        return null;
    }

    @Nullable
    private static Configurable containsId(String id2Select, Configurable configurable) {
        if (configurable instanceof SearchableConfigurable && id2Select.equals(((SearchableConfigurable)configurable).getId())) {
            return configurable;
        }
        if (configurable instanceof SearchableConfigurable.Parent) {
            for (Configurable subConfigurable : ((SearchableConfigurable.Parent)configurable).getConfigurables()) {
                Configurable config = ShowSettingsUtilImpl.containsId(id2Select, subConfigurable);
                if (config == null) continue;
                return config;
            }
        }
        return null;
    }

    public void showSettingsDialog(@NotNull Project project, Configurable toSelect) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        ShowSettingsUtilImpl._showSettingsDialog(project, new ConfigurableGroup[]{new ProjectConfigurablesGroup(project), new IdeConfigurablesGroup()}, toSelect);
    }

    @NotNull
    private static ConfigurableGroup[] filterEmptyGroups(@NotNull ConfigurableGroup[] group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/actions/ShowSettingsUtilImpl", "filterEmptyGroups"));
        }
        ArrayList<ConfigurableGroup> groups = new ArrayList<ConfigurableGroup>();
        for (ConfigurableGroup g : group) {
            if (g.getConfigurables().length <= 0) continue;
            groups.add(g);
        }
        ConfigurableGroup[] configurableGroupArray = groups.toArray(new ConfigurableGroup[groups.size()]);
        if (configurableGroupArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "filterEmptyGroups"));
        }
        return configurableGroupArray;
    }

    public boolean editConfigurable(Project project, Configurable configurable) {
        return this.editConfigurable(project, ShowSettingsUtilImpl.createDimensionKey(configurable), configurable);
    }

    public <T extends Configurable> T findApplicationConfigurable(Class<T> confClass) {
        return ConfigurableExtensionPointUtil.findApplicationConfigurable(confClass);
    }

    public <T extends Configurable> T findProjectConfigurable(Project project, Class<T> confClass) {
        return ConfigurableExtensionPointUtil.findProjectConfigurable(project, confClass);
    }

    public boolean editConfigurable(Project project, String dimensionServiceKey, @NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        return ShowSettingsUtilImpl.editConfigurable(null, project, configurable, dimensionServiceKey, null);
    }

    public boolean editConfigurable(Project project, Configurable configurable, Runnable advancedInitialization) {
        return ShowSettingsUtilImpl.editConfigurable(null, project, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), advancedInitialization);
    }

    public boolean editConfigurable(Component parent, Configurable configurable) {
        return this.editConfigurable(parent, configurable, null);
    }

    public boolean editConfigurable(Component parent, Configurable configurable, @Nullable Runnable advancedInitialization) {
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), advancedInitialization);
    }

    private static boolean editConfigurable(@Nullable Component parent, @Nullable Project project, Configurable configurable, String dimensionKey, final @Nullable Runnable advancedInitialization) {
        SingleConfigurableEditor editor = parent != null ? new SingleConfigurableEditor(parent, configurable, dimensionKey) : new SingleConfigurableEditor(project, configurable, dimensionKey);
        if (advancedInitialization != null) {
            new UiNotifyConnector.Once((Component)editor.getContentPane(), (Activatable)new Activatable.Adapter(){

                public void showNotify() {
                    advancedInitialization.run();
                }
            });
        }
        editor.show();
        return editor.isOK();
    }

    public static String createDimensionKey(Configurable configurable) {
        String displayName = configurable.getDisplayName();
        displayName = displayName.replaceAll("\n", "_").replaceAll(" ", "_");
        return "#" + displayName;
    }

    public boolean editConfigurable(Component parent, String dimensionServiceKey, Configurable configurable) {
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable, dimensionServiceKey, null);
    }

    public boolean isAlreadyShown() {
        return this.myShown.get();
    }
}

