/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class RevealFileAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        VirtualFile file = ShowFilePathAction.findLocalFile((VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext()));
        Presentation presentation = e.getPresentation();
        presentation.setText(RevealFileAction.getActionName());
        presentation.setEnabled(file != null);
    }

    @NotNull
    public static String getActionName() {
        String string = SystemInfo.isMac ? "Reveal in Finder" : "Show in " + ShowFilePathAction.getFileManagerName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/RevealFileAction", "getActionName"));
        }
        return string;
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile file = ShowFilePathAction.findLocalFile((VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext()));
        if (file != null) {
            ShowFilePathAction.openFile(new File(file.getPresentableUrl()));
        }
    }
}

