/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class MinimizeCurrentWindowAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Component focusOwner = IdeFocusManager.getGlobalInstance().getFocusOwner();
        if (focusOwner != null) {
            Window window;
            Window window2 = window = focusOwner instanceof JFrame ? (Window)focusOwner : SwingUtilities.getWindowAncestor(focusOwner);
            if (window instanceof JFrame && ((JFrame)window).getState() != 1) {
                ((JFrame)window).setState(1);
            }
        }
    }

    public void update(AnActionEvent e) {
        Presentation p = e.getPresentation();
        p.setVisible(SystemInfo.isMac);
        if (SystemInfo.isMac) {
            JFrame frame;
            Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
            if (project != null && (frame = WindowManager.getInstance().getFrame(project)) != null) {
                JRootPane pane = frame.getRootPane();
                p.setEnabled(pane != null && pane.getClientProperty("Idea.Is.In.FullScreen.Mode.Now") == null);
            }
        } else {
            p.setEnabled(false);
        }
    }
}

