/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootsManager;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaQualifiedNameProvider
implements QualifiedNameProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.JavaQualifiedNameProvider");

    @Override
    @Nullable
    public PsiElement adjustElementToCopy(PsiElement element) {
        PsiPackage psiPackage;
        if (element instanceof PsiPackage) {
            return element;
        }
        if (element instanceof PsiDirectory && (psiPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element)) != null) {
            return psiPackage;
        }
        if (element != null && !(element instanceof PsiMember) && element.getParent() instanceof PsiMember) {
            return element.getParent();
        }
        return null;
    }

    @Override
    @Nullable
    public String getQualifiedName(PsiElement element) {
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        if ((element = JavaQualifiedNameProvider.getMember(element)) instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiMember) {
            PsiMember member = (PsiMember)element;
            PsiClass containingClass = member.getContainingClass();
            if (containingClass instanceof PsiAnonymousClass) {
                containingClass = ((PsiAnonymousClass)containingClass).getBaseClassType().resolve();
            }
            if (containingClass == null) {
                return null;
            }
            String classFqn = containingClass.getQualifiedName();
            if (classFqn == null) {
                return member.getName();
            }
            if (member instanceof PsiMethod && containingClass.findMethodsByName(member.getName(), false).length > 1) {
                return classFqn + "#" + member.getName() + JavaQualifiedNameProvider.getParameterString((PsiMethod)member);
            }
            return classFqn + "#" + member.getName();
        }
        return null;
    }

    @Override
    public PsiElement qualifiedNameToElement(String fqn, Project project) {
        VirtualFile file;
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project).findPackage(fqn);
        if (psiPackage != null) {
            return psiPackage;
        }
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
        if (aClass != null) {
            return aClass;
        }
        int endIndex = fqn.indexOf(35);
        if (endIndex != -1) {
            String className = fqn.substring(0, endIndex);
            int paramIndex = fqn.indexOf(40, endIndex);
            aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
            if (aClass != null) {
                String memberName = fqn.substring(endIndex + 1, paramIndex < 0 ? fqn.length() : paramIndex);
                PsiField field = aClass.findFieldByName(memberName, false);
                if (field != null) {
                    return field;
                }
                String paramString = paramIndex < 0 ? "" : fqn.substring(paramIndex);
                for (PsiMethod overload : aClass.findMethodsByName(memberName, false)) {
                    if (!StringUtil.isEmpty((String)paramString) && !paramString.equals(JavaQualifiedNameProvider.getParameterString(overload))) continue;
                    return overload;
                }
            }
        }
        if ((file = JavaQualifiedNameProvider.findFile(fqn, project)) != null) {
            return PsiManager.getInstance((Project)project).findFile(file);
        }
        return null;
    }

    private static VirtualFile findFile(String fqn, Project project) {
        PsiFile[] files;
        List lr = LogicalRootsManager.getLogicalRootsManager((Project)project).getLogicalRoots();
        for (LogicalRoot root : lr) {
            VirtualFile virtualFile;
            VirtualFile vfr = root.getVirtualFile();
            if (vfr == null || (virtualFile = vfr.findFileByRelativePath(fqn)) == null) continue;
            return virtualFile;
        }
        for (VirtualFile root : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            VirtualFile rel = root.findFileByRelativePath(fqn);
            if (rel == null) continue;
            return rel;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(fqn);
        if (file != null) {
            return file;
        }
        for (PsiFile psiFile : files = PsiShortNamesCache.getInstance((Project)project).getFilesByName(fqn)) {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) continue;
            return virtualFile;
        }
        return null;
    }

    @Override
    public void insertQualifiedName(String fqn, PsiElement element, Editor editor, Project project) {
        String toInsert;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = editor.getDocument();
        PsiFile file = documentManager.getPsiFile(document);
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAtCaret = file.findElementAt(offset);
        fqn = fqn.replace('#', '.');
        String suffix = "";
        if (!(element instanceof PsiMember)) {
            toInsert = fqn;
        } else if (elementAtCaret != null && (element instanceof PsiMethod || element instanceof PsiField) && PsiUtil.isInsideJavadocComment((PsiElement)elementAtCaret)) {
            PsiMember member = (PsiMember)element;
            PsiClass aClass = member.getContainingClass();
            String className = aClass == null ? "" : aClass.getQualifiedName();
            String string = toInsert = className == null ? "" : className;
            if (toInsert.length() != 0) {
                toInsert = toInsert + "#";
            }
            toInsert = toInsert + member.getName();
            if (member instanceof PsiMethod) {
                toInsert = toInsert + JavaQualifiedNameProvider.getParameterString((PsiMethod)member);
            }
        } else if (elementAtCaret == null || PsiTreeUtil.getNonStrictParentOfType((PsiElement)elementAtCaret, (Class[])new Class[]{PsiLiteralExpression.class, PsiComment.class}) != null || PsiTreeUtil.getNonStrictParentOfType((PsiElement)elementAtCaret, (Class[])new Class[]{PsiJavaFile.class}) == null) {
            toInsert = fqn;
        } else {
            PsiReferenceExpression referenceExpression;
            PsiExpression expression;
            PsiMember targetElement = (PsiMember)element;
            toInsert = targetElement.getName();
            if (targetElement instanceof PsiMethod) {
                suffix = "()";
                if (((PsiMethod)targetElement).isConstructor()) {
                    targetElement = targetElement.getContainingClass();
                }
            } else if (targetElement instanceof PsiClass) {
                if (JavaQualifiedNameProvider.isAfterNew(file, elementAtCaret)) {
                    suffix = "()";
                } else if (toInsert != null && toInsert.length() != 0 && Character.isJavaIdentifierPart(toInsert.charAt(toInsert.length() - 1)) && Character.isJavaIdentifierPart(elementAtCaret.getText().charAt(0))) {
                    suffix = " ";
                }
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            try {
                expression = factory.createExpressionFromText(toInsert + suffix, elementAtCaret);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return;
            }
            Object object = expression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expression).getMethodExpression() : (referenceExpression = expression instanceof PsiReferenceExpression ? (PsiReferenceExpression)expression : null);
            if (referenceExpression == null || !referenceExpression.isValid()) {
                toInsert = fqn;
            } else if (!JavaQualifiedNameProvider.isReferencedTo(referenceExpression, targetElement)) {
                try {
                    referenceExpression.bindToElement((PsiElement)targetElement);
                }
                catch (IncorrectOperationException e) {
                    // empty catch block
                }
                if (!referenceExpression.isValid() || !JavaQualifiedNameProvider.isReferencedTo(referenceExpression, targetElement)) {
                    toInsert = fqn;
                }
            }
        }
        if (toInsert == null) {
            toInsert = "";
        }
        document.insertString(offset, (CharSequence)(toInsert + suffix));
        documentManager.commitAllDocuments();
        int endOffset = offset + toInsert.length() + suffix.length();
        RangeMarker rangeMarker = document.createRangeMarker(endOffset, endOffset);
        elementAtCaret = file.findElementAt(offset);
        if (elementAtCaret != null && elementAtCaret.isValid()) {
            try {
                JavaQualifiedNameProvider.shortenReference(elementAtCaret, element);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(file);
        try {
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, offset);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        int caretOffset = rangeMarker.getEndOffset();
        if (element instanceof PsiMethod && ((PsiMethod)element).getParameterList().getParametersCount() != 0 && StringUtil.endsWithChar((CharSequence)suffix, (char)')')) {
            --caretOffset;
        }
        editor.getCaretModel().moveToOffset(caretOffset);
    }

    private static String getParameterString(PsiMethod method) {
        String toInsert = "(";
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            if (i != 0) {
                toInsert = toInsert + ", ";
            }
            toInsert = toInsert + parameter.getType().getCanonicalText();
        }
        toInsert = toInsert + ")";
        return toInsert;
    }

    private static boolean isReferencedTo(PsiReferenceExpression referenceExpression, PsiMember targetElement) {
        PsiElement resolved = referenceExpression.advancedResolve(true).getElement();
        if (!(resolved instanceof PsiMember)) {
            return false;
        }
        PsiClass aClass = ((PsiMember)resolved).getContainingClass();
        if (aClass instanceof PsiAnonymousClass) {
            aClass = ((PsiAnonymousClass)aClass).getBaseClassType().resolve();
        }
        return aClass == targetElement.getContainingClass();
    }

    @Nullable
    private static PsiElement getMember(PsiElement element) {
        PsiElement resolved;
        if (element instanceof PsiMember) {
            return element;
        }
        if (element instanceof PsiReference && (resolved = ((PsiReference)element).resolve()) instanceof PsiMember) {
            return resolved;
        }
        if (!(element instanceof PsiIdentifier)) {
            return null;
        }
        PsiElement parent = element.getParent();
        PsiMember member = null;
        if (parent instanceof PsiJavaCodeReferenceElement) {
            PsiElement resolved2 = ((PsiJavaCodeReferenceElement)parent).resolve();
            if (resolved2 instanceof PsiMember) {
                member = (PsiMember)resolved2;
            }
        } else if (parent instanceof PsiMember) {
            member = (PsiMember)parent;
        }
        return member;
    }

    private static boolean isAfterNew(PsiFile file, PsiElement elementAtCaret) {
        PsiElement prevSibling = elementAtCaret.getPrevSibling();
        if (prevSibling == null) {
            return false;
        }
        int offset = prevSibling.getTextRange().getStartOffset();
        PsiElement prevElement = file.findElementAt(offset);
        return PsiTreeUtil.getParentOfType((PsiElement)prevElement, PsiNewExpression.class) != null;
    }

    private static void shortenReference(PsiElement element, PsiElement elementToInsert) throws IncorrectOperationException {
        while (element.getParent() instanceof PsiJavaCodeReferenceElement) {
            if ((element = element.getParent()) != null) continue;
            return;
        }
        JavaCodeStyleManager codeStyleManagerEx = JavaCodeStyleManager.getInstance((Project)element.getProject());
        codeStyleManagerEx.shortenClassReferences(element, 8192);
    }
}

