/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GotoActionBase
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.GotoActionBase");
    protected static Class myInAction = null;
    private static final Map<Class, Pair<String, Integer>> ourLastStrings = ContainerUtil.newHashMap();

    public void actionPerformed(AnActionEvent e) {
        LOG.assertTrue(!((Object)((Object)this)).getClass().equals(myInAction));
        try {
            myInAction = ((Object)((Object)this)).getClass();
            this.gotoActionPerformed(e);
        }
        catch (Throwable t) {
            LOG.error(t);
            myInAction = null;
        }
    }

    protected abstract void gotoActionPerformed(AnActionEvent var1);

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        presentation.setEnabled(!((Object)((Object)this)).getClass().equals(myInAction) && (!this.requiresProject() || project != null) && this.hasContributors(dataContext));
        presentation.setVisible(this.hasContributors(dataContext));
    }

    protected boolean hasContributors(DataContext dataContext) {
        return true;
    }

    protected boolean requiresProject() {
        return true;
    }

    @Nullable
    public static PsiElement getPsiContext(AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file != null) {
            return file;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        return GotoActionBase.getPsiContext(project);
    }

    @Nullable
    public static PsiElement getPsiContext(Project project) {
        if (project == null) {
            return null;
        }
        Editor selectedEditor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (selectedEditor == null) {
            return null;
        }
        Document document = selectedEditor.getDocument();
        return PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
    }

    protected static Pair<String, Integer> getInitialText(boolean useEditorSelection, AnActionEvent e) {
        Pair<String, Integer> lastString;
        SpeedSearchSupply supply;
        String selectedText;
        Editor editor;
        String predefined = (String)e.getData(PlatformDataKeys.PREDEFINED_TEXT);
        if (!StringUtil.isEmpty((String)predefined)) {
            return Pair.create((Object)predefined, (Object)0);
        }
        if (useEditorSelection && (editor = (Editor)e.getData(CommonDataKeys.EDITOR)) != null && (selectedText = editor.getSelectionModel().getSelectedText()) != null && !selectedText.contains("\n")) {
            return Pair.create((Object)selectedText, (Object)0);
        }
        String query = (String)e.getData(SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY);
        if (!StringUtil.isEmpty((String)query)) {
            return Pair.create((Object)query, (Object)0);
        }
        Component focusOwner = IdeFocusManager.getInstance((Project)GotoActionBase.getEventProject((AnActionEvent)e)).getFocusOwner();
        if (focusOwner instanceof JComponent && (supply = SpeedSearchSupply.getSupply((JComponent)((JComponent)focusOwner))) != null) {
            return Pair.create((Object)supply.getEnteredPrefix(), (Object)0);
        }
        if (myInAction != null && (lastString = ourLastStrings.get(myInAction)) != null) {
            return lastString;
        }
        return Pair.create((Object)"", (Object)0);
    }

    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model, GotoActionCallback<T> callback) {
        this.showNavigationPopup(e, model, callback, true);
    }

    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model, GotoActionCallback<T> callback, boolean allowMultipleSelection) {
        this.showNavigationPopup(e, model, callback, null, true, allowMultipleSelection);
    }

    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model, GotoActionCallback<T> callback, @Nullable String findUsagesTitle, boolean useSelectionFromEditor) {
        this.showNavigationPopup(e, model, callback, findUsagesTitle, useSelectionFromEditor, true);
    }

    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model, GotoActionCallback<T> callback, @Nullable String findUsagesTitle, boolean useSelectionFromEditor, boolean allowMultipleSelection) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean mayRequestOpenInCurrentWindow = model.willOpenEditor() && FileEditorManagerEx.getInstanceEx(project).hasSplitOrUndockedWindows();
        Pair<String, Integer> start = GotoActionBase.getInitialText(useSelectionFromEditor, e);
        this.showNavigationPopup(callback, findUsagesTitle, ChooseByNamePopup.createPopup(project, model, GotoActionBase.getPsiContext(e), (String)start.first, mayRequestOpenInCurrentWindow, (int)((Integer)start.second)), allowMultipleSelection);
    }

    protected <T> void showNavigationPopup(GotoActionCallback<T> callback, @Nullable String findUsagesTitle, ChooseByNamePopup popup) {
        this.showNavigationPopup(callback, findUsagesTitle, popup, true);
    }

    protected <T> void showNavigationPopup(final GotoActionCallback<T> callback, @Nullable String findUsagesTitle, final ChooseByNamePopup popup, boolean allowMultipleSelection) {
        final Class startedAction = myInAction;
        LOG.assertTrue(startedAction != null);
        popup.setCheckBoxShortcut(this.getShortcutSet());
        popup.setFindUsagesTitle(findUsagesTitle);
        final ChooseByNameFilter<T> filter = callback.createFilter(popup);
        popup.invoke(new ChooseByNamePopupComponent.Callback(){

            public void onClose() {
                ourLastStrings.put(myInAction, Pair.create((Object)popup.getEnteredText(), (Object)popup.getSelectedIndex()));
                if (startedAction != null && startedAction.equals(myInAction)) {
                    myInAction = null;
                }
                if (filter != null) {
                    filter.close();
                }
            }

            public void elementChosen(Object element) {
                callback.elementChosen(popup, element);
            }
        }, ModalityState.current(), allowMultipleSelection);
    }

    protected static abstract class GotoActionCallback<T> {
        protected GotoActionCallback() {
        }

        @Nullable
        protected ChooseByNameFilter<T> createFilter(@NotNull ChooseByNamePopup popup) {
            if (popup == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/actions/GotoActionBase$GotoActionCallback", "createFilter"));
            }
            return null;
        }

        public abstract void elementChosen(ChooseByNamePopup var1, Object var2);
    }
}

