/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.ide.util.gotoByName.MatchResult;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionAction
extends GotoActionBase
implements DumbAware {
    public static final Comparator<MatchResult> ELEMENTS_COMPARATOR = new Comparator<MatchResult>(){

        @Override
        public int compare(MatchResult o1, MatchResult o2) {
            if (o1.elementName.equals("$$$SETTINGS$$$")) {
                return 1;
            }
            if (o2.elementName.equals("$$$SETTINGS$$$")) {
                return -1;
            }
            return o1.elementName.compareToIgnoreCase(o2.elementName);
        }
    };

    @Override
    public void gotoActionPerformed(final AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.action");
        GotoActionModel model = new GotoActionModel(project, component, editor, file);
        GotoActionBase.GotoActionCallback<Object> callback = new GotoActionBase.GotoActionCallback<Object>(){

            @Override
            public void elementChosen(ChooseByNamePopup popup, Object element) {
                String enteredText = popup.getEnteredText();
                GotoActionAction.openOptionOrPerformAction(element, enteredText, project, component, e);
            }
        };
        Pair<String, Integer> start = GotoActionAction.getInitialText(false, e);
        this.showNavigationPopup(callback, null, GotoActionAction.createPopup(project, model, (String)start.first, (Integer)start.second), false);
    }

    private static ChooseByNamePopup createPopup(Project project, GotoActionModel model, String initialText, int initialIndex) {
        return ChooseByNamePopup.createPopup(project, (ChooseByNameModel)model, new DefaultChooseByNameItemProvider(null){

            @Override
            protected void sortNamesList(@NotNull String namePattern, @NotNull List<MatchResult> namesList) {
                if (namePattern == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/actions/GotoActionAction$3", "sortNamesList"));
                }
                if (namesList == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/actions/GotoActionAction$3", "sortNamesList"));
                }
                Collections.sort(namesList, ELEMENTS_COMPARATOR);
            }
        }, initialText, false, initialIndex);
    }

    public static void openOptionOrPerformAction(Object element, final String enteredText, final Project project, final Component component, final @Nullable AnActionEvent e) {
        if (element instanceof OptionDescription) {
            final String configurableId = ((OptionDescription)element).getConfigurableId();
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ShowSettingsUtilImpl.showSettingsDialog(project, configurableId, enteredText);
                }
            });
        } else {
            AnAction action;
            AnAction anAction = action = element instanceof AnAction ? (AnAction)element : (AnAction)((Map.Entry)element).getKey();
            if (action != null) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DataContext context;
                        if (component == null || !component.isShowing()) {
                            return;
                        }
                        Presentation presentation = action.getTemplatePresentation().clone();
                        AnActionEvent event = new AnActionEvent(e == null ? null : e.getInputEvent(), context = DataManager.getInstance().getDataContext(component), e == null ? "unknown" : e.getPlace(), presentation, ActionManager.getInstance(), e == null ? 0 : e.getModifiers());
                        if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)true)) {
                            if (action instanceof ActionGroup) {
                                JBPopupFactory.getInstance().createActionGroupPopup(presentation.getText(), (ActionGroup)action, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false).showInBestPositionFor(context);
                            } else {
                                ActionUtil.performActionDumbAware((AnAction)action, (AnActionEvent)event);
                            }
                        }
                    }
                }, ModalityState.NON_MODAL);
            }
        }
    }

    @Override
    protected boolean requiresProject() {
        return false;
    }
}

