/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.daemon.impl.IdentifierUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootsManager;
import com.intellij.util.ObjectUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyReferenceAction
extends DumbAwareAction {
    public static final DataFlavor ourFlavor = FileCopyPasteUtil.createJvmDataFlavor(MyTransferable.class);

    public CopyReferenceAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        boolean enabled = editor != null && FileDocumentManager.getInstance().getFile(editor.getDocument()) != null || CopyReferenceAction.getElementToCopy(editor, dataContext) != null;
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setVisible(true);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PsiElement element = CopyReferenceAction.getElementToCopy(editor, dataContext);
        if (!CopyReferenceAction.doCopy(element, project, editor) && editor != null && project != null) {
            Document document = editor.getDocument();
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(document);
            if (file != null) {
                String toCopy = CopyReferenceAction.getFileFqn(file) + ":" + (editor.getCaretModel().getLogicalPosition().line + 1);
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(toCopy));
                CopyReferenceAction.setStatusBarText(project, toCopy + " has been copied");
            }
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        if (element != null && editor != null && project != null) {
            PsiElement nameIdentifier = IdentifierUtil.getNameIdentifier(element);
            if (nameIdentifier != null) {
                highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{nameIdentifier}, attributes, true, null);
            } else {
                PsiReference reference = TargetElementUtilBase.findReference(editor, editor.getCaretModel().getOffset());
                if (reference != null) {
                    highlightManager.addOccurrenceHighlights(editor, new PsiReference[]{reference}, attributes, true, null);
                } else if (element != PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(editor.getDocument())) {
                    highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{element}, attributes, true, null);
                }
            }
        }
    }

    @Nullable
    private static PsiElement getElementToCopy(@Nullable Editor editor, DataContext dataContext) {
        PsiReference reference;
        PsiElement element = null;
        if (editor != null && (reference = TargetElementUtilBase.findReference(editor)) != null) {
            element = reference.getElement();
        }
        if (element == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        if (element == null && editor == null) {
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (virtualFile != null && project != null) {
                element = PsiManager.getInstance((Project)project).findFile(virtualFile);
            }
        }
        if (element instanceof PsiFile && !((PsiFile)element).getViewProvider().isPhysical()) {
            return null;
        }
        for (QualifiedNameProvider provider : (QualifiedNameProvider[])Extensions.getExtensions(QualifiedNameProvider.EP_NAME)) {
            PsiElement adjustedElement = provider.adjustElementToCopy(element);
            if (adjustedElement == null) continue;
            return adjustedElement;
        }
        return element;
    }

    public static boolean doCopy(PsiElement element, Project project) {
        return CopyReferenceAction.doCopy(element, project, null);
    }

    private static boolean doCopy(PsiElement element, @Nullable Project project, @Nullable Editor editor) {
        String fqn = CopyReferenceAction.elementToFqn(element, editor);
        if (fqn == null) {
            return false;
        }
        CopyPasteManager.getInstance().setContents((Transferable)new MyTransferable(fqn));
        CopyReferenceAction.setStatusBarText(project, IdeBundle.message((String)"message.reference.to.fqn.has.been.copied", (Object[])new Object[]{fqn}));
        return true;
    }

    private static void setStatusBarText(Project project, String message) {
        StatusBarEx statusBar;
        if (project != null && (statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(project)) != null) {
            statusBar.setInfo(message);
        }
    }

    @Nullable
    public static String elementToFqn(PsiElement element) {
        return CopyReferenceAction.elementToFqn(element, null);
    }

    @Nullable
    public static String elementToFqn(PsiElement element, @Nullable Editor editor) {
        PsiReference reference;
        String result = CopyReferenceAction.getQualifiedNameFromProviders(element);
        if (result != null) {
            return result;
        }
        if (editor != null && (reference = TargetElementUtilBase.findReference(editor, editor.getCaretModel().getOffset())) != null && (result = CopyReferenceAction.getQualifiedNameFromProviders(reference.resolve())) != null) {
            return result;
        }
        String fqn = null;
        if (element instanceof PsiFile) {
            PsiFile file = (PsiFile)element;
            fqn = FileUtil.toSystemIndependentName((String)CopyReferenceAction.getFileFqn(file));
        }
        return fqn;
    }

    @Nullable
    private static String getQualifiedNameFromProviders(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        for (QualifiedNameProvider provider : (QualifiedNameProvider[])Extensions.getExtensions(QualifiedNameProvider.EP_NAME)) {
            String result = provider.getQualifiedName(element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @NotNull
    private static String getFileFqn(PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            String string = file.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/CopyReferenceAction", "getFileFqn"));
            }
            return string;
        }
        Project project = file.getProject();
        LogicalRoot logicalRoot = LogicalRootsManager.getLogicalRootsManager((Project)project).findLogicalRoot(virtualFile);
        if (logicalRoot != null && logicalRoot.getVirtualFile() != null) {
            String logical = FileUtil.toSystemIndependentName((String)VfsUtilCore.virtualToIoFile((VirtualFile)logicalRoot.getVirtualFile()).getPath());
            String path = FileUtil.toSystemIndependentName((String)VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile).getPath());
            String string = (String)ObjectUtils.assertNotNull((Object)FileUtil.getRelativePath((String)logical, (String)path, (char)'/'));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/CopyReferenceAction", "getFileFqn"));
            }
            return string;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(virtualFile);
        if (contentRoot != null) {
            String string = (String)ObjectUtils.assertNotNull((Object)FileUtil.getRelativePath((File)VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot), (File)VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile)));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/CopyReferenceAction", "getFileFqn"));
            }
            return string;
        }
        String string = virtualFile.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/CopyReferenceAction", "getFileFqn"));
        }
        return string;
    }

    private static class MyTransferable
    implements Transferable {
        private final String fqn;

        public MyTransferable(String fqn) {
            this.fqn = fqn;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{ourFlavor, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return ArrayUtilRt.find((Object[])this.getTransferDataFlavors(), (Object)flavor) != -1;
        }

        @Override
        @Nullable
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(flavor)) {
                return this.fqn;
            }
            return null;
        }
    }
}

