/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.LightColors;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class BaseShowRecentFilesAction
extends AnAction
implements DumbAware {
    private static final Color BORDER_COLOR = Gray._135;

    public void actionPerformed(AnActionEvent e) {
        this.show((Project)CommonDataKeys.PROJECT.getData(e.getDataContext()));
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = (Project)CommonDataKeys.PROJECT.getData(event.getDataContext());
        presentation.setEnabled(project != null);
    }

    protected void show(Project project) {
        DefaultListModel<VirtualFile> model = new DefaultListModel<VirtualFile>();
        FileEditorManagerEx fem = FileEditorManagerEx.getInstanceEx(project);
        Object[] selectedFiles = fem.getSelectedFiles();
        VirtualFile currentFile = fem.getCurrentFile();
        VirtualFile[] files = this.filesToShow(project);
        FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
        for (int i = files.length - 1; i >= 0; --i) {
            boolean isSelected;
            VirtualFile file = files[i];
            boolean bl = isSelected = ArrayUtil.find((Object[])selectedFiles, (Object)file) >= 0;
            if (isSelected && file.equals(currentFile) || editorProviderManager.getProviders(project, file).length <= 0) continue;
            model.addElement(file);
        }
        JLabel pathLabel = new JLabel(" ");
        pathLabel.setHorizontalAlignment(4);
        Font font = pathLabel.getFont();
        pathLabel.setFont(font.deriveFont(10.0f));
        JBList list = new JBList(model);
        list.addKeyListener(new KeyAdapter((JList)list, model, project){
            final /* synthetic */ JList val$list;
            final /* synthetic */ DefaultListModel val$model;
            final /* synthetic */ Project val$project;
            {
                this.val$list = jList;
                this.val$model = defaultListModel;
                this.val$project = project;
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    Object[] values;
                    int index = this.val$list.getSelectedIndex();
                    if (index == -1 || index >= this.val$list.getModel().getSize()) {
                        return;
                    }
                    for (Object value : values = this.val$list.getSelectedValues()) {
                        VirtualFile file = (VirtualFile)value;
                        this.val$model.removeElement(file);
                        if (this.val$model.getSize() > 0) {
                            if (this.val$model.getSize() == index) {
                                this.val$list.setSelectedIndex(this.val$model.getSize() - 1);
                            } else if (this.val$model.getSize() > index) {
                                this.val$list.setSelectedIndex(index);
                            }
                        } else {
                            this.val$list.clearSelection();
                        }
                        EditorHistoryManager.getInstance(this.val$project).removeFile(file);
                    }
                }
            }
        });
        MyListSelectionListener listSelectionListener = new MyListSelectionListener(pathLabel, (JList)list);
        list.getSelectionModel().addListSelectionListener(listSelectionListener);
        Runnable runnable = new Runnable((JList)list, project){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Project val$project;
            {
                this.val$list = jList;
                this.val$project = project;
            }

            @Override
            public void run() {
                Object[] values;
                for (Object value : values = this.val$list.getSelectedValues()) {
                    VirtualFile file = (VirtualFile)value;
                    FileEditorManager.getInstance((Project)this.val$project).openFile(file, true, true);
                }
            }
        };
        if (list.getModel().getSize() == 0) {
            list.clearSelection();
        }
        list.setCellRenderer(new RecentFilesRenderer(project));
        JPanel footerPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(BORDER_COLOR);
                g.drawLine(0, 0, this.getWidth(), 0);
            }
        };
        footerPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        footerPanel.add(pathLabel);
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list).setTitle(this.getTitle()).setAdText(" ").setMovable(true).setItemChoosenCallback(runnable).setModalContext(false).addAdditionalChooseKeystroke(BaseShowRecentFilesAction.getAdditionalSelectKeystroke()).setFilteringEnabled((Function)new Function<Object, String>(){

            public String fun(Object o) {
                return o instanceof VirtualFile ? ((VirtualFile)o).getName() : "";
            }
        });
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(this.getPeerActionId());
        PeerListener listener = new PeerListener(project, this.getPeerActionId());
        for (Shortcut shortcut : shortcuts) {
            if (!(shortcut instanceof KeyboardShortcut) || ((KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            KeyStroke keyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            builder.registerKeyboardAction(keyStroke, (ActionListener)listener);
        }
        JBPopup popup = builder.createPopup();
        listener.setPopup(popup);
        listSelectionListener.setPopup(popup);
        popup.showCenteredInCurrentWindow(project);
    }

    protected abstract String getTitle();

    protected abstract VirtualFile[] filesToShow(Project var1);

    protected abstract String getPeerActionId();

    private static KeyStroke getAdditionalSelectKeystroke() {
        Shortcut[] shortcuts;
        for (Shortcut shortcut : shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("EditSource")) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            return ((KeyboardShortcut)shortcut).getFirstKeyStroke();
        }
        return null;
    }

    private static class MyListSelectionListener
    implements ListSelectionListener {
        private final JLabel myPathLabel;
        private final JList myList;
        private JBPopup myPopup;

        public MyListSelectionListener(JLabel pathLabel, JList list) {
            this.myPathLabel = pathLabel;
            this.myList = list;
        }

        private String getTitle2Text(String fullText) {
            int labelWidth = this.myPathLabel.getWidth();
            if (fullText == null || fullText.length() == 0) {
                return " ";
            }
            while (this.myPathLabel.getFontMetrics(this.myPathLabel.getFont()).stringWidth(fullText) > labelWidth) {
                int sep = fullText.indexOf(File.separatorChar, 4);
                if (sep < 0) {
                    return fullText;
                }
                fullText = "..." + fullText.substring(sep);
            }
            return fullText;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyListSelectionListener.this.updatePathLabel();
                }
            });
        }

        private void updatePathLabel() {
            Object[] values = this.myList.getSelectedValues();
            if (values != null && values.length == 1) {
                VirtualFile parent = ((VirtualFile)values[0]).getParent();
                if (parent != null) {
                    this.myPathLabel.setText(this.getTitle2Text(parent.getPresentableUrl()));
                } else {
                    this.myPathLabel.setText(" ");
                }
            } else {
                this.myPathLabel.setText(" ");
            }
            if (this.myPopup != null) {
                this.myPopup.setAdText(this.myPathLabel.getText(), 4);
            }
        }

        public void setPopup(JBPopup popup) {
            this.myPopup = popup;
        }
    }

    private static class PeerListener
    implements ActionListener {
        private final Project myProject;
        private final String myId;
        private JBPopup myPopup;

        public PeerListener(Project project, String id) {
            this.myProject = project;
            this.myId = id;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myPopup != null) {
                this.myPopup.cancel();
            }
            BaseShowRecentFilesAction peer = (BaseShowRecentFilesAction)ActionManager.getInstance().getAction(this.myId);
            peer.show(this.myProject);
        }

        public void setPopup(JBPopup popup) {
            this.myPopup = popup;
        }
    }

    private static class RecentFilesRenderer
    extends ColoredListCellRenderer {
        private final Project myProject;

        public RecentFilesRenderer(Project project) {
            this.myProject = project;
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof VirtualFile) {
                VirtualFile virtualFile = (VirtualFile)value;
                String name = virtualFile.getPresentableName();
                this.setIcon(IconUtil.getIcon((VirtualFile)virtualFile, (int)2, (Project)this.myProject));
                FileStatus fileStatus = FileStatusManager.getInstance((Project)this.myProject).getStatus(virtualFile);
                TextAttributes attributes = new TextAttributes(fileStatus.getColor(), null, null, EffectType.LINE_UNDERSCORE, 0);
                this.append(name, SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
                if (!selected && FileEditorManager.getInstance((Project)this.myProject).isFileOpen(virtualFile)) {
                    this.setBackground(LightColors.SLIGHTLY_GREEN);
                }
            }
        }
    }
}

