/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.UI;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class AboutPopup {
    public void show(@Nullable Window window) {
        RelativePoint location;
        ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
        JPanel panel = new JPanel(new BorderLayout());
        Icon image = IconLoader.getIcon((String)appInfo.getAboutImageUrl());
        if (appInfo.showLicenseeInfo()) {
            final InfoSurface infoSurface = new InfoSurface(image);
            infoSurface.setPreferredSize(new Dimension(image.getIconWidth(), image.getIconHeight()));
            panel.add((Component)infoSurface, "North");
            new DumbAwareAction(){

                public void actionPerformed(AnActionEvent e) {
                    AboutPopup.copyInfoToClipboard(infoSurface.getText());
                }
            }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"meta C", "control C"}), (JComponent)panel);
        } else {
            panel.add((Component)new JLabel(image), "North");
        }
        if (window != null) {
            Rectangle r = window.getBounds();
            location = new RelativePoint((Component)window, new Point((r.width - image.getIconWidth()) / 2, (r.height - image.getIconHeight()) / 2));
        } else {
            Rectangle r = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            location = new RelativePoint(new Point((r.width - image.getIconWidth()) / 2, (r.height - image.getIconHeight()) / 2));
        }
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)panel).setRequestFocus(true).setFocusable(true).setResizable(false).setMovable(false).setModalContext(false).setShowShadow(true).setShowBorder(false).setCancelKeyEnabled(true).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).createPopup().show(location);
    }

    private static void copyInfoToClipboard(String text) {
        try {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class InfoSurface
    extends JPanel {
        private final Color myColor;
        private final Color myLinkColor;
        private final Icon myImage;
        private Font myFont;
        private Font myBoldFont;
        private final List<AboutBoxLine> myLines = new ArrayList<AboutBoxLine>();
        private StringBuilder myInfo = new StringBuilder();
        private final List<Link> myLinks = new ArrayList<Link>();
        private Link myActiveLink;

        public InfoSurface(Icon image) {
            ApplicationInfoImpl appInfo = (ApplicationInfoImpl)ApplicationInfoEx.getInstanceEx();
            this.myImage = image;
            this.myColor = Color.white;
            this.myLinkColor = appInfo.getAboutLinkColor() != null ? appInfo.getAboutLinkColor() : UI.getColor((String)"link.foreground");
            this.setOpaque(false);
            this.setBackground(this.myColor);
            Calendar cal = appInfo.getBuildDate();
            this.myLines.add(new AboutBoxLine(appInfo.getFullApplicationName(), true, null));
            this.appendLast();
            String buildInfo = IdeBundle.message((String)"about.box.build.number", (Object[])new Object[]{appInfo.getBuild().asString()});
            String buildDate = "";
            if (appInfo.getBuild().isSnapshot()) {
                buildDate = new SimpleDateFormat("HH:mm, ").format(cal.getTime());
            }
            buildDate = buildDate + DateFormatUtil.formatAboutDialogDate((Date)cal.getTime());
            buildInfo = buildInfo + IdeBundle.message((String)"about.box.build.date", (Object[])new Object[]{buildDate});
            this.myLines.add(new AboutBoxLine(buildInfo));
            this.appendLast();
            this.myLines.add(new AboutBoxLine(""));
            LicensingFacade provider = LicensingFacade.getInstance();
            if (provider != null) {
                this.myLines.add(new AboutBoxLine(provider.getLicensedToMessage(), true, null));
                for (String message : provider.getLicenseRestrictionsMessages()) {
                    this.myLines.add(new AboutBoxLine(message));
                }
            }
            this.myLines.add(new AboutBoxLine(""));
            Properties properties = System.getProperties();
            String javaVersion = properties.getProperty("java.runtime.version", properties.getProperty("java.version", "unknown"));
            String arch = properties.getProperty("os.arch", "");
            this.myLines.add(new AboutBoxLine(IdeBundle.message((String)"about.box.jre", (Object[])new Object[]{javaVersion, arch})));
            this.appendLast();
            String vmVersion = properties.getProperty("java.vm.name", "unknown");
            String vmVendor = properties.getProperty("java.vendor", "unknown");
            this.myLines.add(new AboutBoxLine(IdeBundle.message((String)"about.box.vm", (Object[])new Object[]{vmVersion, vmVendor})));
            this.appendLast();
            String thirdParty = appInfo.getThirdPartySoftwareURL();
            if (thirdParty != null) {
                this.myLines.add(new AboutBoxLine(""));
                this.myLines.add(new AboutBoxLine(""));
                this.myLines.add(new AboutBoxLine("Powered by ").keepWithNext());
                this.myLines.add(new AboutBoxLine("open-source software", false, thirdParty).keepWithNext());
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    if (InfoSurface.this.myActiveLink != null) {
                        event.consume();
                        BrowserUtil.browse((String)InfoSurface.this.myActiveLink.myUrl);
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent event) {
                    boolean hadLink = InfoSurface.this.myActiveLink != null;
                    InfoSurface.this.myActiveLink = null;
                    for (Link link : InfoSurface.this.myLinks) {
                        if (!link.myRectangle.contains(event.getPoint())) continue;
                        InfoSurface.this.myActiveLink = link;
                        if (hadLink) break;
                        InfoSurface.this.setCursor(Cursor.getPredefinedCursor(12));
                        break;
                    }
                    if (hadLink && InfoSurface.this.myActiveLink == null) {
                        InfoSurface.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
        }

        private void appendLast() {
            this.myInfo.append(this.myLines.get(this.myLines.size() - 1).getText()).append("\n");
        }

        @Override
        protected void paintChildren(Graphics g) {
            ApplicationInfo appInfo;
            Rectangle aboutLogoRect;
            super.paintChildren(g);
            Graphics2D g2 = (Graphics2D)g;
            UIUtil.applyRenderingHints((Graphics)g);
            Font labelFont = UIUtil.getLabelFont();
            if (SystemInfo.isWindows) {
                labelFont = new Font("Tahoma", 0, 12);
            }
            for (int labelSize = 10; labelSize != 6; --labelSize) {
                this.myLinks.clear();
                g2.setPaint(this.myColor);
                this.myImage.paintIcon(this, g2, 0, 0);
                g2.setColor(this.myColor);
                TextRenderer renderer = new TextRenderer(0, 165, 398, 120, g2);
                UIUtil.setupComposite((Graphics2D)g2);
                this.myFont = labelFont.deriveFont(0, labelSize);
                this.myBoldFont = labelFont.deriveFont(1, labelSize + 1);
                try {
                    renderer.render(30, 0, this.myLines);
                    break;
                }
                catch (TextRenderer.OverflowException ignore) {
                    continue;
                }
            }
            if ((aboutLogoRect = (appInfo = ApplicationInfo.getInstance()).getAboutLogoRect()) != null) {
                this.myLinks.add(new Link(aboutLogoRect, appInfo.getCompanyURL()));
            }
        }

        public String getText() {
            return this.myInfo.toString();
        }

        private static class Link {
            private final Rectangle myRectangle;
            private final String myUrl;

            private Link(Rectangle rectangle, String url) {
                this.myRectangle = rectangle;
                this.myUrl = url;
            }
        }

        private static class AboutBoxLine {
            private final String myText;
            private final boolean myBold;
            private final String myUrl;
            private boolean myKeepWithNext;

            public AboutBoxLine(String text, boolean bold, String url) {
                this.myText = text;
                this.myBold = bold;
                this.myUrl = url;
            }

            public AboutBoxLine(String text) {
                this.myText = text;
                this.myBold = false;
                this.myUrl = null;
            }

            public String getText() {
                return this.myText;
            }

            public boolean isBold() {
                return this.myBold;
            }

            public String getUrl() {
                return this.myUrl;
            }

            public boolean isKeepWithNext() {
                return this.myKeepWithNext;
            }

            public AboutBoxLine keepWithNext() {
                this.myKeepWithNext = true;
                return this;
            }
        }

        private class TextRenderer {
            private final int xBase;
            private final int yBase;
            private final int w;
            private final int h;
            private final Graphics2D g2;
            private int x = 0;
            private int y = 0;
            private FontMetrics fontmetrics;
            private int fontAscent;
            private int fontHeight;
            private Font font;

            public TextRenderer(int xBase, int yBase, int w, int h, Graphics2D g2) {
                this.xBase = xBase;
                this.yBase = yBase;
                this.w = w;
                this.h = h;
                this.g2 = g2;
                if (SystemInfo.isWindows) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
            }

            public void render(int indentX, int indentY, List<AboutBoxLine> lines) throws OverflowException {
                this.x = indentX;
                this.y = indentY;
                ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
                for (AboutBoxLine line : lines) {
                    String s = line.getText();
                    this.setFont(line.isBold() ? InfoSurface.this.myBoldFont : InfoSurface.this.myFont);
                    if (line.getUrl() != null) {
                        this.g2.setColor(InfoSurface.this.myLinkColor);
                        FontMetrics metrics = this.g2.getFontMetrics(this.font);
                        InfoSurface.this.myLinks.add(new Link(new Rectangle(this.x, this.yBase + this.y - this.fontAscent, metrics.stringWidth(s), this.fontHeight), line.getUrl()));
                    } else {
                        this.g2.setColor(appInfo.getAboutForeground());
                    }
                    this.renderString(s, indentX);
                    if (line.isKeepWithNext() || line.equals(lines.get(lines.size() - 1))) continue;
                    this.lineFeed(indentX, s);
                }
            }

            private void renderString(String s, int indentX) throws OverflowException {
                List words = StringUtil.split((String)s, (String)" ");
                for (String word : words) {
                    int wordWidth = this.fontmetrics.stringWidth(word);
                    if (this.x + wordWidth >= this.w) {
                        this.lineFeed(indentX, word);
                    } else {
                        char c = ' ';
                        int cW = this.fontmetrics.charWidth(c);
                        if (this.x + cW < this.w) {
                            this.g2.drawChars(new char[]{c}, 0, 1, this.xBase + this.x, this.yBase + this.y);
                            this.x += cW;
                        }
                    }
                    this.renderWord(word, indentX);
                }
            }

            private void renderWord(String s, int indentX) throws OverflowException {
                for (int j = 0; j != s.length(); ++j) {
                    char c = s.charAt(j);
                    int cW = this.fontmetrics.charWidth(c);
                    if (this.x + cW >= this.w) {
                        this.lineFeed(indentX, s);
                    }
                    this.g2.drawChars(new char[]{c}, 0, 1, this.xBase + this.x, this.yBase + this.y);
                    this.x += cW;
                }
            }

            private void lineFeed(int indent, String s) throws OverflowException {
                this.x = indent;
                this.y = s.length() == 0 ? (this.y += this.fontHeight / 3) : (this.y += this.fontHeight);
                if (this.y >= this.h) {
                    throw new OverflowException();
                }
            }

            private void setFont(Font font) {
                this.font = font;
                this.fontmetrics = this.g2.getFontMetrics(font);
                this.g2.setFont(font);
                this.fontAscent = this.fontmetrics.getAscent();
                this.fontHeight = this.fontmetrics.getHeight();
            }

            public class OverflowException
            extends Exception {
            }
        }
    }
}

