/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiActivityMonitorImpl
extends UiActivityMonitor
implements ModalityStateListener,
Disposable {
    private final FactoryMap<Project, BusyContainer> myObjects = new FactoryMap<Project, BusyContainer>(){

        protected BusyContainer create(Project key) {
            if (this.isEmpty()) {
                UiActivityMonitorImpl.this.installListener();
            }
            return key == null ? new BusyContainer(key) : new BusyContainer(null){

                @Override
                protected BusyImpl createBusyImpl(HashSet<UiActivity> key) {
                    return new BusyImpl(key, this){

                        @Override
                        public boolean isReady() {
                            for (Map.Entry entry : UiActivityMonitorImpl.this.myObjects.entrySet()) {
                                BusyContainer eachContainer = (BusyContainer)entry.getValue();
                                BusyImpl busy = eachContainer.getOrCreateBusy(this.myToWatchArray);
                                if (busy == this || busy.isOwnReady()) continue;
                                return false;
                            }
                            return this.isOwnReady();
                        }
                    };
                }
            };
        }
    };
    private boolean myActive;
    private BusyObject myEmptyBusy = new BusyObject.Impl(){

        public boolean isReady() {
            return true;
        }
    };

    public void installListener() {
        LaterInvocator.addModalityStateListener(this, this);
    }

    public void dispose() {
        this.myObjects.clear();
    }

    public void beforeModalityStateChanged(boolean entering) {
        if (UiActivityMonitorImpl.isUnitTestMode()) {
            this.maybeReady();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UiActivityMonitorImpl.this.maybeReady();
                }
            });
        }
    }

    public void maybeReady() {
        for (BusyContainer each : this.myObjects.values()) {
            each.onReady();
        }
    }

    public BusyObject getBusy(@NotNull Project project, UiActivity ... toWatch) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/UiActivityMonitorImpl", "getBusy"));
        }
        if (!this.isActive()) {
            return this.myEmptyBusy;
        }
        return this._getBusy(project, toWatch);
    }

    public BusyObject getBusy(UiActivity ... toWatch) {
        if (!this.isActive()) {
            return this.myEmptyBusy;
        }
        return this._getBusy(null, toWatch);
    }

    public void addActivity(@NotNull Project project, @NotNull UiActivity activity) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        this.addActivity(project, activity, UiActivityMonitorImpl.getDefaultModalityState());
    }

    public void addActivity(final @NotNull Project project, final @NotNull UiActivity activity, final @NotNull ModalityState effectiveModalityState) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        if (effectiveModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        if (!this.isActive()) {
            return;
        }
        UiActivityMonitorImpl.invokeLaterIfNeeded(new MyRunnable(){

            @Override
            public void run(Throwable allocation) {
                UiActivityMonitorImpl.this.getBusyContainer(project).addActivity(activity, allocation, effectiveModalityState);
            }
        });
    }

    public void removeActivity(final @NotNull Project project, final @NotNull UiActivity activity) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/UiActivityMonitorImpl", "removeActivity"));
        }
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/UiActivityMonitorImpl", "removeActivity"));
        }
        if (!this.isActive()) {
            return;
        }
        UiActivityMonitorImpl.invokeLaterIfNeeded(new MyRunnable(){

            @Override
            public void run(Throwable allocation) {
                UiActivityMonitorImpl.this._getBusy(project, new UiActivity[0]).removeActivity(activity);
            }
        });
    }

    public void addActivity(@NotNull UiActivity activity) {
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        this.addActivity(activity, UiActivityMonitorImpl.getDefaultModalityState());
    }

    private static ModalityState getDefaultModalityState() {
        return ApplicationManager.getApplication().getNoneModalityState();
    }

    public void addActivity(final @NotNull UiActivity activity, final @NotNull ModalityState effectiveModalityState) {
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        if (effectiveModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        if (!this.isActive()) {
            return;
        }
        UiActivityMonitorImpl.invokeLaterIfNeeded(new MyRunnable(){

            @Override
            public void run(Throwable allocation) {
                UiActivityMonitorImpl.this.getBusyContainer(null).addActivity(activity, allocation, effectiveModalityState);
            }
        });
    }

    public void removeActivity(final @NotNull UiActivity activity) {
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/UiActivityMonitorImpl", "removeActivity"));
        }
        if (!this.isActive()) {
            return;
        }
        UiActivityMonitorImpl.invokeLaterIfNeeded(new MyRunnable(){

            @Override
            public void run(Throwable allocation) {
                UiActivityMonitorImpl.this._getBusy(null, new UiActivity[0]).removeActivity(activity);
            }
        });
    }

    private BusyImpl _getBusy(@Nullable Project key, UiActivity ... toWatch) {
        return this.getBusyContainer(key).getOrCreateBusy(toWatch);
    }

    @NotNull
    private BusyContainer getBusyContainer(@Nullable Project key) {
        BusyContainer container = (BusyContainer)this.myObjects.get((Object)key);
        BusyContainer busyContainer = container != null ? container : this.getGlobalBusy();
        if (busyContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivityMonitorImpl", "getBusyContainer"));
        }
        return busyContainer;
    }

    void initBusyObjectFor(@Nullable Project key) {
        this.myObjects.put((Object)key, (Object)new BusyContainer(key));
    }

    boolean hasObjectFor(Project project) {
        return this.myObjects.containsKey((Object)project);
    }

    private BusyContainer getGlobalBusy() {
        return (BusyContainer)this.myObjects.get(null);
    }

    public void clear() {
        Set keys = this.myObjects.keySet();
        for (Project each : keys) {
            ((BusyContainer)this.myObjects.get((Object)each)).clear();
        }
    }

    public void setActive(boolean active) {
        if (this.myActive == active) {
            return;
        }
        if (this.myActive && !active) {
            this.clear();
        }
        this.myActive = active;
    }

    public boolean isActive() {
        return this.myActive;
    }

    protected ModalityState getCurrentState() {
        return ModalityState.current();
    }

    private static void invokeLaterIfNeeded(final MyRunnable runnable) {
        Exception allocation;
        Exception exception = allocation = Registry.is((String)"ide.debugMode") ? new Exception() : null;
        if (UiActivityMonitorImpl.isUnitTestMode()) {
            runnable.run(allocation);
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    runnable.run(allocation);
                }
            });
        }
    }

    private static boolean isUnitTestMode() {
        Application app = ApplicationManager.getApplication();
        return app == null || app.isUnitTestMode();
    }

    public class BusyContainer
    implements Disposable {
        private Map<Set<UiActivity>, BusyImpl> myActivities2Object = new HashMap<Set<UiActivity>, BusyImpl>();
        private Map<BusyImpl, Set<UiActivity>> myObject2Activities = new HashMap<BusyImpl, Set<UiActivity>>();
        private Set<UiActivity> myActivities = new HashSet<UiActivity>();
        private BusyImpl myDefault;
        private boolean myRemovingActivityNow;
        @Nullable
        private final Project myProject;

        public BusyContainer(Project project) {
            this.myProject = project;
            this.myDefault = this.registerBusyObject(new HashSet<UiActivity>());
            if (project != null) {
                Disposer.register((Disposable)project, (Disposable)this);
            }
        }

        public BusyImpl getOrCreateBusy(UiActivity ... activities) {
            HashSet<UiActivity> key = new HashSet<UiActivity>();
            key.addAll(Arrays.asList(activities));
            if (this.myActivities2Object.containsKey(key)) {
                return this.myActivities2Object.get(key);
            }
            return this.registerBusyObject(key);
        }

        private BusyImpl registerBusyObject(HashSet<UiActivity> key) {
            BusyImpl busy = this.createBusyImpl(key);
            this.myActivities2Object.put(key, busy);
            this.myObject2Activities.put(busy, key);
            return busy;
        }

        protected BusyImpl createBusyImpl(HashSet<UiActivity> key) {
            return new BusyImpl(key, this);
        }

        public void onReady() {
            Iterator<Set<UiActivity>> keyIterator = this.myActivities2Object.keySet().iterator();
            while (keyIterator.hasNext()) {
                Set<UiActivity> eachKey = keyIterator.next();
                BusyImpl busy = this.myActivities2Object.get(eachKey);
                busy.onReady();
                if (!busy.isReady()) continue;
                keyIterator.remove();
                this.myObject2Activities.remove((Object)busy);
            }
        }

        public void clear() {
            UiActivity[] activities;
            for (UiActivity each : activities = this.myActivities.toArray(new UiActivity[this.myActivities.size()])) {
                UiActivityMonitorImpl.this.removeActivity(each);
            }
        }

        public void onActivityAdded(BusyImpl busy, UiActivity activity) {
            this.myActivities.add(activity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onActivityRemoved(BusyImpl busy, UiActivity activity) {
            Set<UiActivity> activities;
            if (this.myRemovingActivityNow) {
                return;
            }
            HashMap<BusyImpl, Set<UiActivity>> toRemove = new HashMap<BusyImpl, Set<UiActivity>>();
            try {
                this.myRemovingActivityNow = true;
                this.myActivities.remove(activity);
                for (BusyImpl each : this.myObject2Activities.keySet()) {
                    if (each != busy) {
                        each.removeActivity(activity);
                    }
                    if (!each.isReady()) continue;
                    activities = this.myObject2Activities.get((Object)busy);
                    toRemove.put(busy, activities);
                }
            }
            finally {
                for (BusyImpl each : toRemove.keySet()) {
                    activities = this.myObject2Activities.remove((Object)each);
                    this.myActivities2Object.remove(activities);
                }
                this.myRemovingActivityNow = false;
            }
        }

        public void addActivity(UiActivity activity, Throwable allocation, ModalityState state) {
            this.getOrCreateBusy(activity);
            Set<BusyImpl> busies = this.myObject2Activities.keySet();
            for (BusyImpl each : busies) {
                each.addActivity(activity, allocation, state);
            }
        }

        public void dispose() {
            UiActivityMonitorImpl.this.myObjects.remove((Object)this.myProject);
        }
    }

    private static interface MyRunnable {
        public void run(Throwable var1);
    }

    private class BusyImpl
    extends BusyObject.Impl {
        private final Map<UiActivity, ActivityInfo> myActivities = new HashMap<UiActivity, ActivityInfo>();
        private final Set<UiActivity> myQueuedToRemove = new HashSet<UiActivity>();
        protected final Set<UiActivity> myToWatch;
        protected final UiActivity[] myToWatchArray;
        private BusyContainer myContainer;

        private BusyImpl(Set<UiActivity> toWatch, BusyContainer container) {
            this.myToWatch = toWatch;
            this.myToWatchArray = toWatch.toArray(new UiActivity[toWatch.size()]);
            this.myContainer = container;
        }

        public boolean isReady() {
            return this.isOwnReady() && UiActivityMonitorImpl.this.getGlobalBusy().getOrCreateBusy(this.myToWatchArray).isOwnReady();
        }

        boolean isOwnReady() {
            HashMap<UiActivity, ActivityInfo> infoToCheck = new HashMap<UiActivity, ActivityInfo>();
            for (Set eachActivitySet : this.myContainer.myActivities2Object.keySet()) {
                BusyImpl eachBusyObject = (BusyImpl)((Object)this.myContainer.myActivities2Object.get(eachActivitySet));
                if (eachBusyObject == this) continue;
                for (UiActivity eachOtherActivity : eachActivitySet) {
                    for (UiActivity eachToWatch : this.myToWatch) {
                        if (!eachToWatch.isSameOrGeneralFor(eachOtherActivity) || !eachBusyObject.myActivities.containsKey(eachOtherActivity)) continue;
                        infoToCheck.put(eachOtherActivity, eachBusyObject.myActivities.get(eachOtherActivity));
                    }
                }
            }
            infoToCheck.putAll(this.myActivities);
            if (infoToCheck.isEmpty()) {
                return true;
            }
            ModalityState current = UiActivityMonitorImpl.this.getCurrentState();
            for (Map.Entry entry : infoToCheck.entrySet()) {
                ActivityInfo info = (ActivityInfo)entry.getValue();
                if (current.dominates(info.getEffectiveState())) continue;
                return false;
            }
            return true;
        }

        public void addActivity(UiActivity activity, Throwable allocation, ModalityState effectiveModalityState) {
            if (!this.myToWatch.isEmpty() && !this.myToWatch.contains(activity)) {
                return;
            }
            this.myActivities.put(activity, new ActivityInfo(allocation, effectiveModalityState));
            this.myQueuedToRemove.remove(activity);
            this.myContainer.onActivityAdded(this, activity);
        }

        public void removeActivity(final UiActivity activity) {
            if (!this.myActivities.containsKey(activity)) {
                return;
            }
            this.myQueuedToRemove.add(activity);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!BusyImpl.this.myQueuedToRemove.contains(activity)) {
                        return;
                    }
                    BusyImpl.this.myQueuedToRemove.remove(activity);
                    BusyImpl.this.myActivities.remove(activity);
                    BusyImpl.this.myContainer.onActivityRemoved(BusyImpl.this, activity);
                    BusyImpl.this.onReady();
                }
            };
            if (UiActivityMonitorImpl.isUnitTestMode()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void clear() {
            UiActivity[] activities;
            for (UiActivity each : activities = this.myActivities.keySet().toArray(new UiActivity[this.myActivities.size()])) {
                this.removeActivity(each);
            }
        }
    }

    private static class ActivityInfo {
        private final Throwable myAllocation;
        private final ModalityState myEffectiveState;

        private ActivityInfo(@Nullable Throwable allocation, @NotNull ModalityState effectiveState) {
            if (effectiveState == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/UiActivityMonitorImpl$ActivityInfo", "<init>"));
            }
            this.myAllocation = allocation;
            this.myEffectiveState = effectiveState;
        }

        @Nullable
        public Throwable getAllocation() {
            return this.myAllocation;
        }

        @NotNull
        public ModalityState getEffectiveState() {
            ModalityState modalityState = this.myEffectiveState;
            if (modalityState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivityMonitorImpl$ActivityInfo", "getEffectiveState"));
            }
            return modalityState;
        }
    }
}

