/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.platform.ProjectBaseDirectory;
import com.intellij.util.messages.MessageBus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RecentDirectoryProjectsManager", roamingType=RoamingType.DISABLED, storages={@Storage(file="$APP_CONFIG$/other.xml")})
public class RecentDirectoryProjectsManager
extends RecentProjectsManagerBase {
    public RecentDirectoryProjectsManager(MessageBus messageBus) {
        super(messageBus);
    }

    @Override
    @Nullable
    protected String getProjectPath(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/RecentDirectoryProjectsManager", "getProjectPath"));
        }
        ProjectBaseDirectory baseDir = ProjectBaseDirectory.getInstance(project);
        VirtualFile baseDirVFile = baseDir.getBaseDir() != null ? baseDir.getBaseDir() : project.getBaseDir();
        return baseDirVFile != null ? FileUtil.toSystemDependentName((String)baseDirVFile.getPath()) : null;
    }

    @Override
    protected void doOpenProject(@NotNull String projectPath, Project projectToClose, boolean forceOpenInNewFrame) {
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/RecentDirectoryProjectsManager", "doOpenProject"));
        }
        VirtualFile projectDir = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)projectPath));
        if (projectDir != null) {
            PlatformProjectOpenProcessor.doOpenProject(projectDir, projectToClose, forceOpenInNewFrame, -1, null, true);
        }
    }
}

