/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.ElementBase;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.util.Function;
import com.intellij.util.ui.update.ComparableObject;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeIconProvider
extends IconProvider
implements DumbAware {
    private final Map<Ext, Icon> myIconCache = new HashMap<Ext, Icon>();
    private final Set<Ext> myCustomIconExtensions = SystemInfo.isWindows ? new HashSet<Ext>(Arrays.asList(new Ext("exe"), new Ext("ico"))) : new HashSet();
    private final Map<String, Icon> myCustomIconCache = new HashMap<String, Icon>();
    private static final Ext NO_EXT = new Ext(null);
    private static final Ext CLOSED_DIR = new Ext(null, 0);

    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        VirtualFile file;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/NativeIconProvider", "getIcon"));
        }
        if (element instanceof PsiFileSystemItem && (file = ((PsiFileSystemItem)element).getVirtualFile()) != null) {
            return this.doGetIcon(file, flags);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Icon doGetIcon(@NotNull VirtualFile file, int flags) {
        Icon icon;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/NativeIconProvider", "doGetIcon"));
        }
        if (!this.isNativeFileType(file)) {
            return null;
        }
        final Ext ext = NativeIconProvider.getExtension(file, flags);
        final String filePath = file.getPath();
        Map<Ext, Icon> map = this.myIconCache;
        synchronized (map) {
            icon = !this.myCustomIconExtensions.contains((Object)ext) ? (ext != null ? this.myIconCache.get((Object)ext) : null) : (filePath != null ? this.myCustomIconCache.get(filePath) : null);
        }
        if (icon != null) {
            return icon;
        }
        return new DeferredIconImpl<VirtualFile>((Icon)ElementBase.ICON_PLACEHOLDER.getValue(), file, false, new Function<VirtualFile, Icon>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Icon fun(VirtualFile virtualFile) {
                Icon icon;
                File f = new File(filePath);
                if (!f.exists()) {
                    return null;
                }
                try {
                    assert (SwingComponentHolder.ourFileChooser != null || !ApplicationManager.getApplication().isReadAccessAllowed());
                    icon = NativeIconProvider.getNativeIcon(f);
                }
                catch (Exception e) {
                    return null;
                }
                if (ext != null) {
                    Map map = NativeIconProvider.this.myIconCache;
                    synchronized (map) {
                        if (!NativeIconProvider.this.myCustomIconExtensions.contains((Object)ext)) {
                            NativeIconProvider.this.myIconCache.put(ext, icon);
                        } else if (filePath != null) {
                            NativeIconProvider.this.myCustomIconCache.put(filePath, icon);
                        }
                    }
                }
                return icon;
            }
        });
    }

    @Nullable
    public static Icon getNativeIcon(@Nullable File file) {
        return file == null ? null : SwingComponentHolder.ourFileChooser.getIcon(file);
    }

    private static Ext getExtension(VirtualFile file, int flags) {
        if (file.isDirectory()) {
            if (file.getExtension() == null) {
                return CLOSED_DIR;
            }
            return new Ext(file.getExtension(), flags);
        }
        return file.getExtension() != null ? new Ext(file.getExtension()) : NO_EXT;
    }

    protected boolean isNativeFileType(VirtualFile file) {
        FileType type = file.getFileType();
        if (type instanceof INativeFileType) {
            return ((INativeFileType)type).useNativeIcon();
        }
        return type instanceof UnknownFileType && !file.isDirectory();
    }

    private static class Ext
    extends ComparableObject.Impl {
        private final Object[] myText;

        private Ext(@Nullable String text) {
            this.myText = new Object[]{text};
        }

        private Ext(@Nullable String text, int flags) {
            this.myText = new Object[]{text, flags};
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.myText == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/NativeIconProvider$Ext", "getEqualityObjects"));
            }
            return this.myText;
        }

        public String toString() {
            return this.myText[0] != null ? this.myText[0].toString() : null;
        }
    }

    static class SwingComponentHolder {
        private static final JFileChooser ourFileChooser = new JFileChooser();

        SwingComponentHolder() {
        }
    }
}

