/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.JavaIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.PlatformUtils;
import org.jetbrains.annotations.NotNull;

public class JavaLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    private static final String GENERAL_CODE_SAMPLE = "public class Foo {\n  public int[] X = new int[]{1, 3, 5 7, 9, 11};\n\n  public void foo(boolean a, int x, int y, int z) {\n    label1:\n    do {\n      try {\n        if (x > 0) {\n          int someVariable = a ? x : y;\n          int anotherVariable = a ? x : y;\n        }\n        else if (x < 0) {\n          int someVariable = (y + z);\n          someVariable = x = x + y;\n        }\n        else {\n          label2:\n          for (int i = 0; i < 5; i++) doSomething(i);\n        }\n        switch (a) {\n          case 0:\n            doCase0();\n            break;\n          default:\n            doDefault();\n        }\n      }\n      catch (Exception e) {\n        processException(e.getMessage(), x + y, z, a);\n      }\n      finally {\n        processFinally();\n      }\n    }\n    while (true);\n\n    if (2 < 3) return;\n    if (3 < 4) return;\n    do {\n      x++\n    }\n    while (x < 10000);\n    while (x < 50000) x++;\n    for (int i = 0; i < 5; i++) System.out.println(i);\n  }\n\n  private class InnerClass implements I1, I2 {\n    public void bar() throws E1, E2 {\n    }\n  }\n}";
    private static final String BLANK_LINE_SAMPLE = "/*\n * This is a sample file.\n */\npackage com.intellij.samples;\n\nimport com.intellij.idea.Main;\n\nimport javax.swing.*;\nimport java.util.Vector;\n\npublic class Foo {\n  private int field1;\n  private int field2;\n\n  public void foo1() {\n      new Runnable() {\n          public void run() {\n          }\n      }\n  }\n\n  public class InnerClass {\n  }\n}\nclass AnotherClass {\n}\ninterface TestInterface {\n    int MAX = 10;\n    int MIN = 1;\n    void method1();\n    void method2();\n}";
    private static final String SPACING_SAMPLE = "@Annotation(param1 = \"value1\", param2 = \"value2\")\n@SuppressWarnings({\"ALL\"})\npublic class Foo<T extends Bar & Abba, U> {\n  int[] X = new int[]{1, 3, 5, 6, 7, 87, 1213, 2};\n\n  public void foo(int x, int y) {    Runnable r = () -> {};\n    Runnable r1 = this :: bar;\n    for (int i = 0; i < x; i++) {\n      y += (y ^ 0x123) << 2;\n    }\n    do {\n      try(MyResource r1 = getResource(); MyResource r2 = null) {\n        if (0 < x && x < 10) {\n          while (x != y) {\n            x = f(x * 3 + 5);\n          }\n        }\n        else {\n          synchronized (this) {\n            switch (e.getCode()) {\n              //...\n            }\n          }\n        }\n      }\n      catch (MyException e) {\n      }\n      finally {\n        int[] arr = (int[])g(y);\n        x = y >= 0 ? arr[y] : -1;\n        Map<String, String> sMap = new HashMap<String, String>();\n        Bar.<String, Integer>mess(null);\n      }\n    }\n    while (true);\n  }\n  void bar(){{return;}}\n}\nclass Bar {\n    static <U, T> U mess(T t) {\n        return null;\n    }\n}\ninterface Abba {}";
    private static final String WRAPPING_CODE_SAMPLE = "/*\n * This is a sample file.\n */\n\npublic class ThisIsASampleClass extends C1 implements I1, I2, I3, I4, I5 {\n  private int f1 = 1;\n  private String field2 = \"\";\n  public void foo1(int i1, int i2, int i3, int i4, int i5, int i6, int i7) {}\n  public static void longerMethod() throws Exception1, Exception2, Exception3 {\n// todo something\n    int\ni = 0;\n    int[] a = new int[] {1, 2, 0x0052, 0x0053, 0x0054};\n    int var1 = 1; int var2 = 2;\n    foo1(0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057);\n    int x = (3 + 4 + 5 + 6) * (7 + 8 + 9 + 10) * (11 + 12 + 13 + 14 + 0xFFFFFFFF);\n    String s1, s2, s3;\n    s1 = s2 = s3 = \"012345678901456\";\n    assert i + j + k + l + n+ m <= 2 : \"assert description\";    int y = 2 > 3 ? 7 + 8 + 9 : 11 + 12 + 13;\n    super.getFoo().foo().getBar().bar();\n\n    label:     if (2 < 3) return; else if (2 > 3) return; else return;\n    for (int i = 0; i < 0xFFFFFF; i += 2) System.out.println(i);\n    while (x < 50000) x++;\n    do x++ while (x < 10000);\n    switch (a) {\n    case 0:\n      doCase0();\n      break;\n    default:\n      doDefault();\n    }\n    try (MyResource r1 = getResource(); MyResource r2 = null) {\n      doSomething();\n    } catch (Exception e) {\n      processException(e);\n    } finally {\n      processFinally();\n    }\n    do {\n        x--;\n    } while (x > 10) \n  }\n    public static void test() \n        throws Exception { \n        foo.foo().bar(\"arg1\", \n                      \"arg2\"); \n        new Object() {};    } \n    class TestInnerClass {}\n    interface TestInnerInterface {}\n}\n\nenum Breed {\n    Dalmatian(), Labrador(), Dachshund()\n}\n\n@Annotation1 @Annotation2 @Annotation3(param1=\"value1\", param2=\"value2\") @Annotation4 class Foo {\n    @Annotation1 @Annotation3(param1=\"value1\", param2=\"value2\") public static void foo(){\n    }\n    @Annotation1 @Annotation3(param1=\"value1\", param2=\"value2\") public static int myFoo;\n    public void method(@Annotation1 @Annotation3(param1=\"value1\", param2=\"value2\") final int param){\n        @Annotation1 @Annotation3(param1=\"value1\", param2=\"value2\") final int localVariable;    }\n}";

    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/JavaLanguageCodeStyleSettingsProvider", "getLanguage"));
        }
        return javaLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/JavaLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            return SPACING_SAMPLE;
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            return BLANK_LINE_SAMPLE;
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            return WRAPPING_CODE_SAMPLE;
        }
        return GENERAL_CODE_SAMPLE;
    }

    public int getRightMargin(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/JavaLanguageCodeStyleSettingsProvider", "getRightMargin"));
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            return 37;
        }
        return super.getRightMargin(settingsType);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/JavaLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/JavaLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        consumer.showAllStandardOptions();
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showCustomOption(JavaCodeStyleSettings.class, "SPACES_WITHIN_ANGLE_BRACKETS", "Angle brackets", CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            String groupName = CodeStyleSettingsCustomizable.SPACES_IN_TYPE_ARGUMENTS;
            consumer.moveStandardOption("SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS", groupName);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "SPACE_AFTER_CLOSING_ANGLE_BRACKET_IN_TYPE_ARGUMENT", "After closing angle bracket", groupName, new Object[0]);
            groupName = CodeStyleSettingsCustomizable.SPACES_IN_TYPE_PARAMETERS;
            consumer.showCustomOption(JavaCodeStyleSettings.class, "SPACE_BEFORE_OPENING_ANGLE_BRACKET_IN_TYPE_PARAMETER", "Before opening angle bracket", groupName, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "SPACE_AROUND_TYPE_BOUNDS_IN_TYPE_PARAMETERS", "Around type bounds", groupName, new Object[0]);
        }
    }

    public PsiFile createFileFromText(Project project, String text) {
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("sample.java", (FileType)StdFileTypes.JAVA, (CharSequence)text, LocalTimeCounter.currentTime(), true, false);
        file.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, (Object)LanguageLevel.HIGHEST);
        return file;
    }

    public DisplayPriority getDisplayPriority() {
        if (PlatformUtils.isIdeaUltimate()) {
            return DisplayPriority.KEY_LANGUAGE_SETTINGS;
        }
        return DisplayPriority.LANGUAGE_SETTINGS;
    }

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings settings = new CommonCodeStyleSettings((Language)JavaLanguage.INSTANCE);
        settings.initIndentOptions();
        return settings;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new JavaIndentOptionsEditor();
    }
}

