/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reference.SoftReference;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.VolatileImage;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import sun.awt.DisplayChangedListener;

public class IdeRepaintManager
extends RepaintManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.HackyRepaintManager");
    private Map<GraphicsConfiguration, VolatileImage> myImagesMap;
    @NonNls
    private static final String FAULTY_FIELD_NAME = "volatileMap";
    WeakReference<JComponent> myLastComponent;
    private Object displayChangeHack;

    public IdeRepaintManager() {
        block3: {
            try {
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] devices = env.getScreenDevices();
                Class<?> aClass = Class.forName("sun.awt.DisplayChangedListener");
                this.displayChangeHack = new DisplayChangeHandler();
                if (aClass.isInstance(env)) {
                    env.getClass().getMethod("addDisplayChangedListener", aClass).invoke((Object)env, this.displayChangeHack);
                }
            }
            catch (Throwable t) {
                if (t instanceof HeadlessException) break block3;
                LOG.error("Cannot setup display change listener", t);
            }
        }
    }

    @Override
    public Image getVolatileOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
        Image buffer = super.getVolatileOffscreenBuffer(c, proposedWidth, proposedHeight);
        this.clearLeakyImages(false);
        return buffer;
    }

    private synchronized void clearLeakyImages(boolean force) {
        if (this.myImagesMap == null) {
            try {
                Field volMapField = RepaintManager.class.getDeclaredField(FAULTY_FIELD_NAME);
                volMapField.setAccessible(true);
                this.myImagesMap = (Map)volMapField.get(this);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        if (force || this.myImagesMap.size() > 3) {
            Dimension size = this.getDoubleBufferMaximumSize();
            this.setDoubleBufferMaximumSize(new Dimension(0, 0));
            this.setDoubleBufferMaximumSize(size);
        }
    }

    @Override
    public void validateInvalidComponents() {
        super.validateInvalidComponents();
    }

    @Override
    public void addInvalidComponent(JComponent invalidComponent) {
        this.checkThreadViolations(invalidComponent);
        super.addInvalidComponent(invalidComponent);
    }

    @Override
    public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
        this.checkThreadViolations(c);
        super.addDirtyRegion(c, x, y, w, h);
    }

    private void checkThreadViolations(JComponent c) {
        if (!SwingUtilities.isEventDispatchThread() && c.isShowing()) {
            StackTraceElement[] stackTrace;
            boolean repaint = false;
            boolean fromSwing = false;
            boolean swingKnownNonAwtOperations = false;
            Exception exception = new Exception();
            for (StackTraceElement st : stackTrace = exception.getStackTrace()) {
                if (repaint && st.getClassName().startsWith("javax.swing.")) {
                    fromSwing = true;
                }
                if (repaint && "imageUpdate".equals(st.getMethodName())) {
                    swingKnownNonAwtOperations = true;
                }
                if (st.getClassName().startsWith("javax.swing.JEditorPane") && st.getMethodName().equals("read")) {
                    swingKnownNonAwtOperations = true;
                    break;
                }
                if (!"repaint".equals(st.getMethodName())) continue;
                repaint = true;
                fromSwing = false;
            }
            if (swingKnownNonAwtOperations) {
                return;
            }
            if (repaint && !fromSwing) {
                return;
            }
            if (SoftReference.dereference(this.myLastComponent) == c) {
                return;
            }
            this.myLastComponent = new WeakReference<JComponent>(c);
            LOG.warn("Access to realized (ever shown) UI components should be done only from the AWT event dispatch thread, revalidate(), invalidate() & repaint() is ok from any thread", (Throwable)exception);
        }
    }

    private class DisplayChangeHandler
    implements DisplayChangedListener,
    Runnable {
        private DisplayChangeHandler() {
        }

        @Override
        public void displayChanged() {
            EventQueue.invokeLater(this);
        }

        @Override
        public void paletteChanged() {
            EventQueue.invokeLater(this);
        }

        @Override
        public void run() {
            IdeRepaintManager.this.clearLeakyImages(true);
        }
    }
}

