/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.models.RevisionProcessingProgress;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.text.DateFormatUtil;

public abstract class FileDifferenceModel {
    protected final Project myProject;
    protected final IdeaGateway myGateway;
    private final boolean isRightContentCurrent;

    protected FileDifferenceModel(Project p, IdeaGateway gw, boolean currentRightContent) {
        this.myProject = p;
        this.myGateway = gw;
        this.isRightContentCurrent = currentRightContent;
    }

    public String getTitle() {
        Entry e = this.getRightEntry();
        if (e == null) {
            e = this.getLeftEntry();
        }
        return FileUtil.toSystemDependentName((String)e.getPath());
    }

    public String getLeftTitle(RevisionProcessingProgress p) {
        if (!this.hasLeftEntry()) {
            return LocalHistoryBundle.message("file.does.not.exist", new Object[0]);
        }
        return this.formatTitle(this.getLeftEntry(), this.isLeftContentAvailable(p));
    }

    public String getRightTitle(RevisionProcessingProgress p) {
        if (!this.hasRightEntry()) {
            return LocalHistoryBundle.message("file.does.not.exist", new Object[0]);
        }
        if (!this.isRightContentAvailable(p)) {
            return this.formatTitle(this.getRightEntry(), false);
        }
        if (this.isRightContentCurrent) {
            return LocalHistoryBundle.message("current.revision", new Object[0]);
        }
        return this.formatTitle(this.getRightEntry(), true);
    }

    private String formatTitle(Entry e, boolean isAvailable) {
        String result = DateFormatUtil.formatPrettyDateTime((long)e.getTimestamp()) + " - " + e.getName();
        if (!isAvailable) {
            result = result + " - " + LocalHistoryBundle.message("content.not.available", new Object[0]);
        }
        return result;
    }

    protected abstract Entry getLeftEntry();

    protected abstract Entry getRightEntry();

    public DiffContent getLeftDiffContent(RevisionProcessingProgress p) {
        if (!this.canShowLeftEntry(p)) {
            return new SimpleContent("");
        }
        return this.doGetLeftDiffContent(p);
    }

    protected abstract DiffContent doGetLeftDiffContent(RevisionProcessingProgress var1);

    public DiffContent getRightDiffContent(RevisionProcessingProgress p) {
        if (!this.canShowRightEntry(p)) {
            return new SimpleContent("");
        }
        if (this.isRightContentCurrent) {
            return this.getEditableRightDiffContent(p);
        }
        return this.getReadOnlyRightDiffContent(p);
    }

    private boolean canShowLeftEntry(RevisionProcessingProgress p) {
        return this.hasLeftEntry() && this.isLeftContentAvailable(p);
    }

    private boolean canShowRightEntry(RevisionProcessingProgress p) {
        return this.hasRightEntry() && this.isRightContentAvailable(p);
    }

    private boolean hasLeftEntry() {
        return this.getLeftEntry() != null;
    }

    private boolean hasRightEntry() {
        return this.getRightEntry() != null;
    }

    protected abstract boolean isLeftContentAvailable(RevisionProcessingProgress var1);

    protected abstract boolean isRightContentAvailable(RevisionProcessingProgress var1);

    protected abstract DiffContent getReadOnlyRightDiffContent(RevisionProcessingProgress var1);

    protected abstract DiffContent getEditableRightDiffContent(RevisionProcessingProgress var1);

    protected SimpleContent createSimpleDiffContent(String content, Entry e) {
        return new SimpleContent(content, this.myGateway.getFileType(e.getName()));
    }

    protected Document getDocument() {
        return this.myGateway.getDocument(this.getRightEntry().getPath());
    }
}

