/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.Content;
import com.intellij.history.core.StreamUtil;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PutLabelChange
extends Change {
    @NotNull
    private final String myName;
    @NotNull
    private final String myProjectId;

    /*
     * WARNING - void declaration
     */
    public PutLabelChange(long id, @NotNull String name, @NotNull String string) {
        void projectId;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/history/core/changes/PutLabelChange", "<init>"));
        }
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/history/core/changes/PutLabelChange", "<init>"));
        }
        super(id);
        this.myName = name;
        this.myProjectId = projectId;
    }

    public PutLabelChange(DataInput in) throws IOException {
        super(in);
        this.myName = StreamUtil.readString(in);
        this.myProjectId = StreamUtil.readString(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        StreamUtil.writeString(out, this.myName);
        StreamUtil.writeString(out, this.myProjectId);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/core/changes/PutLabelChange", "getName"));
        }
        return string;
    }

    @NotNull
    public String getProjectId() {
        String string = this.myProjectId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/core/changes/PutLabelChange", "getProjectId"));
        }
        return string;
    }

    @Override
    public boolean affectsPath(String paths) {
        return false;
    }

    @Override
    public boolean affectsProject(String projectId) {
        return this.myProjectId.equals(projectId);
    }

    @Override
    public boolean affectsMatching(Pattern pattern) {
        return false;
    }

    @Override
    public boolean isCreationalFor(String path) {
        return false;
    }

    @Override
    public List<Content> getContentsToPurge() {
        return Collections.emptyList();
    }

    @Override
    public void accept(ChangeVisitor v) throws ChangeVisitor.StopVisitingException {
        v.visit(this);
    }
}

