/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.library.impl;

import com.intellij.framework.FrameworkAvailabilityCondition;
import com.intellij.framework.library.DownloadableLibraryFileDescription;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.download.impl.DownloadableFileSetDescriptionImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkLibraryVersionImpl
extends DownloadableFileSetDescriptionImpl<DownloadableLibraryFileDescription>
implements FrameworkLibraryVersion {
    @Nullable
    private final String myLibraryName;
    @NotNull
    private final FrameworkAvailabilityCondition myAvailabilityCondition;
    private final String myLibraryCategory;

    public FrameworkLibraryVersionImpl(@Nullable String libraryName, @NotNull String versionString, @NotNull FrameworkAvailabilityCondition availabilityCondition, @NotNull List<DownloadableLibraryFileDescription> libraryFiles, @NotNull String category) {
        if (versionString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/framework/library/impl/FrameworkLibraryVersionImpl", "<init>"));
        }
        if (availabilityCondition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/framework/library/impl/FrameworkLibraryVersionImpl", "<init>"));
        }
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/framework/library/impl/FrameworkLibraryVersionImpl", "<init>"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/framework/library/impl/FrameworkLibraryVersionImpl", "<init>"));
        }
        super(category, versionString, libraryFiles);
        this.myLibraryName = libraryName;
        this.myAvailabilityCondition = availabilityCondition;
        this.myLibraryCategory = category;
    }

    @NotNull
    public FrameworkAvailabilityCondition getAvailabilityCondition() {
        FrameworkAvailabilityCondition frameworkAvailabilityCondition = this.myAvailabilityCondition;
        if (frameworkAvailabilityCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/impl/FrameworkLibraryVersionImpl", "getAvailabilityCondition"));
        }
        return frameworkAvailabilityCondition;
    }

    @NotNull
    public String getDefaultLibraryName() {
        String libName = StringUtil.isEmptyOrSpaces((String)this.myLibraryName) ? this.myLibraryCategory : this.myLibraryName;
        String string = this.myVersionString.length() > 0 ? libName + "-" + this.myVersionString : this.myLibraryCategory;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/impl/FrameworkLibraryVersionImpl", "getDefaultLibraryName"));
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.getDefaultLibraryName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/impl/FrameworkLibraryVersionImpl", "getPresentableName"));
        }
        return string;
    }

    public String getVersionNumber() {
        return this.getVersionString();
    }
}

