/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.library.impl;

import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.frameworks.beans.RequiredFrameworkVersion;
import com.intellij.framework.FrameworkAvailabilityCondition;
import com.intellij.framework.library.DownloadableLibraryDescription;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.framework.library.impl.DownloadableLibraryPropertiesEditor;
import com.intellij.framework.library.impl.LibraryVersionsFetcher;
import com.intellij.ide.util.frameworkSupport.CustomLibraryDescriptionImpl;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class DownloadableLibraryServiceImpl
extends DownloadableLibraryService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.framework.library.impl.DownloadableLibraryServiceImpl");

    @Override
    @NotNull
    public DownloadableLibraryDescription createLibraryDescription(@NotNull String groupId, URL ... localUrls) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/library/impl/DownloadableLibraryServiceImpl", "createLibraryDescription"));
        }
        if (localUrls == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/framework/library/impl/DownloadableLibraryServiceImpl", "createLibraryDescription"));
        }
        LibraryVersionsFetcher libraryVersionsFetcher = new LibraryVersionsFetcher(groupId, localUrls){

            @Override
            @NotNull
            protected FrameworkAvailabilityCondition createAvailabilityCondition(Artifact version) {
                RequiredFrameworkVersion groupVersion = version.getRequiredFrameworkVersion();
                if (groupVersion != null) {
                    FrameworkLibraryAvailabilityCondition frameworkLibraryAvailabilityCondition = new FrameworkLibraryAvailabilityCondition(groupVersion.myGroupId, groupVersion.myVersion);
                    if (frameworkLibraryAvailabilityCondition == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/impl/DownloadableLibraryServiceImpl$1", "createAvailabilityCondition"));
                    }
                    return frameworkLibraryAvailabilityCondition;
                }
                FrameworkAvailabilityCondition frameworkAvailabilityCondition = FrameworkAvailabilityCondition.ALWAYS_TRUE;
                if (frameworkAvailabilityCondition == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/impl/DownloadableLibraryServiceImpl$1", "createAvailabilityCondition"));
                }
                return frameworkAvailabilityCondition;
            }
        };
        if (libraryVersionsFetcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/impl/DownloadableLibraryServiceImpl", "createLibraryDescription"));
        }
        return libraryVersionsFetcher;
    }

    @Override
    @NotNull
    public CustomLibraryDescription createDescriptionForType(Class<? extends DownloadableLibraryType> typeClass) {
        DownloadableLibraryType libraryType = (DownloadableLibraryType)LibraryType.EP_NAME.findExtension(typeClass);
        LOG.assertTrue(libraryType != null, typeClass);
        CustomLibraryDescriptionImpl customLibraryDescriptionImpl = new CustomLibraryDescriptionImpl(libraryType);
        if (customLibraryDescriptionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/impl/DownloadableLibraryServiceImpl", "createDescriptionForType"));
        }
        return customLibraryDescriptionImpl;
    }

    @Override
    @NotNull
    public LibraryPropertiesEditor createDownloadableLibraryEditor(@NotNull DownloadableLibraryDescription description, @NotNull LibraryEditorComponent<LibraryVersionProperties> editorComponent, @NotNull DownloadableLibraryType libraryType) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/library/impl/DownloadableLibraryServiceImpl", "createDownloadableLibraryEditor"));
        }
        if (editorComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/framework/library/impl/DownloadableLibraryServiceImpl", "createDownloadableLibraryEditor"));
        }
        if (libraryType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/framework/library/impl/DownloadableLibraryServiceImpl", "createDownloadableLibraryEditor"));
        }
        DownloadableLibraryPropertiesEditor downloadableLibraryPropertiesEditor = new DownloadableLibraryPropertiesEditor(description, editorComponent, libraryType);
        if (downloadableLibraryPropertiesEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/impl/DownloadableLibraryServiceImpl", "createDownloadableLibraryEditor"));
        }
        return downloadableLibraryPropertiesEditor;
    }

    private static class FrameworkLibraryAvailabilityCondition
    extends FrameworkAvailabilityCondition {
        private final String myGroupId;
        private final String myVersionId;

        public FrameworkLibraryAvailabilityCondition(String groupId, String versionId) {
            this.myGroupId = groupId;
            this.myVersionId = versionId;
        }

        public boolean isAvailableFor(@NotNull FrameworkSupportModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/library/impl/DownloadableLibraryServiceImpl$FrameworkLibraryAvailabilityCondition", "isAvailableFor"));
            }
            Object selectedVersion = ((FrameworkSupportModelBase)model).getSelectedVersion(this.myGroupId);
            return selectedVersion != null && this.myVersionId.equals(selectedVersion.getId());
        }
    }
}

