/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.impl.FacetBasedDetectedFrameworkDescription;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FacetBasedDetectedFrameworkDescriptionImpl<F extends Facet, C extends FacetConfiguration>
extends FacetBasedDetectedFrameworkDescription<F, C> {
    private final Module myModule;

    public FacetBasedDetectedFrameworkDescriptionImpl(@NotNull Module module, FacetBasedFrameworkDetector<F, C> detector, @NotNull C configuration, Set<VirtualFile> files) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/detection/impl/FacetBasedDetectedFrameworkDescriptionImpl", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/framework/detection/impl/FacetBasedDetectedFrameworkDescriptionImpl", "<init>"));
        }
        super(detector, configuration, files);
        this.myModule = module;
    }

    @Override
    protected String getModuleName() {
        return this.myModule.getName();
    }

    public void setupFramework(@NotNull ModifiableModelsProvider modifiableModelsProvider, @NotNull ModulesProvider modulesProvider) {
        if (modifiableModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/detection/impl/FacetBasedDetectedFrameworkDescriptionImpl", "setupFramework"));
        }
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/framework/detection/impl/FacetBasedDetectedFrameworkDescriptionImpl", "setupFramework"));
        }
        this.doSetup(modifiableModelsProvider, this.myModule);
    }

    @Override
    @NotNull
    protected Collection<? extends Facet> getExistentFacets(FacetTypeId<?> underlyingFacetType) {
        Collection collection = FacetManager.getInstance((Module)this.myModule).getFacetsByType(underlyingFacetType);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/FacetBasedDetectedFrameworkDescriptionImpl", "getExistentFacets"));
        }
        return collection;
    }
}

