/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.templateLanguages;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataLanguageBlockFragmentWrapper
implements Block {
    private final Block myOwner;
    private final TextRange myRange;

    public DataLanguageBlockFragmentWrapper(@NotNull Block owner, @NotNull TextRange range) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/formatting/templateLanguages/DataLanguageBlockFragmentWrapper", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/formatting/templateLanguages/DataLanguageBlockFragmentWrapper", "<init>"));
        }
        this.myOwner = owner;
        this.myRange = range;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/templateLanguages/DataLanguageBlockFragmentWrapper", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = AbstractBlock.EMPTY;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/templateLanguages/DataLanguageBlockFragmentWrapper", "getSubBlocks"));
        }
        return list;
    }

    public Wrap getWrap() {
        return this.myOwner.getWrap();
    }

    public Indent getIndent() {
        return this.myOwner.getIndent();
    }

    public Alignment getAlignment() {
        return this.myOwner.getAlignment();
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/formatting/templateLanguages/DataLanguageBlockFragmentWrapper", "getSpacing"));
        }
        return Spacing.getReadOnlySpacing();
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = this.myOwner.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/templateLanguages/DataLanguageBlockFragmentWrapper", "getChildAttributes"));
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        return this.myOwner.isIncomplete();
    }

    public boolean isLeaf() {
        return true;
    }

    public String toString() {
        return "Fragment " + this.getTextRange();
    }
}

