/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.FormatProcessor;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.IndentInside;
import com.intellij.formatting.InitialInfoBuilder;
import com.intellij.formatting.SpacingImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

class WhiteSpace {
    private static final char LINE_FEED = '\n';
    private final int myStart;
    private int myEnd;
    private int mySpaces;
    private int myIndentSpaces;
    private int myInitialLastLinesSpaces;
    private int myInitialLastLinesTabs;
    private CharSequence myInitial;
    private int myFlags;
    private boolean myForceSkipTabulationsUsage;
    private static final byte FIRST = 1;
    private static final byte SAFE = 2;
    private static final byte KEEP_FIRST_COLUMN = 4;
    private static final byte LINE_FEEDS_ARE_READ_ONLY = 8;
    private static final byte READ_ONLY = 16;
    private static final byte CONTAINS_LF_INITIALLY = 32;
    private static final byte CONTAINS_SPACES_INITIALLY = 64;
    private static final int LF_COUNT_SHIFT = 7;
    private static final int MAX_LF_COUNT = 0x1000000;

    public WhiteSpace(int startOffset, boolean isFirst) {
        this.myStart = startOffset;
        this.myEnd = startOffset;
        this.setIsFirstWhiteSpace(isFirst);
    }

    public void append(int newEndOffset, FormattingDocumentModel model, CommonCodeStyleSettings.IndentOptions options) {
        int oldEndOffset = this.myEnd;
        if (newEndOffset == oldEndOffset) {
            return;
        }
        if (this.myStart >= newEndOffset) {
            InitialInfoBuilder.assertInvalidRanges(this.myStart, newEndOffset, model, "some block intersects with whitespace");
        }
        this.myEnd = newEndOffset;
        TextRange range = new TextRange(this.myStart, this.myEnd);
        CharSequence oldText = this.myInitial;
        this.myInitial = model.getText(range);
        if (!this.coveredByBlock(model)) {
            InitialInfoBuilder.assertInvalidRanges(this.myStart, this.myEnd, model, "nonempty text is not covered by block");
        }
        if (newEndOffset > oldEndOffset) {
            this.refreshStateOnEndOffsetIncrease(newEndOffset, oldEndOffset, options.TAB_SIZE);
        } else {
            this.refreshStateOnEndOffsetDecrease(oldText, newEndOffset, oldEndOffset, options.TAB_SIZE);
        }
        IndentInside indent = IndentInside.getLastLineIndent(this.myInitial);
        this.myInitialLastLinesSpaces = indent.whiteSpaces;
        this.myInitialLastLinesTabs = indent.tabs;
        this.myFlags = this.getLineFeeds() > 0 ? (this.myFlags |= 0x20) : (this.myFlags &= 0xFFFFFFDF);
        int totalSpaces = this.getTotalSpaces();
        this.myFlags = totalSpaces > 0 ? (this.myFlags |= 0x40) : (this.myFlags &= 0xFFFFFFBF);
    }

    private boolean coveredByBlock(FormattingDocumentModel model) {
        PsiElement end;
        if (this.myInitial == null) {
            return true;
        }
        if (model.containsWhiteSpaceSymbolsOnly(this.myStart, this.myEnd)) {
            return true;
        }
        if (!(model instanceof FormattingDocumentModelImpl)) {
            return false;
        }
        PsiFile psiFile = ((FormattingDocumentModelImpl)model).getFile();
        if (psiFile == null) {
            return false;
        }
        PsiElement start = psiFile.findElementAt(this.myStart);
        return start == (end = psiFile.findElementAt(this.myEnd - 1)) && start instanceof PsiWhiteSpace;
    }

    private void refreshStateOnEndOffsetIncrease(int newEndOffset, int oldEndOffset, int tabSize) {
        assert (newEndOffset > oldEndOffset);
        WhiteSpaceInfo info = WhiteSpace.parse(this.myInitial, oldEndOffset - this.myStart, newEndOffset - this.myStart, this.mySpaces + this.myIndentSpaces, tabSize);
        if (info.lineFeeds > 0) {
            this.setLineFeeds(this.getLineFeeds() + info.lineFeeds);
            this.mySpaces = 0;
            this.myIndentSpaces = 0;
        }
        this.mySpaces += info.spaces;
        this.myIndentSpaces += info.indentSpaces;
    }

    private void refreshStateOnEndOffsetDecrease(CharSequence oldText, int newEndOffset, int oldEndOffset, int tabSize) {
        assert (newEndOffset < oldEndOffset);
        int lineFeedsNumberAtRemovedText = 0;
        int spacesNumberAtRemovedText = 0;
        int indentSpacesNumberAtRemovedText = 0;
        int column = this.mySpaces + this.myIndentSpaces;
        block5: for (int i = oldEndOffset - 1; i >= newEndOffset; --i) {
            switch (oldText.charAt(i)) {
                case '\n': {
                    ++lineFeedsNumberAtRemovedText;
                    column = 0;
                    continue block5;
                }
                case ' ': {
                    ++spacesNumberAtRemovedText;
                    --column;
                    continue block5;
                }
                case '\t': {
                    int change = column % tabSize;
                    if (change == 0) {
                        change = tabSize;
                    }
                    indentSpacesNumberAtRemovedText += change;
                    column -= change;
                }
            }
        }
        if (this.getLineFeeds() - lineFeedsNumberAtRemovedText <= 0) {
            this.setLineFeeds(0);
            this.mySpaces -= spacesNumberAtRemovedText;
            this.myIndentSpaces -= indentSpacesNumberAtRemovedText;
            return;
        }
        int newLineFeedsNumber = this.getLineFeeds() - lineFeedsNumberAtRemovedText;
        assert (newLineFeedsNumber >= 0);
        newLineFeedsNumber = newLineFeedsNumber < 0 ? 0 : newLineFeedsNumber;
        this.setLineFeeds(newLineFeedsNumber);
        int startOffset = CharArrayUtil.shiftForwardUntil((CharSequence)oldText, (int)(newEndOffset - 1), (String)"\n") + 1;
        WhiteSpaceInfo info = WhiteSpace.parse(oldText, startOffset, newEndOffset, 0, tabSize);
        this.mySpaces = info.spaces;
        this.myIndentSpaces = info.indentSpaces;
    }

    @NotNull
    private static WhiteSpaceInfo parse(@NotNull CharSequence text, int startOffset, int endOffset, int startColumn, int tabSize) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/formatting/WhiteSpace", "parse"));
        }
        assert (startOffset <= endOffset);
        int spaces = 0;
        int indentSpaces = 0;
        int lineFeeds = 0;
        int column = startColumn;
        block4: for (int i = startOffset; i < endOffset; ++i) {
            switch (text.charAt(i)) {
                case '\n': {
                    ++lineFeeds;
                    spaces = 0;
                    indentSpaces = 0;
                    column = 0;
                    continue block4;
                }
                case '\t': {
                    int change = tabSize - column % tabSize;
                    indentSpaces += change;
                    column += change;
                    continue block4;
                }
                default: {
                    ++spaces;
                    ++column;
                }
            }
        }
        WhiteSpaceInfo whiteSpaceInfo = new WhiteSpaceInfo(lineFeeds, indentSpaces, spaces);
        if (whiteSpaceInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/WhiteSpace", "parse"));
        }
        return whiteSpaceInfo;
    }

    public String generateWhiteSpace(CommonCodeStyleSettings.IndentOptions options) {
        return new IndentInfo(this.getLineFeeds(), this.myIndentSpaces, this.mySpaces, this.myForceSkipTabulationsUsage).generateNewWhiteSpace(options);
    }

    public void setSpaces(final int spaces, final int indent) {
        this.performModification(new Runnable(){

            @Override
            public void run() {
                if (!WhiteSpace.this.isKeepFirstColumn() || (WhiteSpace.this.myFlags & 0x40) != 0) {
                    WhiteSpace.this.mySpaces = spaces;
                    WhiteSpace.this.myIndentSpaces = indent;
                }
            }
        });
    }

    private boolean doesNotContainAnySpaces() {
        return this.getTotalSpaces() == 0 && this.getLineFeeds() == 0;
    }

    public int getStartOffset() {
        return this.myStart;
    }

    public int getEndOffset() {
        return this.myEnd;
    }

    private void performModification(Runnable action) {
        if (this.isIsReadOnly()) {
            return;
        }
        boolean before = this.doesNotContainAnySpaces();
        int lineFeedsBefore = this.getLineFeeds();
        action.run();
        if (this.isLineFeedsAreReadOnly()) {
            this.setLineFeeds(lineFeedsBefore);
        }
        if (this.isIsSafe()) {
            boolean after = this.doesNotContainAnySpaces();
            if (before && !after) {
                this.mySpaces = 0;
                this.myIndentSpaces = 0;
                this.setLineFeeds(0);
            } else if (!before && after) {
                this.mySpaces = 1;
                this.myIndentSpaces = 0;
            }
        }
    }

    public void arrangeSpaces(final SpacingImpl spaceProperty) {
        this.performModification(new Runnable(){

            @Override
            public void run() {
                if (spaceProperty != null && WhiteSpace.this.getLineFeeds() == 0) {
                    if (spaceProperty.getMinSpaces() >= 0 && WhiteSpace.this.getTotalSpaces() < spaceProperty.getMinSpaces()) {
                        WhiteSpace.this.setSpaces(spaceProperty.getMinSpaces(), 0);
                    }
                    if (spaceProperty.getMaxSpaces() >= 0 && WhiteSpace.this.getTotalSpaces() > spaceProperty.getMaxSpaces()) {
                        WhiteSpace.this.setSpaces(spaceProperty.getMaxSpaces(), 0);
                    }
                }
            }
        });
    }

    public void arrangeLineFeeds(final SpacingImpl spaceProperty, final FormatProcessor formatProcessor) {
        this.performModification(new Runnable(){

            @Override
            public void run() {
                if (spaceProperty != null) {
                    spaceProperty.refresh(formatProcessor);
                    if (spaceProperty.getMinLineFeeds() >= 0 && WhiteSpace.this.getLineFeeds() < spaceProperty.getMinLineFeeds()) {
                        WhiteSpace.this.setLineFeeds(spaceProperty.getMinLineFeeds());
                    }
                    if (WhiteSpace.this.getLineFeeds() > 0) {
                        if (spaceProperty.getKeepBlankLines() > 0) {
                            if (WhiteSpace.this.getLineFeeds() >= spaceProperty.getKeepBlankLines() + 1) {
                                WhiteSpace.this.setLineFeeds(spaceProperty.getKeepBlankLines() + 1);
                            }
                        } else if (WhiteSpace.this.getLineFeeds() > spaceProperty.getMinLineFeeds()) {
                            if (spaceProperty.shouldKeepLineFeeds()) {
                                WhiteSpace.this.setLineFeeds(Math.max(spaceProperty.getMinLineFeeds(), 1));
                            } else {
                                WhiteSpace.this.setLineFeeds(spaceProperty.getMinLineFeeds());
                                if (WhiteSpace.this.getLineFeeds() == 0) {
                                    WhiteSpace.this.mySpaces = 0;
                                }
                            }
                        }
                        if (WhiteSpace.this.getLineFeeds() == 1 && !spaceProperty.shouldKeepLineFeeds() && spaceProperty.getMinLineFeeds() == 0) {
                            WhiteSpace.this.setLineFeeds(0);
                            WhiteSpace.this.mySpaces = 0;
                        }
                        if (WhiteSpace.this.getLineFeeds() > 0 && WhiteSpace.this.getLineFeeds() < spaceProperty.getPrefLineFeeds()) {
                            WhiteSpace.this.setLineFeeds(spaceProperty.getPrefLineFeeds());
                        }
                    }
                } else if (WhiteSpace.this.isFirst()) {
                    WhiteSpace.this.setLineFeeds(0);
                    WhiteSpace.this.mySpaces = 0;
                }
            }
        });
    }

    public void setForceSkipTabulationsUsage(boolean skip) {
        this.myForceSkipTabulationsUsage = skip;
    }

    public boolean containsLineFeeds() {
        return this.isIsFirstWhiteSpace() || this.getLineFeeds() > 0;
    }

    public int getTotalSpaces() {
        return this.mySpaces + this.myIndentSpaces;
    }

    public void ensureLineFeed() {
        this.performModification(new Runnable(){

            @Override
            public void run() {
                if (!WhiteSpace.this.containsLineFeeds()) {
                    WhiteSpace.this.setLineFeeds(1);
                    WhiteSpace.this.mySpaces = 0;
                }
            }
        });
    }

    public boolean isReadOnly() {
        return this.isIsReadOnly() || this.isIsSafe() && this.doesNotContainAnySpaces();
    }

    public boolean equalsToString(CharSequence ws) {
        if (this.myInitial == null) {
            return ws.length() == 0;
        }
        return Comparing.equal((CharSequence)ws, (CharSequence)this.myInitial, (boolean)true);
    }

    public void setIsSafe(boolean value) {
        this.setFlag(2, value);
    }

    private void setFlag(int mask, boolean value) {
        this.myFlags = value ? (this.myFlags |= mask) : (this.myFlags &= ~mask);
    }

    private boolean getFlag(int mask) {
        return (this.myFlags & mask) != 0;
    }

    private boolean isFirst() {
        return this.isIsFirstWhiteSpace();
    }

    public boolean containsLineFeedsInitially() {
        if (this.myInitial == null) {
            return false;
        }
        return (this.myFlags & 0x20) != 0;
    }

    public void removeLineFeeds(SpacingImpl spacing, FormatProcessor formatProcessor) {
        this.performModification(new Runnable(){

            @Override
            public void run() {
                WhiteSpace.this.setLineFeeds(0);
                WhiteSpace.this.mySpaces = 0;
                WhiteSpace.this.myIndentSpaces = 0;
            }
        });
        this.arrangeLineFeeds(spacing, formatProcessor);
        this.arrangeSpaces(spacing);
    }

    public int getIndentOffset() {
        return this.myIndentSpaces;
    }

    public int getSpaces() {
        return this.mySpaces;
    }

    public void setKeepFirstColumn(boolean b) {
        this.setFlag(4, b);
    }

    public void setLineFeedsAreReadOnly() {
        this.setLineFeedsAreReadOnly(true);
    }

    public void setReadOnly(boolean isReadOnly) {
        this.setIsReadOnly(isReadOnly);
    }

    public boolean isIsFirstWhiteSpace() {
        return this.getFlag(1);
    }

    public boolean isIsSafe() {
        return this.getFlag(2);
    }

    public boolean isKeepFirstColumn() {
        return this.getFlag(4);
    }

    public boolean isLineFeedsAreReadOnly() {
        return this.getFlag(8);
    }

    public void setLineFeedsAreReadOnly(boolean lineFeedsAreReadOnly) {
        this.setFlag(8, lineFeedsAreReadOnly);
    }

    public boolean isIsReadOnly() {
        return this.getFlag(16);
    }

    public void setIsReadOnly(boolean isReadOnly) {
        this.setFlag(16, isReadOnly);
    }

    public void setIsFirstWhiteSpace(boolean isFirstWhiteSpace) {
        this.setFlag(1, isFirstWhiteSpace);
    }

    public StringBuilder generateWhiteSpace(CommonCodeStyleSettings.IndentOptions indentOptions, int offset, IndentInfo indent) {
        StringBuilder result = new StringBuilder();
        int currentOffset = this.getStartOffset();
        CharSequence[] lines = this.getInitialLines();
        int currentLine = 0;
        for (int i = 0; i < lines.length - 1 && currentOffset + lines[i].length() <= offset; ++i) {
            result.append(lines[i]);
            currentOffset += lines[i].length();
            result.append('\n');
            ++currentLine;
            if (++currentOffset == offset) break;
        }
        String newIndentSpaces = indent.generateNewWhiteSpace(indentOptions);
        result.append(newIndentSpaces);
        WhiteSpace.appendNonWhitespaces(result, lines, currentLine);
        if (currentLine + 1 < lines.length) {
            result.append('\n');
            for (int i = currentLine + 1; i < lines.length - 1; ++i) {
                result.append(lines[i]);
                result.append('\n');
            }
            WhiteSpace.appendNonWhitespaces(result, lines, lines.length - 1);
            result.append(lines[lines.length - 1]);
        }
        return result;
    }

    @NotNull
    public IndentInside getInitialLastLineIndent() {
        IndentInside indentInside = new IndentInside(this.myInitialLastLinesSpaces, this.myInitialLastLinesTabs);
        if (indentInside == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/WhiteSpace", "getInitialLastLineIndent"));
        }
        return indentInside;
    }

    private static void appendNonWhitespaces(StringBuilder result, CharSequence[] lines, int currentLine) {
        if (currentLine != lines.length && !((Object)lines[currentLine]).toString().matches("\\s*")) {
            result.append(lines[currentLine]);
        }
    }

    private CharSequence[] getInitialLines() {
        if (this.myInitial == null) {
            return new CharSequence[]{""};
        }
        ArrayList<StringBuilder> result = new ArrayList<StringBuilder>();
        StringBuilder currentLine = new StringBuilder();
        for (int i = 0; i < this.myInitial.length(); ++i) {
            char c = this.myInitial.charAt(i);
            if (c == '\n') {
                result.add(currentLine);
                currentLine = new StringBuilder();
                continue;
            }
            currentLine.append(c);
        }
        result.add(currentLine);
        return result.toArray(new CharSequence[result.size()]);
    }

    public int getIndentSpaces() {
        return this.myIndentSpaces;
    }

    public int getLength() {
        return this.myEnd - this.myStart;
    }

    public final int getLineFeeds() {
        return this.myFlags >>> 7;
    }

    public void setLineFeeds(int lineFeeds) {
        assert (lineFeeds < 0x1000000);
        int flags = this.myFlags;
        this.myFlags &= 0x7F;
        this.myFlags |= lineFeeds << 7;
        assert (this.getLineFeeds() == lineFeeds);
        assert ((flags & 0x7F) == (this.myFlags & 0x7F));
    }

    public TextRange getTextRange() {
        return new TextRange(this.myStart, this.myEnd);
    }

    public String toString() {
        return "WhiteSpace(" + this.myStart + "-" + this.myEnd + " spaces=" + this.mySpaces + " LFs=" + this.getLineFeeds() + ")";
    }

    private static class WhiteSpaceInfo {
        public final int spaces;
        public final int indentSpaces;
        public final int lineFeeds;

        WhiteSpaceInfo(int lineFeeds, int indentSpaces, int spaces) {
            this.lineFeeds = lineFeeds;
            this.indentSpaces = indentSpaces;
            this.spaces = spaces;
        }
    }
}

