/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.FormatProcessor;
import com.intellij.formatting.SpacingImpl;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public class DependantSpacingImpl
extends SpacingImpl {
    private static final int DEPENDENCE_CONTAINS_LF_MASK = 16;
    private static final int DEPENDENT_REGION_LF_CHANGED_MASK = 32;
    @NotNull
    private final TextRange myDependency;
    @NotNull
    private final DependentSpacingRule myRule;

    public DependantSpacingImpl(int minSpaces, int maxSpaces, @NotNull TextRange dependency, boolean keepLineBreaks, int keepBlankLines, @NotNull DependentSpacingRule rule) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/formatting/DependantSpacingImpl", "<init>"));
        }
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/formatting/DependantSpacingImpl", "<init>"));
        }
        super(minSpaces, maxSpaces, 0, false, false, keepLineBreaks, keepBlankLines, false, 0);
        this.myDependency = dependency;
        this.myRule = rule;
    }

    @Override
    public int getMinLineFeeds() {
        if (!this.isTriggered()) {
            return super.getMinLineFeeds();
        }
        if (this.myRule.hasData(DependentSpacingRule.Anchor.MIN_LINE_FEEDS)) {
            return this.myRule.getData(DependentSpacingRule.Anchor.MIN_LINE_FEEDS);
        }
        if (this.myRule.hasData(DependentSpacingRule.Anchor.MAX_LINE_FEEDS)) {
            return this.myRule.getData(DependentSpacingRule.Anchor.MAX_LINE_FEEDS);
        }
        return super.getMinLineFeeds();
    }

    @Override
    public int getKeepBlankLines() {
        if (!this.isTriggered() || !this.myRule.hasData(DependentSpacingRule.Anchor.MAX_LINE_FEEDS)) {
            return super.getKeepBlankLines();
        }
        return 0;
    }

    @Override
    public void refresh(FormatProcessor formatter) {
        if (this.isDependentRegionChanged()) {
            return;
        }
        boolean value = formatter.containsLineFeeds(this.myDependency);
        this.myFlags = value ? (this.myFlags |= 0x10) : (this.myFlags &= 0xFFFFFFEF);
    }

    @NotNull
    public TextRange getDependency() {
        TextRange textRange = this.myDependency;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/DependantSpacingImpl", "getDependency"));
        }
        return textRange;
    }

    public final boolean isDependentRegionChanged() {
        return (this.myFlags & 0x20) != 0;
    }

    public final void setDependentRegionChanged() {
        this.myFlags |= 0x20;
        this.myFlags = this.getMinLineFeeds() <= 0 ? (this.myFlags |= 0x10) : (this.myFlags &= 0xFFFFFFEF);
    }

    @Override
    public String toString() {
        return "<DependantSpacing: minSpaces=" + this.getMinSpaces() + " maxSpaces=" + this.getMaxSpaces() + " minLineFeeds=" + this.getMinLineFeeds() + " dep=" + this.myDependency + ">";
    }

    private boolean isTriggered() {
        return this.myRule.getTrigger() == DependentSpacingRule.Trigger.HAS_LINE_FEEDS ^ (this.myFlags & 0x10) == 0;
    }
}

