/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelBuilderEx;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreFormatterUtil {
    private CoreFormatterUtil() {
    }

    @NotNull
    public static FormattingModel buildModel(@NotNull FormattingModelBuilder builder, @NotNull PsiElement element, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/formatting/CoreFormatterUtil", "buildModel"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/formatting/CoreFormatterUtil", "buildModel"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/formatting/CoreFormatterUtil", "buildModel"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/formatting/CoreFormatterUtil", "buildModel"));
        }
        if (builder instanceof FormattingModelBuilderEx) {
            FormattingModel formattingModel = ((FormattingModelBuilderEx)builder).createModel(element, settings, mode);
            if (formattingModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/CoreFormatterUtil", "buildModel"));
            }
            return formattingModel;
        }
        FormattingModel formattingModel = builder.createModel(element, settings);
        if (formattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/CoreFormatterUtil", "buildModel"));
        }
        return formattingModel;
    }

    @Nullable
    public static AlignmentImpl getAlignment(@NotNull AbstractBlockWrapper block) {
        AlignmentImpl alignment;
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/formatting/CoreFormatterUtil", "getAlignment"));
        }
        AbstractBlockWrapper current = block;
        while ((alignment = current.getAlignment()) == null || alignment.getOffsetRespBlockBefore(block) == null) {
            if ((current = current.getParent()) != null && current.getStartOffset() == block.getStartOffset()) continue;
            return null;
        }
        return alignment;
    }

    public static int getStartColumn(@Nullable LeafBlockWrapper block) {
        if (block != null) {
            int result = 0;
            do {
                WhiteSpace whiteSpace = block.getWhiteSpace();
                result += whiteSpace.getTotalSpaces();
                if (whiteSpace.containsLineFeeds()) {
                    return result;
                }
                if ((block = block.getPreviousBlock()) == null) {
                    return result;
                }
                result += block.getSymbolsAtTheLastLine();
            } while (!block.containsLineFeeds());
            return result;
        }
        return -1;
    }

    @Nullable
    public static AbstractBlockWrapper getIndentedParentBlock(@NotNull AbstractBlockWrapper block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/formatting/CoreFormatterUtil", "getIndentedParentBlock"));
        }
        for (CompositeBlockWrapper current = block.getParent(); current != null; current = current.getParent()) {
            AbstractBlockWrapper prevIndented;
            if (current.getStartOffset() != block.getStartOffset() && current.getWhiteSpace().containsLineFeeds()) {
                return current;
            }
            if (current.getParent() == null || (prevIndented = current.getParent().getPrevIndentedSibling(current)) == null) continue;
            return prevIndented;
        }
        return null;
    }

    public static boolean allowBackwardAlignment(@NotNull LeafBlockWrapper first, @NotNull LeafBlockWrapper second, @NotNull Map<AbstractBlockWrapper, Set<AbstractBlockWrapper>> alignmentMappings) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/formatting/CoreFormatterUtil", "allowBackwardAlignment"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/formatting/CoreFormatterUtil", "allowBackwardAlignment"));
        }
        if (alignmentMappings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/formatting/CoreFormatterUtil", "allowBackwardAlignment"));
        }
        HashSet<AbstractBlockWrapper> blocksBeforeCurrent = new HashSet<AbstractBlockWrapper>();
        for (LeafBlockWrapper previousBlock = second.getPreviousBlock(); previousBlock != null; previousBlock = previousBlock.getPreviousBlock()) {
            Set<AbstractBlockWrapper> blocks = alignmentMappings.get(previousBlock);
            if (blocks != null) {
                blocksBeforeCurrent.addAll(blocks);
            }
            if (previousBlock.getWhiteSpace().containsLineFeeds()) break;
        }
        for (LeafBlockWrapper next = first.getNextBlock(); next != null && !next.getWhiteSpace().containsLineFeeds(); next = next.getNextBlock()) {
            if (!blocksBeforeCurrent.contains(next)) continue;
            return false;
        }
        return true;
    }

    public static IndentData getIndent(CommonCodeStyleSettings.IndentOptions options, AbstractBlockWrapper block, int tokenBlockStartOffset) {
        IndentImpl indent = block.getIndent();
        if (indent.getType() == Indent.Type.CONTINUATION) {
            return new IndentData(options.CONTINUATION_INDENT_SIZE);
        }
        if (indent.getType() == Indent.Type.CONTINUATION_WITHOUT_FIRST) {
            if (block.getStartOffset() != block.getParent().getStartOffset() && block.getStartOffset() == tokenBlockStartOffset) {
                return new IndentData(options.CONTINUATION_INDENT_SIZE);
            }
            return new IndentData(0);
        }
        if (indent.getType() == Indent.Type.LABEL) {
            return new IndentData(options.LABEL_INDENT_SIZE);
        }
        if (indent.getType() == Indent.Type.NONE) {
            return new IndentData(0);
        }
        if (indent.getType() == Indent.Type.SPACES) {
            return new IndentData(0, indent.getSpaces());
        }
        return new IndentData(options.INDENT_SIZE);
    }

    @NotNull
    public static LeafBlockWrapper getFirstLeaf(@NotNull AbstractBlockWrapper block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/formatting/CoreFormatterUtil", "getFirstLeaf"));
        }
        if (block instanceof LeafBlockWrapper) {
            LeafBlockWrapper leafBlockWrapper = (LeafBlockWrapper)block;
            if (leafBlockWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/CoreFormatterUtil", "getFirstLeaf"));
            }
            return leafBlockWrapper;
        }
        LeafBlockWrapper leafBlockWrapper = CoreFormatterUtil.getFirstLeaf(((CompositeBlockWrapper)block).getChildren().get(0));
        if (leafBlockWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/CoreFormatterUtil", "getFirstLeaf"));
        }
        return leafBlockWrapper;
    }
}

